/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.palette;

import java.awt.image.BufferedImage;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.palette.Palette;

public final class Dithering {
    private Dithering() {
    }

    public static void applyFloydSteinbergDithering(BufferedImage image, Palette palette) throws ImageWriteException {
        for (int y2 = 0; y2 < image.getHeight(); ++y2) {
            for (int x2 = 0; x2 < image.getWidth(); ++x2) {
                int update2;
                int argb = image.getRGB(x2, y2);
                int index = palette.getPaletteIndex(argb);
                int nextArgb = palette.getEntry(index);
                image.setRGB(x2, y2, nextArgb);
                int a2 = argb >> 24 & 0xFF;
                int r2 = argb >> 16 & 0xFF;
                int g2 = argb >> 8 & 0xFF;
                int b2 = argb & 0xFF;
                int na = nextArgb >> 24 & 0xFF;
                int nr = nextArgb >> 16 & 0xFF;
                int ng = nextArgb >> 8 & 0xFF;
                int nb = nextArgb & 0xFF;
                int errA = a2 - na;
                int errR = r2 - nr;
                int errG = g2 - ng;
                int errB = b2 - nb;
                if (x2 + 1 < image.getWidth()) {
                    update2 = Dithering.adjustPixel(image.getRGB(x2 + 1, y2), errA, errR, errG, errB, 7);
                    image.setRGB(x2 + 1, y2, update2);
                    if (y2 + 1 < image.getHeight()) {
                        update2 = Dithering.adjustPixel(image.getRGB(x2 + 1, y2 + 1), errA, errR, errG, errB, 1);
                        image.setRGB(x2 + 1, y2 + 1, update2);
                    }
                }
                if (y2 + 1 >= image.getHeight()) continue;
                update2 = Dithering.adjustPixel(image.getRGB(x2, y2 + 1), errA, errR, errG, errB, 5);
                image.setRGB(x2, y2 + 1, update2);
                if (x2 - 1 < 0) continue;
                update2 = Dithering.adjustPixel(image.getRGB(x2 - 1, y2 + 1), errA, errR, errG, errB, 3);
                image.setRGB(x2 - 1, y2 + 1, update2);
            }
        }
    }

    private static int adjustPixel(int argb, int errA, int errR, int errG, int errB, int mul) {
        int a2 = argb >> 24 & 0xFF;
        int r2 = argb >> 16 & 0xFF;
        int g2 = argb >> 8 & 0xFF;
        int b2 = argb & 0xFF;
        r2 += errR * mul / 16;
        g2 += errG * mul / 16;
        b2 += errB * mul / 16;
        if ((a2 += errA * mul / 16) < 0) {
            a2 = 0;
        } else if (a2 > 255) {
            a2 = 255;
        }
        if (r2 < 0) {
            r2 = 0;
        } else if (r2 > 255) {
            r2 = 255;
        }
        if (g2 < 0) {
            g2 = 0;
        } else if (g2 > 255) {
            g2 = 255;
        }
        if (b2 < 0) {
            b2 = 0;
        } else if (b2 > 255) {
            b2 = 255;
        }
        return a2 << 24 | r2 << 16 | g2 << 8 | b2;
    }
}

