/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.palette;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.palette.ColorSpaceSubset;
import org.apache.commons.imaging.palette.LongestAxisMedianCut;
import org.apache.commons.imaging.palette.MedianCutQuantizer;
import org.apache.commons.imaging.palette.Palette;
import org.apache.commons.imaging.palette.QuantizedPalette;
import org.apache.commons.imaging.palette.SimplePalette;

public class PaletteFactory {
    private static final boolean DEBUG = false;
    public static final int COMPONENTS = 3;

    public Palette makeExactRgbPaletteFancy(BufferedImage src) {
        int mask;
        byte[] rgbmap = new byte[0x200000];
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                int argb = src.getRGB(x2, y2);
                int rggbb = 0x1FFFFF & argb;
                int highred = 7 & argb >> 21;
                mask = 1 << highred;
                int n2 = rggbb;
                rgbmap[n2] = (byte)(rgbmap[n2] | mask);
            }
        }
        int count = 0;
        for (byte element : rgbmap) {
            int eight = 0xFF & element;
            count += Integer.bitCount(eight);
        }
        int[] colormap = new int[count];
        int mapsize = 0;
        for (int i2 = 0; i2 < rgbmap.length; ++i2) {
            int eight = 0xFF & rgbmap[i2];
            mask = 128;
            for (int j2 = 0; j2 < 8; ++j2) {
                int bit = eight & mask;
                mask >>>= 1;
                if (bit <= 0) continue;
                int rgb = i2 | 7 - j2 << 21;
                colormap[mapsize++] = rgb;
            }
        }
        Arrays.sort(colormap);
        return new SimplePalette(colormap);
    }

    private int pixelToQuantizationTableIndex(int argb, int precision) {
        int result2 = 0;
        int precisionMask = (1 << precision) - 1;
        for (int i2 = 0; i2 < 3; ++i2) {
            int sample = argb & 0xFF;
            argb >>= 8;
            result2 = result2 << precision | (sample >>= 8 - precision) & precisionMask;
        }
        return result2;
    }

    private int getFrequencyTotal(int[] table2, int[] mins, int[] maxs, int precision) {
        int sum2 = 0;
        for (int blue = mins[2]; blue <= maxs[2]; ++blue) {
            int b2 = blue << 2 * precision;
            for (int green = mins[1]; green <= maxs[1]; ++green) {
                int g2 = green << 1 * precision;
                for (int red = mins[0]; red <= maxs[0]; ++red) {
                    int index = b2 | g2 | red;
                    sum2 += table2[index];
                }
            }
        }
        return sum2;
    }

    private DivisionCandidate finishDivision(ColorSpaceSubset subset, int component, int precision, int sum2, int slice2) {
        int total = subset.total;
        if (slice2 < subset.mins[component] || slice2 >= subset.maxs[component]) {
            return null;
        }
        if (sum2 < 1 || sum2 >= total) {
            return null;
        }
        int remainder = total - sum2;
        if (remainder < 1 || remainder >= total) {
            return null;
        }
        int[] sliceMins = new int[subset.mins.length];
        System.arraycopy(subset.mins, 0, sliceMins, 0, subset.mins.length);
        int[] sliceMaxs = new int[subset.maxs.length];
        System.arraycopy(subset.maxs, 0, sliceMaxs, 0, subset.maxs.length);
        sliceMaxs[component] = slice2;
        sliceMins[component] = slice2 + 1;
        ColorSpaceSubset first2 = new ColorSpaceSubset(sum2, precision, subset.mins, sliceMaxs);
        ColorSpaceSubset second2 = new ColorSpaceSubset(total - sum2, precision, sliceMins, subset.maxs);
        return new DivisionCandidate(first2, second2);
    }

    private List<DivisionCandidate> divideSubset2(int[] table2, ColorSpaceSubset subset, int component, int precision) {
        int total = subset.total;
        int[] sliceMins = new int[subset.mins.length];
        System.arraycopy(subset.mins, 0, sliceMins, 0, subset.mins.length);
        int[] sliceMaxs = new int[subset.maxs.length];
        System.arraycopy(subset.maxs, 0, sliceMaxs, 0, subset.maxs.length);
        int sum1 = 0;
        int last = 0;
        int slice1 = subset.mins[component];
        while (slice1 != subset.maxs[component] + 1) {
            sliceMins[component] = slice1;
            sliceMaxs[component] = slice1++;
            last = this.getFrequencyTotal(table2, sliceMins, sliceMaxs, precision);
            if ((sum1 += last) >= total / 2) break;
        }
        int sum2 = sum1 - last;
        int slice2 = slice1 - 1;
        DivisionCandidate dc1 = this.finishDivision(subset, component, precision, sum1, slice1);
        DivisionCandidate dc2 = this.finishDivision(subset, component, precision, sum2, slice2);
        ArrayList<DivisionCandidate> result2 = new ArrayList<DivisionCandidate>();
        if (dc1 != null) {
            result2.add(dc1);
        }
        if (dc2 != null) {
            result2.add(dc2);
        }
        return result2;
    }

    private DivisionCandidate divideSubset2(int[] table2, ColorSpaceSubset subset, int precision) {
        ArrayList<DivisionCandidate> dcs = new ArrayList<DivisionCandidate>();
        dcs.addAll(this.divideSubset2(table2, subset, 0, precision));
        dcs.addAll(this.divideSubset2(table2, subset, 1, precision));
        dcs.addAll(this.divideSubset2(table2, subset, 2, precision));
        DivisionCandidate bestV = null;
        double bestScore = Double.MAX_VALUE;
        for (DivisionCandidate dc2 : dcs) {
            ColorSpaceSubset first2 = dc2.dst_a;
            ColorSpaceSubset second2 = dc2.dst_b;
            int area1 = first2.total;
            int area2 = second2.total;
            int diff = Math.abs(area1 - area2);
            double score = (double)diff / (double)Math.max(area1, area2);
            if (bestV == null) {
                bestV = dc2;
                bestScore = score;
                continue;
            }
            if (!(score < bestScore)) continue;
            bestV = dc2;
            bestScore = score;
        }
        return bestV;
    }

    private List<ColorSpaceSubset> divide(List<ColorSpaceSubset> v2, int desiredCount, int[] table2, int precision) {
        ArrayList<ColorSpaceSubset> ignore = new ArrayList<ColorSpaceSubset>();
        do {
            int maxArea = -1;
            ColorSpaceSubset maxSubset = null;
            for (ColorSpaceSubset subset : v2) {
                if (ignore.contains(subset)) continue;
                int area2 = subset.total;
                if (maxSubset == null) {
                    maxSubset = subset;
                    maxArea = area2;
                    continue;
                }
                if (area2 <= maxArea) continue;
                maxSubset = subset;
                maxArea = area2;
            }
            if (maxSubset == null) {
                return v2;
            }
            DivisionCandidate dc2 = this.divideSubset2(table2, maxSubset, precision);
            if (dc2 != null) {
                v2.remove(maxSubset);
                v2.add(dc2.dst_a);
                v2.add(dc2.dst_b);
                continue;
            }
            ignore.add(maxSubset);
        } while (v2.size() != desiredCount);
        return v2;
    }

    public Palette makeQuantizedRgbPalette(BufferedImage src, int max) {
        int precision = 6;
        int tableScale = 18;
        int tableSize = 262144;
        int[] table2 = new int[262144];
        int width = src.getWidth();
        int height = src.getHeight();
        List<ColorSpaceSubset> subsets = new ArrayList<ColorSpaceSubset>();
        ColorSpaceSubset all2 = new ColorSpaceSubset(width * height, 6);
        subsets.add(all2);
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                int index;
                int argb = src.getRGB(x2, y2);
                int n2 = index = this.pixelToQuantizationTableIndex(argb, 6);
                table2[n2] = table2[n2] + 1;
            }
        }
        subsets = this.divide(subsets, max, table2, 6);
        for (int i2 = 0; i2 < subsets.size(); ++i2) {
            ColorSpaceSubset subset = subsets.get(i2);
            subset.setAverageRGB(table2);
        }
        Collections.sort(subsets, ColorSpaceSubset.RGB_COMPARATOR);
        return new QuantizedPalette(subsets, 6);
    }

    public Palette makeQuantizedRgbaPalette(BufferedImage src, boolean transparent, int max) throws ImageWriteException {
        return new MedianCutQuantizer(!transparent).process(src, max, new LongestAxisMedianCut(), false);
    }

    public SimplePalette makeExactRgbPaletteSimple(BufferedImage src, int max) {
        int rgb;
        HashSet<Integer> rgbs = new HashSet<Integer>();
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                int argb = src.getRGB(x2, y2);
                rgb = 0xFFFFFF & argb;
                if (!rgbs.add(rgb) || rgbs.size() <= max) continue;
                return null;
            }
        }
        int[] result2 = new int[rgbs.size()];
        int next2 = 0;
        Iterator iterator2 = rgbs.iterator();
        while (iterator2.hasNext()) {
            rgb = (Integer)iterator2.next();
            result2[next2++] = rgb;
        }
        Arrays.sort(result2);
        return new SimplePalette(result2);
    }

    public boolean isGrayscale(BufferedImage src) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (6 == src.getColorModel().getColorSpace().getType()) {
            return true;
        }
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                int argb = src.getRGB(x2, y2);
                int red = 0xFF & argb >> 16;
                int green = 0xFF & argb >> 8;
                int blue = 0xFF & argb >> 0;
                if (red == green && red == blue) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasTransparency(BufferedImage src) {
        return this.hasTransparency(src, 255);
    }

    public boolean hasTransparency(BufferedImage src, int threshold) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (!src.getColorModel().hasAlpha()) {
            return false;
        }
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                int argb = src.getRGB(x2, y2);
                int alpha = 0xFF & argb >> 24;
                if (alpha >= threshold) continue;
                return true;
            }
        }
        return false;
    }

    public int countTrasparentColors(int[] rgbs) {
        int first2 = -1;
        for (int rgb : rgbs) {
            int alpha = 0xFF & rgb >> 24;
            if (alpha >= 255) continue;
            if (first2 < 0) {
                first2 = rgb;
                continue;
            }
            if (rgb == first2) continue;
            return 2;
        }
        if (first2 < 0) {
            return 0;
        }
        return 1;
    }

    public int countTransparentColors(BufferedImage src) {
        ColorModel cm2 = src.getColorModel();
        if (!cm2.hasAlpha()) {
            return 0;
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int first2 = -1;
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                int rgb = src.getRGB(x2, y2);
                int alpha = 0xFF & rgb >> 24;
                if (alpha >= 255) continue;
                if (first2 < 0) {
                    first2 = rgb;
                    continue;
                }
                if (rgb == first2) continue;
                return 2;
            }
        }
        if (first2 < 0) {
            return 0;
        }
        return 1;
    }

    private static class DivisionCandidate {
        private final ColorSpaceSubset dst_a;
        private final ColorSpaceSubset dst_b;

        public DivisionCandidate(ColorSpaceSubset dst_a, ColorSpaceSubset dst_b) {
            this.dst_a = dst_a;
            this.dst_b = dst_b;
        }
    }
}

