/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.velocity.util.introspection.Converter;
import org.apache.velocity.util.introspection.IntrospectionUtils;
import org.apache.velocity.util.introspection.TypeConversionHandler;

public class TypeConversionHandlerImpl
implements TypeConversionHandler {
    static Map<Pair<String, String>, Converter<?>> standardConverterMap = new HashMap();
    static Converter<?> toString;
    static Converter<?> cacheMiss;
    Map<Pair<String, String>, Converter<?>> converterCacheMap = new ConcurrentHashMap();
    static final String BOOLEAN_TYPE = "boolean";
    static final String BYTE_TYPE = "byte";
    static final String SHORT_TYPE = "short";
    static final String INTEGER_TYPE = "int";
    static final String LONG_TYPE = "long";
    static final String FLOAT_TYPE = "float";
    static final String DOUBLE_TYPE = "double";
    static final String CHARACTER_TYPE = "char";
    static final String BOOLEAN_CLASS = "java.lang.Boolean";
    static final String BYTE_CLASS = "java.lang.Byte";
    static final String SHORT_CLASS = "java.lang.Short";
    static final String INTEGER_CLASS = "java.lang.Integer";
    static final String LONG_CLASS = "java.lang.Long";
    static final String BIG_INTEGER_CLASS = "java.math.BigInteger";
    static final String FLOAT_CLASS = "java.lang.Float";
    static final String DOUBLE_CLASS = "java.lang.Double";
    static final String BIG_DECIMAL_CLASS = "java.math.BigDecimal";
    static final String NUMBER_CLASS = "java.lang.Number";
    static final String CHARACTER_CLASS = "java.lang.Character";
    static final String STRING_CLASS = "java.lang.String";
    static final String LOCALE_CLASS = "java.util.Locale";

    static boolean checkBounds(Number n2, double min, double max) {
        double d2 = n2.doubleValue();
        if (d2 < min || d2 > max) {
            throw new NumberFormatException("value out of range: " + n2);
        }
        return true;
    }

    @Override
    public boolean isExplicitlyConvertible(Type formal, Class<?> actual, boolean possibleVarArg) {
        Class<?> formalClass = IntrospectionUtils.getTypeClass(formal);
        if (formalClass != null && formalClass == actual || IntrospectionUtils.isMethodInvocationConvertible(formal, actual, possibleVarArg) || this.getNeededConverter(formal, actual) != null) {
            return true;
        }
        if (possibleVarArg && TypeUtils.isArrayType((Type)formal)) {
            if (actual.isArray()) {
                actual = actual.getComponentType();
            }
            return this.isExplicitlyConvertible(TypeUtils.getArrayComponentType((Type)formal), actual, false);
        }
        return false;
    }

    @Override
    public Converter<?> getNeededConverter(Type formal, Class<?> actual) {
        if (actual == null) {
            return null;
        }
        Pair key = Pair.of((Object)formal.getTypeName(), (Object)actual.getTypeName());
        Converter<Object> converter = standardConverterMap.get(key);
        if (converter == null && (converter = this.converterCacheMap.get(key)) == null) {
            Class<?> formalClass = IntrospectionUtils.getTypeClass(formal);
            if (formal == String.class) {
                converter = toString;
            } else if (formalClass != null && formalClass.isEnum() && actual == String.class) {
                Class<?> enumClass = formalClass;
                converter = o2 -> Enum.valueOf(enumClass, (String)o2);
            }
            this.converterCacheMap.put((Pair<String, String>)key, converter == null ? cacheMiss : converter);
        }
        return converter == cacheMiss ? null : converter;
    }

    @Override
    public void addConverter(Type formal, Class<?> actual, Converter<?> converter) {
        Pair key = Pair.of((Object)formal.getTypeName(), (Object)actual.getTypeName());
        this.converterCacheMap.put((Pair<String, String>)key, converter);
        Class<?> formalClass = IntrospectionUtils.getTypeClass(formal);
        if (formalClass != null) {
            if (formalClass.isPrimitive()) {
                key = Pair.of((Object)IntrospectionUtils.getBoxedClass(formalClass).getTypeName(), (Object)actual.getTypeName());
                this.converterCacheMap.put((Pair<String, String>)key, converter);
            } else {
                Class<?> unboxedFormal = IntrospectionUtils.getUnboxedClass(formalClass);
                if (unboxedFormal != formalClass) {
                    key = Pair.of((Object)unboxedFormal.getTypeName(), (Object)actual.getTypeName());
                    this.converterCacheMap.put((Pair<String, String>)key, converter);
                }
            }
        }
    }

    static {
        cacheMiss = o2 -> o2;
        Converter<Boolean> numberToBool = o2 -> Optional.ofNullable((Number)o2).map(n2 -> Double.compare(n2.doubleValue(), 0.0) != 0).orElse(null);
        Converter<Boolean> bigIntegerToBool = o2 -> Optional.ofNullable((BigInteger)o2).map(bi2 -> bi2.signum() != 0).orElse(null);
        Converter<Boolean> bigDecimalToBool = o2 -> Optional.ofNullable((BigDecimal)o2).map(bi2 -> bi2.signum() != 0).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)BYTE_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)SHORT_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)INTEGER_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)LONG_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)BIG_INTEGER_CLASS), bigIntegerToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)FLOAT_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)DOUBLE_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)BIG_DECIMAL_CLASS), bigDecimalToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)NUMBER_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)BYTE_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)SHORT_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)INTEGER_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)LONG_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)FLOAT_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)DOUBLE_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)BYTE_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)SHORT_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)INTEGER_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)BIG_INTEGER_CLASS), bigIntegerToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)LONG_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)FLOAT_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)DOUBLE_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)BIG_DECIMAL_CLASS), bigDecimalToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)NUMBER_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)BYTE_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)SHORT_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)INTEGER_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)LONG_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)FLOAT_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)DOUBLE_TYPE), numberToBool);
        Converter<Boolean> charToBoolean = o2 -> Optional.ofNullable((Character)o2).map(c2 -> c2.charValue() != '\u0000').orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)CHARACTER_CLASS), charToBoolean);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)CHARACTER_TYPE), charToBoolean);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)CHARACTER_CLASS), charToBoolean);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)CHARACTER_TYPE), charToBoolean);
        Converter<Boolean> stringToBoolean = o2 -> Boolean.valueOf(String.valueOf(o2));
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)STRING_CLASS), stringToBoolean);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)STRING_CLASS), stringToBoolean);
        Converter<Byte> narrowingToByte = o2 -> Optional.ofNullable((Number)o2).filter(n2 -> TypeConversionHandlerImpl.checkBounds(n2, -128.0, 127.0)).map(Number::byteValue).orElse(null);
        Converter<Byte> narrowingBigIntegerToByte = o2 -> Optional.ofNullable((BigInteger)o2).map(BigInteger::byteValueExact).orElse(null);
        Converter<Byte> narrowingBigDecimalToByte = o2 -> Optional.ofNullable((BigDecimal)o2).map(BigDecimal::byteValueExact).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)SHORT_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)INTEGER_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)LONG_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)BIG_INTEGER_CLASS), narrowingBigIntegerToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)FLOAT_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)DOUBLE_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)BIG_DECIMAL_CLASS), narrowingBigDecimalToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)NUMBER_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)SHORT_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)INTEGER_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)LONG_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)FLOAT_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)DOUBLE_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)SHORT_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)INTEGER_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)LONG_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)BIG_INTEGER_CLASS), narrowingBigIntegerToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)FLOAT_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)DOUBLE_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)BIG_DECIMAL_CLASS), narrowingBigDecimalToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)NUMBER_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)SHORT_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)INTEGER_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)LONG_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)FLOAT_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)DOUBLE_TYPE), narrowingToByte);
        Converter<Byte> stringToByte = o2 -> Byte.valueOf(String.valueOf(o2));
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)STRING_CLASS), stringToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)STRING_CLASS), stringToByte);
        Converter<Short> narrowingToShort = o2 -> Optional.ofNullable((Number)o2).filter(n2 -> TypeConversionHandlerImpl.checkBounds(n2, -32768.0, 32767.0)).map(Number::shortValue).orElse(null);
        Converter<Short> narrowingBigIntegerToShort = o2 -> Optional.ofNullable((BigInteger)o2).map(BigInteger::shortValueExact).orElse(null);
        Converter<Short> narrowingBigDecimalToShort = o2 -> Optional.ofNullable((BigDecimal)o2).map(BigDecimal::shortValueExact).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)INTEGER_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)LONG_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)BIG_INTEGER_CLASS), narrowingBigIntegerToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)FLOAT_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)DOUBLE_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)BIG_DECIMAL_CLASS), narrowingBigDecimalToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)NUMBER_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)INTEGER_TYPE), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)LONG_TYPE), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)FLOAT_TYPE), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)DOUBLE_TYPE), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)INTEGER_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)LONG_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)BIG_INTEGER_CLASS), narrowingBigIntegerToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)FLOAT_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)DOUBLE_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)BIG_DECIMAL_CLASS), narrowingBigDecimalToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)NUMBER_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)INTEGER_TYPE), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)LONG_TYPE), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)FLOAT_TYPE), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)DOUBLE_TYPE), narrowingToShort);
        Converter<Short> wideningToShort = o2 -> Optional.ofNullable((Number)o2).map(Number::shortValue).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)BYTE_CLASS), wideningToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)BYTE_TYPE), wideningToShort);
        Converter<Short> stringToShort = o2 -> Short.valueOf(String.valueOf(o2));
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)STRING_CLASS), stringToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)STRING_CLASS), stringToShort);
        Converter<Integer> narrowingToInteger = o2 -> Optional.ofNullable((Number)o2).filter(n2 -> TypeConversionHandlerImpl.checkBounds(n2, -2.147483648E9, 2.147483647E9)).map(Number::intValue).orElse(null);
        Converter<Integer> narrowingBigIntegerToInteger = o2 -> Optional.ofNullable((BigInteger)o2).map(BigInteger::intValueExact).orElse(null);
        Converter<Integer> narrowingBigDecimalToInteger = o2 -> Optional.ofNullable((BigDecimal)o2).map(BigDecimal::intValueExact).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)LONG_CLASS), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)BIG_INTEGER_CLASS), narrowingBigIntegerToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)FLOAT_CLASS), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)DOUBLE_CLASS), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)BIG_DECIMAL_CLASS), narrowingBigDecimalToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)NUMBER_CLASS), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)LONG_TYPE), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)FLOAT_TYPE), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)DOUBLE_TYPE), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)LONG_CLASS), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)BIG_INTEGER_CLASS), narrowingBigIntegerToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)FLOAT_CLASS), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)DOUBLE_CLASS), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)BIG_DECIMAL_CLASS), narrowingBigDecimalToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)NUMBER_CLASS), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)LONG_TYPE), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)FLOAT_TYPE), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)DOUBLE_TYPE), narrowingToInteger);
        Converter<Integer> wideningToInteger = o2 -> Optional.ofNullable((Number)o2).map(Number::intValue).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)BYTE_CLASS), wideningToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)SHORT_CLASS), wideningToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)BYTE_TYPE), wideningToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)SHORT_TYPE), wideningToInteger);
        Converter<Integer> stringToInteger = o2 -> Integer.valueOf(String.valueOf(o2));
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)STRING_CLASS), stringToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)STRING_CLASS), stringToInteger);
        Converter<Long> narrowingToLong = o2 -> Optional.ofNullable((Number)o2).filter(n2 -> TypeConversionHandlerImpl.checkBounds(n2, -9.223372036854776E18, 9.223372036854776E18)).map(Number::longValue).orElse(null);
        Converter<Long> narrowingBigIntegerToLong = o2 -> Optional.ofNullable((BigInteger)o2).map(BigInteger::longValueExact).orElse(null);
        Converter<Long> narrowingBigDecimalToLong = o2 -> Optional.ofNullable((BigDecimal)o2).map(BigDecimal::longValueExact).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)BIG_INTEGER_CLASS), narrowingBigIntegerToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)FLOAT_CLASS), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)DOUBLE_CLASS), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)BIG_DECIMAL_CLASS), narrowingBigDecimalToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)NUMBER_CLASS), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)FLOAT_TYPE), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)DOUBLE_TYPE), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)BIG_INTEGER_CLASS), narrowingBigIntegerToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)FLOAT_CLASS), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)DOUBLE_CLASS), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)BIG_DECIMAL_CLASS), narrowingBigDecimalToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)NUMBER_CLASS), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)FLOAT_TYPE), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)DOUBLE_TYPE), narrowingToLong);
        Converter<Long> wideningToLong = o2 -> Optional.ofNullable((Number)o2).map(Number::longValue).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)BYTE_CLASS), wideningToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)SHORT_CLASS), wideningToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)INTEGER_CLASS), wideningToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)BYTE_TYPE), wideningToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)SHORT_TYPE), wideningToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)INTEGER_TYPE), wideningToLong);
        Converter<Long> stringToLong = o2 -> Long.valueOf(String.valueOf(o2));
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)STRING_CLASS), stringToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)STRING_CLASS), stringToLong);
        Converter<BigInteger> toBigInteger = o2 -> Optional.ofNullable((Number)o2).map(n2 -> BigInteger.valueOf(n2.longValue())).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_INTEGER_CLASS, (Object)BYTE_CLASS), toBigInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_INTEGER_CLASS, (Object)SHORT_CLASS), toBigInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_INTEGER_CLASS, (Object)INTEGER_CLASS), toBigInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_INTEGER_CLASS, (Object)LONG_CLASS), toBigInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_INTEGER_CLASS, (Object)BYTE_TYPE), toBigInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_INTEGER_CLASS, (Object)SHORT_TYPE), toBigInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_INTEGER_CLASS, (Object)INTEGER_TYPE), toBigInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_INTEGER_CLASS, (Object)LONG_TYPE), toBigInteger);
        Converter<BigInteger> bigDecimalToBigInteger = o2 -> Optional.ofNullable((BigDecimal)o2).map(BigDecimal::toBigIntegerExact).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_INTEGER_CLASS, (Object)BIG_DECIMAL_CLASS), bigDecimalToBigInteger);
        Converter<BigInteger> stringToBigInteger = o2 -> Optional.ofNullable(o2).map(s2 -> new BigInteger(String.valueOf(s2))).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_INTEGER_CLASS, (Object)STRING_CLASS), stringToBigInteger);
        Converter<Float> toFloat = o2 -> Optional.ofNullable((Number)o2).map(Number::floatValue).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)BIG_INTEGER_CLASS), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)DOUBLE_CLASS), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)BIG_DECIMAL_CLASS), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)NUMBER_CLASS), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)DOUBLE_TYPE), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_TYPE, (Object)BIG_INTEGER_CLASS), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_TYPE, (Object)DOUBLE_CLASS), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_TYPE, (Object)BIG_DECIMAL_CLASS), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_TYPE, (Object)NUMBER_CLASS), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_TYPE, (Object)DOUBLE_TYPE), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)BYTE_CLASS), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)SHORT_CLASS), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)INTEGER_CLASS), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)LONG_CLASS), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)BYTE_TYPE), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)SHORT_TYPE), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)INTEGER_TYPE), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)LONG_TYPE), toFloat);
        Converter<Float> stringToFloat = o2 -> Float.valueOf(String.valueOf(o2));
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)STRING_CLASS), stringToFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_TYPE, (Object)STRING_CLASS), stringToFloat);
        Converter<Double> toDouble = o2 -> Optional.ofNullable((Number)o2).map(Number::doubleValue).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)BIG_INTEGER_CLASS), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)BIG_DECIMAL_CLASS), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_TYPE, (Object)BIG_INTEGER_CLASS), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_TYPE, (Object)BIG_DECIMAL_CLASS), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)BYTE_CLASS), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)SHORT_CLASS), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)INTEGER_CLASS), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)LONG_CLASS), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)FLOAT_CLASS), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)NUMBER_CLASS), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)BYTE_TYPE), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)SHORT_TYPE), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)INTEGER_TYPE), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)LONG_TYPE), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)FLOAT_TYPE), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_TYPE, (Object)NUMBER_CLASS), toDouble);
        Converter<Double> stringToDouble = o2 -> Double.valueOf(String.valueOf(o2));
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)STRING_CLASS), stringToDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_TYPE, (Object)STRING_CLASS), stringToDouble);
        Converter<BigDecimal> exactToBigDecimal = o2 -> Optional.ofNullable((Number)o2).map(n2 -> BigDecimal.valueOf(n2.longValue())).orElse(null);
        Converter<BigDecimal> bigIntegerToBigDecimal = o2 -> Optional.ofNullable((BigInteger)o2).map(bi2 -> new BigDecimal((BigInteger)bi2)).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_DECIMAL_CLASS, (Object)BYTE_CLASS), exactToBigDecimal);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_DECIMAL_CLASS, (Object)SHORT_CLASS), exactToBigDecimal);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_DECIMAL_CLASS, (Object)INTEGER_CLASS), exactToBigDecimal);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_DECIMAL_CLASS, (Object)LONG_CLASS), exactToBigDecimal);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_DECIMAL_CLASS, (Object)BIG_INTEGER_CLASS), bigIntegerToBigDecimal);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_DECIMAL_CLASS, (Object)BYTE_TYPE), exactToBigDecimal);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_DECIMAL_CLASS, (Object)SHORT_TYPE), exactToBigDecimal);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_DECIMAL_CLASS, (Object)INTEGER_TYPE), exactToBigDecimal);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_DECIMAL_CLASS, (Object)LONG_TYPE), exactToBigDecimal);
        Converter<BigDecimal> approxToBigDecimal = o2 -> Optional.ofNullable((Number)o2).map(n2 -> BigDecimal.valueOf(n2.doubleValue())).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_DECIMAL_CLASS, (Object)FLOAT_CLASS), approxToBigDecimal);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_DECIMAL_CLASS, (Object)DOUBLE_CLASS), approxToBigDecimal);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_DECIMAL_CLASS, (Object)FLOAT_TYPE), approxToBigDecimal);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_DECIMAL_CLASS, (Object)DOUBLE_TYPE), approxToBigDecimal);
        Converter<BigDecimal> stringToBigDecimal = o2 -> Optional.ofNullable(o2).map(s2 -> new BigDecimal(String.valueOf(s2))).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BIG_DECIMAL_CLASS, (Object)STRING_CLASS), stringToBigDecimal);
        Converter<Byte> booleanToByte = o2 -> Optional.ofNullable((Boolean)o2).map(b2 -> b2 != false ? (byte)1 : (byte)0).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)BOOLEAN_CLASS), booleanToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)BOOLEAN_TYPE), booleanToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)BOOLEAN_CLASS), booleanToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)BOOLEAN_TYPE), booleanToByte);
        Converter<Short> booleanToShort = o2 -> Optional.ofNullable((Boolean)o2).map(b2 -> b2 != false ? (short)1 : (short)0).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)BOOLEAN_CLASS), booleanToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)BOOLEAN_TYPE), booleanToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)BOOLEAN_CLASS), booleanToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)BOOLEAN_TYPE), booleanToShort);
        Converter<Integer> booleanToInteger = o2 -> Optional.ofNullable((Boolean)o2).map(b2 -> b2 != false ? 1 : 0).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)BOOLEAN_CLASS), booleanToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)BOOLEAN_TYPE), booleanToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)BOOLEAN_CLASS), booleanToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)BOOLEAN_TYPE), booleanToInteger);
        Converter<Long> booleanToLong = o2 -> Optional.ofNullable((Boolean)o2).map(b2 -> b2 != false ? 1L : 0L).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)BOOLEAN_CLASS), booleanToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)BOOLEAN_TYPE), booleanToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)BOOLEAN_CLASS), booleanToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)BOOLEAN_TYPE), booleanToLong);
        toString = o2 -> String.valueOf(o2);
        Converter<Locale> stringToLocale = o2 -> Optional.ofNullable(o2).map(l2 -> LocaleUtils.toLocale((String)String.valueOf(l2))).orElse(null);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LOCALE_CLASS, (Object)STRING_CLASS), stringToLocale);
    }
}

