/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.util.Strings;

abstract class FieldHolder<T> {
    protected final Map<String, T> fieldHolder = new TreeMap<String, T>();

    public void put(String fieldLocation, T entity) {
        this.fieldHolder.put(fieldLocation, entity);
    }

    public T get(String fieldLocation) {
        return this.fieldHolder.get(fieldLocation);
    }

    public boolean hasEntity(String fieldLocation) {
        return this.fieldHolder.containsKey(fieldLocation);
    }

    public boolean isEmpty() {
        return this.fieldHolder.isEmpty();
    }

    public Stream<Map.Entry<String, T>> entryByField() {
        return this.fieldHolder.entrySet().stream();
    }

    public String toString() {
        List registeredEntitiesDescription = this.fieldHolder.entrySet().stream().map(FieldHolder::formatRegisteredEntity).collect(Collectors.toList());
        return "{%s}".formatted(Strings.join(registeredEntitiesDescription).with(", "));
    }

    private static <T> String formatRegisteredEntity(Map.Entry<String, T> entry) {
        return "%s -> %s".formatted(entry.getKey(), entry.getValue());
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        FieldHolder that = (FieldHolder)o2;
        return this.fieldHolder.equals(that.fieldHolder);
    }

    public int hashCode() {
        return Objects.hash(this.fieldHolder);
    }
}

