/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.Set;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Strings;
import org.assertj.core.util.Throwables;

public class ShouldNotContainCharSequence
extends BasicErrorMessageFactory {
    private ShouldNotContainCharSequence(String format2, CharSequence actual, CharSequence sequence2, ComparisonStrategy comparisonStrategy) {
        super(format2, actual, sequence2, comparisonStrategy);
    }

    private ShouldNotContainCharSequence(String format2, CharSequence actual, CharSequence[] values, Set<? extends CharSequence> found, ComparisonStrategy comparisonStrategy) {
        super(format2, actual, values, found, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldNotContain(CharSequence actual, CharSequence sequence2, ComparisonStrategy comparisonStrategy) {
        return new ShouldNotContainCharSequence("%nExpecting actual:%n  %s%nnot to contain:%n  %s%n%s", actual, sequence2, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldNotContain(CharSequence actual, CharSequence sequence2) {
        return ShouldNotContainCharSequence.shouldNotContain(actual, sequence2, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldNotContain(Throwable actual, CharSequence sequence2) {
        String format2 = "%nExpecting throwable message:%n  %s%nnot to contain:%n  %s%nbut did:%n%nThrowable that failed the check:%n%n" + Strings.escapePercent(Throwables.getStackTrace(actual));
        return new ShouldNotContainCharSequence(format2, actual.getMessage(), sequence2, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldNotContain(Throwable actual, CharSequence[] sequence2, Set<? extends CharSequence> found) {
        String format2 = "%nExpecting throwable message:%n  %s%nnot to contain:%n  %s%nbut found:%n  %s%n%nThrowable that failed the check:%n%n" + Strings.escapePercent(Throwables.getStackTrace(actual));
        return new ShouldNotContainCharSequence(format2, actual.getMessage(), sequence2, found, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldNotContain(CharSequence actual, CharSequence[] values, Set<? extends CharSequence> found, ComparisonStrategy comparisonStrategy) {
        return new ShouldNotContainCharSequence("%nExpecting actual:%n  %s%nnot to contain:%n  %s%nbut found:%n  %s%n%s", actual, values, found, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldNotContainIgnoringCase(CharSequence actual, CharSequence sequence2) {
        return new ShouldNotContainCharSequence("%nExpecting actual:%n  %s%nnot to contain (ignoring case):%n  %s%n%s", actual, sequence2, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldNotContainIgnoringCase(CharSequence actual, CharSequence[] sequences, Set<CharSequence> foundSequences) {
        return new ShouldNotContainCharSequence("%nExpecting actual:%n  %s%nnot to contain (ignoring case):%n  %s%nbut found:%n  %s%n%s", actual, sequences, foundSequences, StandardComparisonStrategy.instance());
    }
}

