/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

public class BinaryDiffResult {
    private static final int EOF = -1;
    public final int offset;
    public final String expected;
    public final String actual;

    public BinaryDiffResult(int offset, int expected, int actual) {
        this.offset = offset;
        this.expected = this.describe(expected);
        this.actual = this.describe(actual);
    }

    public boolean hasNoDiff() {
        return this.offset == -1;
    }

    public boolean hasDiff() {
        return !this.hasNoDiff();
    }

    public static BinaryDiffResult noDiff() {
        return new BinaryDiffResult(-1, 0, 0);
    }

    private String describe(int b2) {
        return b2 == -1 ? "EOF" : "0x" + Integer.toHexString(b2).toUpperCase();
    }
}

