/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.data.Index;
import org.assertj.core.error.ShouldHaveAtLeastOneElementOfType;
import org.assertj.core.error.ShouldHaveExactlyTypes;
import org.assertj.core.error.ShouldHaveOnlyElementsOfType;
import org.assertj.core.error.ShouldNotHaveAnyElementsOfTypes;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Conditions;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.IterableDiff;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Lists;

public class ObjectArrays {
    private static final ObjectArrays INSTANCE = new ObjectArrays();
    private Arrays arrays = Arrays.instance();
    Failures failures = Failures.instance();
    Conditions conditions = Conditions.instance();

    public static ObjectArrays instance() {
        return INSTANCE;
    }

    ObjectArrays() {
        this(StandardComparisonStrategy.instance());
    }

    public ObjectArrays(ComparisonStrategy comparisonStrategy) {
        this.setArrays(new Arrays(comparisonStrategy));
    }

    void setArrays(Arrays arrays) {
        this.arrays = arrays;
    }

    public Comparator<?> getComparator() {
        return this.arrays.getComparator();
    }

    public ComparisonStrategy getComparisonStrategy() {
        return this.arrays.getComparisonStrategy();
    }

    public void assertNullOrEmpty(AssertionInfo info, Object[] actual) {
        this.arrays.assertNullOrEmpty(info, this.failures, actual);
    }

    public void assertEmpty(AssertionInfo info, Object[] actual) {
        this.arrays.assertEmpty(info, this.failures, actual);
    }

    public void assertNotEmpty(AssertionInfo info, Object[] actual) {
        this.arrays.assertNotEmpty(info, this.failures, actual);
    }

    public void assertHasSize(AssertionInfo info, Object[] actual, int expectedSize) {
        this.arrays.assertHasSize(info, actual, expectedSize);
    }

    public void assertHasSizeGreaterThan(AssertionInfo info, Object[] actual, int boundary) {
        this.arrays.assertHasSizeGreaterThan(info, actual, boundary);
    }

    public void assertHasSizeGreaterThanOrEqualTo(AssertionInfo info, Object[] actual, int boundary) {
        this.arrays.assertHasSizeGreaterThanOrEqualTo(info, actual, boundary);
    }

    public void assertHasSizeLessThan(AssertionInfo info, Object[] actual, int boundary) {
        this.arrays.assertHasSizeLessThan(info, actual, boundary);
    }

    public void assertHasSizeLessThanOrEqualTo(AssertionInfo info, Object[] actual, int boundary) {
        this.arrays.assertHasSizeLessThanOrEqualTo(info, actual, boundary);
    }

    public void assertHasSizeBetween(AssertionInfo info, Object[] actual, int lowerBoundary, int higherBoundary) {
        this.arrays.assertHasSizeBetween(info, actual, lowerBoundary, higherBoundary);
    }

    public void assertHasSameSizeAs(AssertionInfo info, Object[] actual, Iterable<?> other) {
        this.arrays.assertHasSameSizeAs(info, (Object)actual, other);
    }

    public void assertHasSameSizeAs(AssertionInfo info, Object[] actual, Object other) {
        this.arrays.assertHasSameSizeAs(info, (Object)actual, other);
    }

    public void assertContains(AssertionInfo info, Object[] actual, Object[] values) {
        this.arrays.assertContains(info, this.failures, actual, values);
    }

    public void assertContains(AssertionInfo info, Object[] actual, Object value, Index index) {
        this.arrays.assertContains(info, this.failures, actual, value, index);
    }

    public void assertDoesNotContain(AssertionInfo info, Object[] actual, Object value, Index index) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, value, index);
    }

    public void assertContainsOnly(AssertionInfo info, Object[] actual, Object[] values) {
        this.arrays.assertContainsOnly(info, this.failures, actual, values);
    }

    public void assertContainsExactly(AssertionInfo info, Object[] actual, Object[] values) {
        this.arrays.assertContainsExactly(info, this.failures, actual, values);
    }

    public void assertContainsExactlyInAnyOrder(AssertionInfo info, Object[] actual, Object[] values) {
        this.arrays.assertContainsExactlyInAnyOrder(info, this.failures, actual, values);
    }

    public void assertContainsOnlyOnce(AssertionInfo info, Object[] actual, Object[] values) {
        this.arrays.assertContainsOnlyOnce(info, this.failures, actual, values);
    }

    public void assertContainsOnlyNulls(AssertionInfo info, Object[] actual) {
        this.arrays.assertContainsOnlyNulls(info, this.failures, actual);
    }

    public void assertContainsSequence(AssertionInfo info, Object[] actual, Object[] sequence2) {
        this.arrays.assertContainsSequence(info, this.failures, actual, sequence2);
    }

    public void assertDoesNotContainSequence(AssertionInfo info, Object[] actual, Object[] sequence2) {
        this.arrays.assertDoesNotContainSequence(info, this.failures, actual, sequence2);
    }

    public void assertContainsSubsequence(AssertionInfo info, Object[] actual, Object[] subsequence) {
        this.arrays.assertContainsSubsequence(info, this.failures, actual, subsequence);
    }

    public void assertDoesNotContainSubsequence(AssertionInfo info, Object[] actual, Object[] subsequence) {
        this.arrays.assertDoesNotContainSubsequence(info, this.failures, actual, subsequence);
    }

    public void assertDoesNotContain(AssertionInfo info, Object[] actual, Object[] values) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, values);
    }

    public <T> void assertDoesNotContainAnyElementsOf(AssertionInfo info, Object[] actual, Iterable<? extends T> iterable) {
        CommonValidations.checkIsNotNullAndNotEmpty(iterable);
        ArrayList<T> values = Lists.newArrayList(iterable);
        this.assertDoesNotContain(info, actual, values.toArray());
    }

    public void assertDoesNotHaveDuplicates(AssertionInfo info, Object[] actual) {
        this.arrays.assertDoesNotHaveDuplicates(info, this.failures, actual);
    }

    public void assertStartsWith(AssertionInfo info, Object[] actual, Object[] sequence2) {
        this.arrays.assertStartsWith(info, this.failures, actual, sequence2);
    }

    public void assertEndsWith(AssertionInfo info, Object[] actual, Object first2, Object[] rest) {
        this.arrays.assertEndsWith(info, this.failures, actual, first2, rest);
    }

    public void assertEndsWith(AssertionInfo info, Object[] actual, Object[] sequence2) {
        this.arrays.assertEndsWith(info, this.failures, actual, sequence2);
    }

    public void assertIsSubsetOf(AssertionInfo info, Object actual, Iterable<?> values) {
        this.arrays.assertIsSubsetOf(info, this.failures, actual, values);
    }

    public void assertContainsNull(AssertionInfo info, Object[] actual) {
        this.arrays.assertContainsNull(info, this.failures, actual);
    }

    public void assertDoesNotContainNull(AssertionInfo info, Object[] actual) {
        this.arrays.assertDoesNotContainNull(info, this.failures, actual);
    }

    public <E> void assertAre(AssertionInfo info, E[] actual, Condition<? super E> condition) {
        this.arrays.assertAre(info, this.failures, this.conditions, actual, condition);
    }

    public <E> void assertAreNot(AssertionInfo info, E[] actual, Condition<? super E> condition) {
        this.arrays.assertAreNot(info, this.failures, this.conditions, actual, condition);
    }

    public <E> void assertHave(AssertionInfo info, E[] actual, Condition<? super E> condition) {
        this.arrays.assertHave(info, this.failures, this.conditions, actual, condition);
    }

    public <E> void assertDoNotHave(AssertionInfo info, E[] actual, Condition<? super E> condition) {
        this.arrays.assertHaveNot(info, this.failures, this.conditions, actual, condition);
    }

    public <E> void assertAreAtLeast(AssertionInfo info, E[] actual, int n2, Condition<? super E> condition) {
        this.arrays.assertAreAtLeast(info, this.failures, this.conditions, actual, n2, condition);
    }

    public <E> void assertAreAtMost(AssertionInfo info, E[] actual, int n2, Condition<? super E> condition) {
        this.arrays.assertAreAtMost(info, this.failures, this.conditions, actual, n2, condition);
    }

    public <E> void assertAreExactly(AssertionInfo info, E[] actual, int n2, Condition<? super E> condition) {
        this.arrays.assertAreExactly(info, this.failures, this.conditions, actual, n2, condition);
    }

    public <E> void assertHaveAtLeast(AssertionInfo info, E[] actual, int times, Condition<? super E> condition) {
        this.arrays.assertHaveAtLeast(info, this.failures, this.conditions, actual, times, condition);
    }

    public <E> void assertHaveAtMost(AssertionInfo info, E[] actual, int times, Condition<? super E> condition) {
        this.arrays.assertHaveAtMost(info, this.failures, this.conditions, actual, times, condition);
    }

    public <E> void assertHaveExactly(AssertionInfo info, E[] actual, int times, Condition<? super E> condition) {
        this.arrays.assertHaveExactly(info, this.failures, this.conditions, actual, times, condition);
    }

    public <E> void assertHasAtLeastOneElementOfType(AssertionInfo info, E[] actual, Class<?> type) {
        Objects.instance().assertNotNull(info, actual);
        boolean found = false;
        for (E o2 : actual) {
            if (!type.isInstance(o2)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw this.failures.failure(info, ShouldHaveAtLeastOneElementOfType.shouldHaveAtLeastOneElementOfType(actual, type));
        }
    }

    public <E> void assertHasOnlyElementsOfType(AssertionInfo info, E[] actual, Class<?> type) {
        Objects.instance().assertNotNull(info, actual);
        for (E element : actual) {
            if (type.isInstance(element)) continue;
            throw this.failures.failure(info, ShouldHaveOnlyElementsOfType.shouldHaveOnlyElementsOfType(actual, type, element == null ? null : element.getClass()));
        }
    }

    public <E> void assertHasOnlyElementsOfTypes(AssertionInfo info, E[] actual, Class<?> ... types) {
        this.arrays.assertHasOnlyElementsOfTypes(info, this.failures, actual, types);
    }

    public <E> void assertHasExactlyElementsOfTypes(AssertionInfo info, E[] actual, Class<?> ... expectedTypes) {
        Objects.instance().assertNotNull(info, actual);
        List actualTypeList = Stream.of(actual).map(Object::getClass).collect(Collectors.toList());
        IterableDiff<Class<?>> typesDiff = IterableDiff.diff(actualTypeList, Lists.list(expectedTypes));
        if (typesDiff.differencesFound()) {
            throw this.failures.failure(info, ShouldHaveExactlyTypes.shouldHaveTypes(actual, Lists.list(expectedTypes), typesDiff.missing, typesDiff.unexpected));
        }
        int i2 = 0;
        for (E actualElement : actual) {
            if (!java.util.Objects.equals(actualElement.getClass(), expectedTypes[i2])) {
                throw this.failures.failure(info, ShouldHaveExactlyTypes.elementsTypesDifferAtIndex(actualElement, expectedTypes[i2], i2));
            }
            ++i2;
        }
    }

    public <E> void assertDoesNotHaveAnyElementsOfTypes(AssertionInfo info, E[] actual, Class<?> ... unexpectedTypes) {
        Objects.instance().assertNotNull(info, actual);
        LinkedHashMap nonMatchingElementsByType = new LinkedHashMap();
        for (E element : actual) {
            for (Class<?> type : unexpectedTypes) {
                if (!type.isInstance(element)) continue;
                if (!nonMatchingElementsByType.containsKey(type)) {
                    nonMatchingElementsByType.put(type, new ArrayList());
                }
                ((List)nonMatchingElementsByType.get(type)).add(element);
            }
        }
        if (!nonMatchingElementsByType.isEmpty()) {
            throw this.failures.failure(info, ShouldNotHaveAnyElementsOfTypes.shouldNotHaveAnyElementsOfTypes(actual, unexpectedTypes, nonMatchingElementsByType));
        }
    }

    public void assertIsSorted(AssertionInfo info, Object[] actual) {
        this.arrays.assertIsSorted(info, this.failures, actual);
    }

    public <E> void assertIsSortedAccordingToComparator(AssertionInfo info, E[] actual, Comparator<? super E> comparator) {
        Arrays.assertIsSortedAccordingToComparator(info, this.failures, actual, comparator);
    }

    public <E> void assertContainsAll(AssertionInfo info, E[] actual, Iterable<? extends E> other) {
        this.arrays.assertcontainsAll(info, this.failures, actual, other);
    }

    public void assertContainsAnyOf(AssertionInfo info, Object[] actual, Object[] values) {
        this.arrays.assertContainsAnyOf(info, this.failures, actual, values);
    }
}

