/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import org.assertj.core.presentation.NumberGrouping;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.Strings;

public class BinaryRepresentation
extends StandardRepresentation {
    public static final BinaryRepresentation BINARY_REPRESENTATION = new BinaryRepresentation();
    public static final String BYTE_PREFIX = "0b";

    @Override
    public String toStringOf(Object object) {
        if (this.hasCustomFormatterFor(object)) {
            return this.customFormat(object);
        }
        if (object instanceof Character) {
            Character character = (Character)object;
            return this.toStringOf(character);
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return this.toStringOf(number);
        }
        if (object instanceof String) {
            String string2 = (String)object;
            return this.toStringOf(this, string2);
        }
        return super.toStringOf(object);
    }

    protected String toStringOf(Representation representation, String s2) {
        return Strings.concat("\"", representation.toStringOf(s2.toCharArray()), "\"");
    }

    @Override
    protected String toStringOf(Number number) {
        if (number instanceof Byte) {
            Byte b2 = (Byte)number;
            return this.toStringOf(b2);
        }
        if (number instanceof Short) {
            Short s2 = (Short)number;
            return this.toStringOf(s2);
        }
        if (number instanceof Integer) {
            Integer i2 = (Integer)number;
            return this.toStringOf(i2);
        }
        if (number instanceof Long) {
            Long l2 = (Long)number;
            return this.toStringOf(l2);
        }
        if (number instanceof Float) {
            Float f2 = (Float)number;
            return this.toStringOf(f2);
        }
        if (number instanceof Double) {
            Double d2 = (Double)number;
            return this.toStringOf(d2);
        }
        return number == null ? null : number.toString();
    }

    protected String toStringOf(Byte b2) {
        return BinaryRepresentation.toGroupedBinary(Integer.toBinaryString(b2 & 0xFF), 8);
    }

    protected String toStringOf(Short s2) {
        return BinaryRepresentation.toGroupedBinary(Integer.toBinaryString(s2 & 0xFFFF), 16);
    }

    protected String toStringOf(Integer i2) {
        return BinaryRepresentation.toGroupedBinary(Integer.toBinaryString(i2), 32);
    }

    @Override
    protected String toStringOf(Long l2) {
        return BinaryRepresentation.toGroupedBinary(Long.toBinaryString(l2), 64);
    }

    @Override
    protected String toStringOf(Float f2) {
        return BinaryRepresentation.toGroupedBinary(Integer.toBinaryString(Float.floatToIntBits(f2.floatValue())), 32);
    }

    protected String toStringOf(Double d2) {
        return BinaryRepresentation.toGroupedBinary(Long.toBinaryString(Double.doubleToRawLongBits(d2)), 64);
    }

    @Override
    protected String toStringOf(Character character) {
        return Strings.concat("'", this.toStringOf((short)character.charValue()), "'");
    }

    private static String toGroupedBinary(String value, int size) {
        return BYTE_PREFIX + NumberGrouping.toBinaryLiteral(BinaryRepresentation.toBinary(value, size));
    }

    private static String toBinary(String value, int size) {
        return String.format("%" + size + "s", value).replace(' ', '0');
    }
}

