/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import org.assertj.core.presentation.NumberGrouping;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.Strings;

public class HexadecimalRepresentation
extends StandardRepresentation {
    public static final HexadecimalRepresentation HEXA_REPRESENTATION = new HexadecimalRepresentation();
    public static final String PREFIX = "0x";
    public static final int NIBBLE_SIZE = 4;

    @Override
    public String toStringOf(Object object) {
        if (this.hasCustomFormatterFor(object)) {
            return this.customFormat(object);
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return this.toStringOf(number);
        }
        if (object instanceof String) {
            String string2 = (String)object;
            return this.toStringOf(this, string2);
        }
        if (object instanceof Character) {
            Character character = (Character)object;
            return this.toStringOf(character);
        }
        return super.toStringOf(object);
    }

    @Override
    protected String toStringOf(Number number) {
        if (number instanceof Byte) {
            Byte b2 = (Byte)number;
            return this.toStringOf(b2);
        }
        if (number instanceof Short) {
            Short s2 = (Short)number;
            return this.toStringOf(s2);
        }
        if (number instanceof Integer) {
            Integer i2 = (Integer)number;
            return this.toStringOf(i2);
        }
        if (number instanceof Long) {
            Long l2 = (Long)number;
            return this.toStringOf(l2);
        }
        if (number instanceof Float) {
            Float f2 = (Float)number;
            return this.toStringOf(f2);
        }
        if (number instanceof Double) {
            Double d2 = (Double)number;
            return this.toStringOf(d2);
        }
        return number.toString();
    }

    protected String toStringOf(Byte b2) {
        return HexadecimalRepresentation.toGroupedHex(b2, 8);
    }

    protected String toStringOf(Short s2) {
        return HexadecimalRepresentation.toGroupedHex(s2, 16);
    }

    protected String toStringOf(Integer i2) {
        return HexadecimalRepresentation.toGroupedHex(i2, 32);
    }

    @Override
    protected String toStringOf(Long l2) {
        return HexadecimalRepresentation.toGroupedHex(l2, 64);
    }

    @Override
    protected String toStringOf(Float f2) {
        return HexadecimalRepresentation.toGroupedHex(Float.floatToIntBits(f2.floatValue()), 32);
    }

    protected String toStringOf(Double d2) {
        return HexadecimalRepresentation.toGroupedHex(Double.doubleToRawLongBits(d2), 64);
    }

    @Override
    protected String toStringOf(Character character) {
        return Strings.concat("'", this.toStringOf((short)character.charValue()), "'");
    }

    protected String toStringOf(Representation representation, String s2) {
        return Strings.concat("\"", representation.toStringOf(s2.toCharArray()), "\"");
    }

    private static String toGroupedHex(Number value, int size) {
        return PREFIX + NumberGrouping.toHexLiteral(HexadecimalRepresentation.toHex(value, size));
    }

    private static String toHex(Number value, int sizeInBits) {
        return String.format("%0" + sizeInBits / 4 + "X", value);
    }
}

