/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.data.MapEntry;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.presentation.HeadTailAccumulator;
import org.assertj.core.presentation.PredicateDescription;
import org.assertj.core.presentation.PrimitiveArrayList;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.TransformingList;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Closeables;
import org.assertj.core.util.DateUtil;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.Throwables;
import org.assertj.core.util.diff.ChangeDelta;
import org.assertj.core.util.diff.DeleteDelta;
import org.assertj.core.util.diff.InsertDelta;

public class StandardRepresentation
implements Representation {
    private static final String NULL = "null";
    public static final StandardRepresentation STANDARD_REPRESENTATION = new StandardRepresentation();
    private static final String TUPLE_START = "(";
    private static final String TUPLE_END = ")";
    private static final String DEFAULT_START = "[";
    private static final String DEFAULT_END = "]";
    private static final String DEFAULT_MAX_ELEMENTS_EXCEEDED = "...";
    static final String INDENTATION_AFTER_NEWLINE = "    ";
    static final String INDENTATION_FOR_SINGLE_LINE = " ";
    public static final String ELEMENT_SEPARATOR = ",";
    public static final String ELEMENT_SEPARATOR_WITH_NEWLINE = "," + System.lineSeparator();
    private static int maxLengthForSingleLineDescription = 80;
    private static int maxElementsForPrinting = 1000;
    private static int maxStackTraceElementsDisplayed = 3;
    private static final Map<Class<?>, Function<?, ? extends CharSequence>> customFormatterByType = new HashMap();
    private static final Class<?>[] TYPE_WITH_UNAMBIGUOUS_REPRESENTATION = new Class[]{Date.class, LocalDateTime.class, ZonedDateTime.class, OffsetDateTime.class, Calendar.class};
    private static final Class<?>[] BLACKLISTED_ITERABLE_CLASSES = new Class[]{DirectoryStream.class};

    public static void resetDefaults() {
        maxLengthForSingleLineDescription = 80;
        maxElementsForPrinting = 1000;
    }

    public static void setMaxLengthForSingleLineDescription(int value) {
        ConfigurationProvider.loadRegisteredConfiguration();
        Preconditions.checkArgument(value > 0, "maxLengthForSingleLineDescription must be > 0 but was %s", value);
        maxLengthForSingleLineDescription = value;
    }

    public static int getMaxLengthForSingleLineDescription() {
        return maxLengthForSingleLineDescription;
    }

    public static void setMaxElementsForPrinting(int value) {
        ConfigurationProvider.loadRegisteredConfiguration();
        Preconditions.checkArgument(value >= 1, "maxElementsForPrinting must be >= 1, but was %s", value);
        maxElementsForPrinting = value;
    }

    public static int getMaxStackTraceElementsDisplayed() {
        return maxStackTraceElementsDisplayed;
    }

    public static void setMaxStackTraceElementsDisplayed(int value) {
        ConfigurationProvider.loadRegisteredConfiguration();
        Preconditions.checkArgument(value >= 0, "maxStackTraceElementsDisplayed  must be >= 0, but was %s", value);
        maxStackTraceElementsDisplayed = value;
    }

    public static int getMaxElementsForPrinting() {
        return maxElementsForPrinting;
    }

    public static <T> void registerFormatterForType(Class<T> type, Function<T, String> formatter2) {
        customFormatterByType.put(type, formatter2);
    }

    public static void removeAllRegisteredFormatters() {
        customFormatterByType.clear();
    }

    @Override
    public String toStringOf(Object object) {
        if (object == null) {
            return null;
        }
        if (this.hasCustomFormatterFor(object)) {
            return this.customFormat(object);
        }
        if (object instanceof ComparatorBasedComparisonStrategy) {
            ComparatorBasedComparisonStrategy strategy = (ComparatorBasedComparisonStrategy)object;
            return this.toStringOf(strategy);
        }
        if (object instanceof Calendar) {
            Calendar calendar = (Calendar)object;
            return this.toStringOf(calendar);
        }
        if (object instanceof Class) {
            Class clazz = (Class)object;
            return this.toStringOf(clazz);
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return this.toStringOf(date);
        }
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            return this.toStringOf(duration);
        }
        if (object instanceof LocalDate) {
            LocalDate date = (LocalDate)object;
            return this.toStringOf(date);
        }
        if (object instanceof YearMonth) {
            YearMonth month2 = (YearMonth)object;
            return this.toStringOf(month2);
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime time2 = (LocalDateTime)object;
            return this.toStringOf(time2);
        }
        if (object instanceof OffsetDateTime) {
            OffsetDateTime time3 = (OffsetDateTime)object;
            return this.toStringOf(time3);
        }
        if (object instanceof ZonedDateTime) {
            ZonedDateTime time4 = (ZonedDateTime)object;
            return this.toStringOf(time4);
        }
        if (object instanceof LongAdder) {
            LongAdder adder = (LongAdder)object;
            return this.toStringOf(adder);
        }
        if (StandardRepresentation.isInstanceOfNotOverridingToString(object, AtomicReference.class)) {
            return this.toStringOf((AtomicReference)object);
        }
        if (StandardRepresentation.isInstanceOfNotOverridingToString(object, AtomicMarkableReference.class)) {
            return this.toStringOf((AtomicMarkableReference)object);
        }
        if (StandardRepresentation.isInstanceOfNotOverridingToString(object, AtomicStampedReference.class)) {
            return this.toStringOf((AtomicStampedReference)object);
        }
        if (object instanceof AtomicIntegerFieldUpdater) {
            return AtomicIntegerFieldUpdater.class.getSimpleName();
        }
        if (object instanceof AtomicLongFieldUpdater) {
            return AtomicLongFieldUpdater.class.getSimpleName();
        }
        if (object instanceof AtomicReferenceFieldUpdater) {
            return AtomicReferenceFieldUpdater.class.getSimpleName();
        }
        if (object instanceof File) {
            File file = (File)object;
            return this.toStringOf(file);
        }
        if (object instanceof Path) {
            return this.fallbackToStringOf(object);
        }
        if (StandardRepresentation.isUnquotedString(object)) {
            return this.toUnquotedStringOf(object);
        }
        if (object instanceof String) {
            String string2 = (String)object;
            return this.toStringOf(string2);
        }
        if (object instanceof CharSequence) {
            CharSequence sequence2 = (CharSequence)object;
            return this.toStringOf(sequence2);
        }
        if (object instanceof Character) {
            Character character = (Character)object;
            return this.toStringOf(character);
        }
        if (object instanceof Comparator) {
            Comparator comparator = (Comparator)object;
            return this.toStringOf(comparator);
        }
        if (object instanceof SimpleDateFormat) {
            SimpleDateFormat format2 = (SimpleDateFormat)object;
            return this.toStringOf(format2);
        }
        if (object instanceof PredicateDescription) {
            PredicateDescription description = (PredicateDescription)object;
            return this.toStringOf(description);
        }
        if (object instanceof Future) {
            Future future = (Future)object;
            return this.toStringOf(future);
        }
        if (Arrays.isArray(object)) {
            return this.formatArray(object);
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return this.smartFormat(collection);
        }
        if (object instanceof Map) {
            Map map2 = (Map)object;
            return this.toStringOf(map2);
        }
        if (object instanceof Tuple) {
            Tuple tuple = (Tuple)object;
            return this.toStringOf(tuple);
        }
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            return this.toStringOf(entry);
        }
        if (object instanceof Method) {
            Method method = (Method)object;
            return method.toGenericString();
        }
        if (object instanceof InsertDelta) {
            InsertDelta delta = (InsertDelta)object;
            return this.toStringOf(delta);
        }
        if (object instanceof ChangeDelta) {
            ChangeDelta delta = (ChangeDelta)object;
            return this.toStringOf(delta);
        }
        if (object instanceof DeleteDelta) {
            DeleteDelta delta = (DeleteDelta)object;
            return this.toStringOf(delta);
        }
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            if (!StandardRepresentation.hasOverriddenToString(object.getClass())) {
                return this.smartFormat(iterable);
            }
        }
        if (object instanceof AtomicInteger) {
            AtomicInteger atomicInteger = (AtomicInteger)object;
            return this.toStringOf(atomicInteger);
        }
        if (object instanceof AtomicBoolean) {
            AtomicBoolean atomicBoolean = (AtomicBoolean)object;
            return this.toStringOf(atomicBoolean);
        }
        if (object instanceof AtomicLong) {
            AtomicLong atomicLong = (AtomicLong)object;
            return this.toStringOf(atomicLong);
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return this.toStringOf(number);
        }
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            return this.toStringOf(throwable);
        }
        return this.fallbackToStringOf(object);
    }

    private static boolean isUnquotedString(Object object) {
        String className = object.getClass().getName();
        return className.contains("org.assertj.core") && className.contains("UnquotedString");
    }

    private static boolean isInstanceOfNotOverridingToString(Object object, Class<?> type) {
        return type.isInstance(object) && !StandardRepresentation.hasOverriddenToStringInSubclassOf(object.getClass(), type);
    }

    private static boolean hasOverriddenToString(Class<?> clazz) {
        try {
            Class<?> classDeclaringToString = clazz.getMethod("toString", new Class[0]).getDeclaringClass();
            return !Object.class.equals(classDeclaringToString);
        }
        catch (NoSuchMethodException | SecurityException e2) {
            return false;
        }
    }

    private static boolean hasOverriddenToStringInSubclassOf(Class<?> objectClass, Class<?> clazz) {
        try {
            Class<?> classDeclaringToString = objectClass.getMethod("toString", new Class[0]).getDeclaringClass();
            Class<?> classToCheck = objectClass;
            while (!classToCheck.equals(clazz)) {
                if (classDeclaringToString.equals(classToCheck)) {
                    return true;
                }
                classToCheck = classToCheck.getSuperclass();
            }
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String unambiguousToStringOf(Object obj) {
        if (this.hasAlreadyAnUnambiguousToStringOf(obj)) {
            return this.toStringOf(obj);
        }
        return obj == null ? null : "%s (%s@%s)".formatted(this.toStringOf(obj), StandardRepresentation.classNameOf(obj), StandardRepresentation.identityHexCodeOf(obj));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected <T> String customFormat(T object) {
        if (object == null) {
            return null;
        }
        CharSequence formatted = customFormatterByType.get(object.getClass()).apply(object);
        return formatted != null ? formatted.toString() : null;
    }

    protected boolean hasCustomFormatterFor(Object object) {
        if (object == null) {
            return false;
        }
        return customFormatterByType.containsKey(object.getClass());
    }

    protected boolean hasAlreadyAnUnambiguousToStringOf(Object obj) {
        for (Class<?> aClass : TYPE_WITH_UNAMBIGUOUS_REPRESENTATION) {
            if (!aClass.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    protected String fallbackToStringOf(Object object) {
        return object.toString();
    }

    protected String toStringOf(Number number) {
        if (number instanceof Float) {
            Float f2 = (Float)number;
            return this.toStringOf(f2);
        }
        if (number instanceof Long) {
            Long l2 = (Long)number;
            return this.toStringOf(l2);
        }
        return number.toString();
    }

    protected String toStringOf(AtomicBoolean atomicBoolean) {
        return "AtomicBoolean(%s)".formatted(atomicBoolean.get());
    }

    protected String toStringOf(AtomicInteger atomicInteger) {
        return "AtomicInteger(%s)".formatted(atomicInteger.get());
    }

    protected String toStringOf(AtomicLong atomicLong) {
        return "AtomicLong(%s)".formatted(atomicLong.get());
    }

    protected String toStringOf(LongAdder longAdder) {
        return "LongAdder(%s)".formatted(longAdder.sum());
    }

    protected String toStringOf(Comparator<?> comparator) {
        if (!comparator.toString().contains("@")) {
            return comparator.toString();
        }
        String comparatorSimpleClassName = comparator.getClass().getSimpleName();
        if (comparatorSimpleClassName.isEmpty()) {
            return Strings.quote("anonymous comparator class");
        }
        if (comparator.toString().contains(comparatorSimpleClassName + "@")) {
            return comparatorSimpleClassName;
        }
        return comparator.toString();
    }

    protected String toStringOf(ComparatorBasedComparisonStrategy comparatorBasedComparisonStrategy) {
        String comparatorDescription = comparatorBasedComparisonStrategy.getComparatorDescription();
        return comparatorDescription == null ? this.toStringOf(comparatorBasedComparisonStrategy.getComparator()) : Strings.quote(comparatorDescription);
    }

    protected String toStringOf(Calendar calendar) {
        return DateUtil.formatAsDatetime(calendar) + this.classNameDisambiguation(calendar);
    }

    protected String toStringOf(Class<?> c2) {
        String canonicalName = c2.getCanonicalName();
        if (canonicalName != null) {
            return canonicalName;
        }
        if (c2.getSimpleName().isEmpty()) {
            return "anonymous class";
        }
        if (c2.getSimpleName().equals("[]")) {
            return "anonymous class array";
        }
        return "local class %s".formatted(c2.getSimpleName());
    }

    protected String toStringOf(String s2) {
        return StandardRepresentation.concatWithDoubleQuotes(s2);
    }

    protected String toUnquotedStringOf(Object s2) {
        return s2.toString();
    }

    protected String toStringOf(CharSequence s2) {
        return StandardRepresentation.concatWithDoubleQuotes(s2);
    }

    private static String concatWithDoubleQuotes(CharSequence s2) {
        return Strings.concat("\"", s2, "\"");
    }

    protected String toStringOf(Character c2) {
        return Strings.concat("'", c2, "'");
    }

    protected String toStringOf(PredicateDescription p2) {
        return p2.isDefault() ? "%s".formatted(p2.description) : "'%s'".formatted(p2.description);
    }

    protected String toStringOf(Date date) {
        return DateUtil.formatAsDatetimeWithMs(date) + this.classNameDisambiguation(date);
    }

    protected String toStringOf(LocalDateTime localDateTime) {
        return this.defaultToStringWithClassNameDisambiguation(localDateTime);
    }

    protected String toStringOf(OffsetDateTime offsetDateTime) {
        return this.defaultToStringWithClassNameDisambiguation(offsetDateTime);
    }

    protected String toStringOf(ZonedDateTime zonedDateTime) {
        return this.defaultToStringWithClassNameDisambiguation(zonedDateTime);
    }

    protected String toStringOf(LocalDate localDate) {
        return this.defaultToStringWithClassNameDisambiguation(localDate);
    }

    protected String toStringOf(YearMonth yearMonth) {
        return this.defaultToStringWithClassNameDisambiguation(yearMonth);
    }

    protected String classNameDisambiguation(Object o2) {
        return " (%s)".formatted(o2.getClass().getName());
    }

    protected String toStringOf(Float f2) {
        return "%sf".formatted(f2);
    }

    protected String toStringOf(Long l2) {
        return "%sL".formatted(l2);
    }

    protected String toStringOf(File file) {
        return file.getAbsolutePath();
    }

    protected String toStringOf(SimpleDateFormat dateFormat) {
        return dateFormat.toPattern();
    }

    protected String toStringOf(Future<?> future) {
        String className = future.getClass().getSimpleName();
        if (!future.isDone()) {
            return Strings.concat(className, "[Incomplete]");
        }
        try {
            Object joinResult = future.get();
            Object joinResultRepresentation = joinResult instanceof Future ? joinResult : this.toStringOf(joinResult);
            return Strings.concat(className, "[Completed: ", joinResultRepresentation, DEFAULT_END);
        }
        catch (CancellationException e2) {
            return Strings.concat(className, "[Cancelled]");
        }
        catch (InterruptedException e3) {
            return Strings.concat(className, "[Interrupted]");
        }
        catch (ExecutionException e4) {
            String stackTrace = e4.getCause() != null ? Throwables.getStackTrace(e4.getCause()) : Throwables.getStackTrace(e4);
            return Strings.concat(className, "[Failed with the following stack trace:", "%n%s".formatted(stackTrace), DEFAULT_END);
        }
    }

    protected String toStringOf(Tuple tuple) {
        return this.singleLineFormat(tuple.toList(), TUPLE_START, TUPLE_END);
    }

    protected String toStringOf(MapEntry<?, ?> mapEntry) {
        return "%s=%s".formatted(this.toStringOf(mapEntry.key), this.toStringOf(mapEntry.value));
    }

    protected String toStringOf(Map.Entry<?, ?> javaMapEntry) {
        return "%s=%s".formatted(this.toStringOf(javaMapEntry.getKey()), this.toStringOf(javaMapEntry.getValue()));
    }

    protected String toStringOf(Map<?, ?> map2) {
        if (map2 == null) {
            return null;
        }
        Map<?, ?> sortedMap = StandardRepresentation.toSortedMapIfPossible(map2);
        Iterator<Map.Entry<?, ?>> entriesIterator = sortedMap.entrySet().iterator();
        if (!entriesIterator.hasNext()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder("{");
        int printedElements = 0;
        while (true) {
            Map.Entry<?, ?> entry = entriesIterator.next();
            if (printedElements == maxElementsForPrinting) {
                builder.append(DEFAULT_MAX_ELEMENTS_EXCEEDED);
                return builder.append("}").toString();
            }
            if (entry == null) {
                builder.append(NULL);
            } else {
                builder.append(this.format(map2, entry.getKey())).append('=').append(this.format(map2, entry.getValue()));
            }
            ++printedElements;
            if (!entriesIterator.hasNext()) {
                return builder.append("}").toString();
            }
            builder.append(", ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String toStringOf(Throwable throwable) {
        String string2;
        StackTraceElement[] elements = throwable.getStackTrace();
        if (maxStackTraceElementsDisplayed == 0 || elements == null) {
            return throwable.toString();
        }
        if (maxStackTraceElementsDisplayed >= elements.length) {
            return Throwables.getStackTrace(throwable);
        }
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter((Writer)sw, true);
            pw.println(throwable);
            for (int i2 = 0; i2 < maxStackTraceElementsDisplayed; ++i2) {
                pw.println("\tat " + String.valueOf(elements[i2]));
            }
            pw.print("\t...(" + (elements.length - maxStackTraceElementsDisplayed) + " remaining lines not displayed - this can be changed with Assertions.setMaxStackTraceElementsDisplayed)");
            string2 = sw.toString();
        }
        catch (Throwable throwable2) {
            Closeables.closeQuietly(sw, pw);
            throw throwable2;
        }
        Closeables.closeQuietly(sw, pw);
        return string2;
    }

    protected String toStringOf(AtomicReference<?> atomicReference) {
        return "%s[%s]".formatted(atomicReference.getClass().getSimpleName(), this.toStringOf(atomicReference.get()));
    }

    protected String toStringOf(AtomicMarkableReference<?> atomicMarkableReference) {
        return "%s[marked=%s, reference=%s]".formatted(atomicMarkableReference.getClass().getSimpleName(), atomicMarkableReference.isMarked(), this.toStringOf(atomicMarkableReference.getReference()));
    }

    protected String toStringOf(AtomicStampedReference<?> atomicStampedReference) {
        return "%s[stamp=%s, reference=%s]".formatted(atomicStampedReference.getClass().getSimpleName(), atomicStampedReference.getStamp(), this.toStringOf(atomicStampedReference.getReference()));
    }

    protected String multiLineFormat(Iterable<?> iterable) {
        return this.format(iterable, DEFAULT_START, DEFAULT_END, ELEMENT_SEPARATOR_WITH_NEWLINE, INDENTATION_AFTER_NEWLINE, iterable);
    }

    protected String singleLineFormat(Iterable<?> iterable, String start, String end) {
        return this.format(iterable, start, end, ELEMENT_SEPARATOR, INDENTATION_FOR_SINGLE_LINE, iterable);
    }

    protected String smartFormat(Iterable<?> iterable) {
        for (Class<?> blacklistedClass : BLACKLISTED_ITERABLE_CLASSES) {
            if (!blacklistedClass.isInstance(iterable)) continue;
            return this.fallbackToStringOf(iterable);
        }
        String singleLineDescription = this.singleLineFormat(iterable, DEFAULT_START, DEFAULT_END);
        return StandardRepresentation.doesDescriptionFitOnSingleLine(singleLineDescription) ? singleLineDescription : this.multiLineFormat(iterable);
    }

    protected String formatArray(Object o2) {
        if (!Arrays.isArray(o2)) {
            return null;
        }
        return Arrays.isObjectArray(o2) ? this.smartFormat((Object[])o2) : this.formatPrimitiveArray(o2);
    }

    protected String smartFormat(Object[] array) {
        String description = this.singleLineFormat(array, array);
        return StandardRepresentation.doesDescriptionFitOnSingleLine(description) ? description : this.multiLineFormat(array, array);
    }

    protected String formatPrimitiveArray(Object o2) {
        if (!Arrays.isArrayTypePrimitive(o2)) {
            throw Arrays.notAnArrayOfPrimitives(o2);
        }
        PrimitiveArrayList objects = new PrimitiveArrayList(o2);
        return this.format(objects, DEFAULT_START, DEFAULT_END, ELEMENT_SEPARATOR, INDENTATION_FOR_SINGLE_LINE, (Object)objects);
    }

    protected String multiLineFormat(Object[] array, Object root) {
        return this.format(array, DEFAULT_START, DEFAULT_END, ELEMENT_SEPARATOR_WITH_NEWLINE, INDENTATION_AFTER_NEWLINE, root);
    }

    protected String singleLineFormat(Object[] array, Object root) {
        return this.format(array, DEFAULT_START, DEFAULT_END, ELEMENT_SEPARATOR, INDENTATION_FOR_SINGLE_LINE, root);
    }

    protected String format(Object[] array, String start, String end, String elementSeparator, String indentation, Object root) {
        if (array == null) {
            return null;
        }
        return this.format(java.util.Arrays.asList(array), start, end, elementSeparator, indentation, root);
    }

    protected String format(List<?> elements, String start, String end, String elementSeparator, String indentation, Object root) {
        if (elements == null) {
            return null;
        }
        if (elements.isEmpty()) {
            return start + end;
        }
        TransformingList<Object, String> representedElements = new TransformingList<Object, String>(elements, elem -> this.safeStringOf(elem, start, end, elementSeparator, indentation, root));
        return StandardRepresentation.representGroup(representedElements, start, end, elementSeparator, indentation);
    }

    protected String format(Iterable<?> iterable, String start, String end, String elementSeparator, String indentation, Object root) {
        if (iterable == null) {
            return null;
        }
        Iterator<?> iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            return start + end;
        }
        List<String> representedElements = this.representElements(iterable, start, end, elementSeparator, indentation, root);
        return StandardRepresentation.representGroup(representedElements, start, end, elementSeparator, indentation);
    }

    protected String safeStringOf(Object element, String start, String end, String elementSeparator, String indentation, Object root) {
        if (element == root) {
            return Arrays.isArray(root) ? "(this array)" : "(this instance)";
        }
        return element == null ? NULL : this.toStringOf(element);
    }

    private List<String> representElements(Iterable<?> elements, String start, String end, String elementSeparator, String indentation, Object root) {
        int capacity = maxElementsForPrinting / 2 + 1;
        HeadTailAccumulator accumulator = new HeadTailAccumulator(capacity, capacity);
        elements.forEach(accumulator::add);
        return accumulator.stream().map(element -> this.safeStringOf(element, start, end, elementSeparator, indentation, root)).collect(Collectors.toList());
    }

    private static String representGroup(List<String> representedElements, String start, String end, String elementSeparator, String indentation) {
        int size = representedElements.size();
        StringBuilder desc = new StringBuilder(start);
        if (size <= maxElementsForPrinting) {
            for (int i2 = 0; i2 < size; ++i2) {
                if (i2 != 0) {
                    desc.append(indentation);
                }
                desc.append(representedElements.get(i2));
                if (i2 == size - 1) continue;
                desc.append(elementSeparator);
            }
            return desc.append(end).toString();
        }
        int maxFirstElementsToPrint = (maxElementsForPrinting + 1) / 2;
        for (int i3 = 0; i3 < maxFirstElementsToPrint; ++i3) {
            desc.append(representedElements.get(i3)).append(elementSeparator).append(indentation);
        }
        desc.append(DEFAULT_MAX_ELEMENTS_EXCEEDED);
        if (elementSeparator.contains(System.lineSeparator())) {
            desc.append(System.lineSeparator());
        }
        int maxLastElementsToPrint = maxElementsForPrinting / 2;
        for (int i4 = size - maxLastElementsToPrint; i4 < size; ++i4) {
            if (i4 != size - maxLastElementsToPrint) {
                desc.append(elementSeparator);
            }
            desc.append(indentation).append(representedElements.get(i4));
        }
        return desc.append(end).toString();
    }

    private String toStringOf(ChangeDelta<?> changeDelta) {
        return "Changed content at line %s:%nexpecting:%n  %s%nbut was:%n  %s%n".formatted(changeDelta.lineNumber(), this.formatLines(changeDelta.getOriginal().getLines()), this.formatLines(changeDelta.getRevised().getLines()));
    }

    private String toStringOf(DeleteDelta<?> deleteDelta) {
        return "Missing content at line %s:%n  %s%n".formatted(deleteDelta.lineNumber(), this.formatLines(deleteDelta.getOriginal().getLines()));
    }

    private String toStringOf(InsertDelta<?> insertDelta) {
        return "Extra content at line %s:%n  %s%n".formatted(insertDelta.lineNumber(), this.formatLines(insertDelta.getRevised().getLines()));
    }

    private String toStringOf(Duration duration) {
        return duration.toString().substring(2);
    }

    private String formatLines(List<?> lines2) {
        return this.format(lines2, DEFAULT_START, DEFAULT_END, ELEMENT_SEPARATOR_WITH_NEWLINE, "   ", (Object)lines2);
    }

    private static boolean doesDescriptionFitOnSingleLine(String singleLineDescription) {
        return singleLineDescription == null || singleLineDescription.length() <= maxLengthForSingleLineDescription;
    }

    private static String identityHexCodeOf(Object obj) {
        return Integer.toHexString(System.identityHashCode(obj));
    }

    private static Object classNameOf(Object obj) {
        return obj.getClass().isAnonymousClass() ? obj.getClass().getName() : obj.getClass().getSimpleName();
    }

    private String defaultToStringWithClassNameDisambiguation(Object o2) {
        return o2.toString() + this.classNameDisambiguation(o2);
    }

    private static Map<?, ?> toSortedMapIfPossible(Map<?, ?> map2) {
        try {
            return new TreeMap(map2);
        }
        catch (ClassCastException | NullPointerException e2) {
            return map2;
        }
    }

    private String format(Map<?, ?> map2, Object o2) {
        return o2 == map2 ? "(this Map)" : this.toStringOf(o2);
    }

    protected static enum GroupType {
        ITERABLE("iterable"),
        ARRAY("array");

        private final String description;

        private GroupType(String value) {
            this.description = value;
        }

        public String description() {
            return this.description;
        }
    }
}

