/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import org.assertj.core.util.NullSafeComparator;

public class DoubleComparator
extends NullSafeComparator<Double> {
    private double precision;

    public DoubleComparator(double epsilon) {
        this.precision = epsilon;
    }

    @Override
    protected int compareNonNull(Double x2, Double y2) {
        if (DoubleComparator.closeEnough(x2, y2, this.precision)) {
            return 0;
        }
        return x2 < y2 ? -1 : 1;
    }

    public double getEpsilon() {
        return this.precision;
    }

    private static boolean closeEnough(Double x2, Double y2, double epsilon) {
        return x2.doubleValue() == y2.doubleValue() || Math.abs(x2 - y2) <= epsilon;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        long temp = Double.doubleToLongBits(this.precision);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleComparator)) {
            return false;
        }
        DoubleComparator other = (DoubleComparator)obj;
        return Double.doubleToLongBits(this.precision) == Double.doubleToLongBits(other.precision);
    }

    public String toString() {
        return "DoubleComparator[precision=%s]".formatted(this.precision);
    }
}

