/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import com.jetbrains.cef.JCefAppConfig;
import com.jetbrains.cef.JdkEx;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.cef.CefBrowserSettings;
import org.cef.CefClient;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserWindow;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefRequestContext;
import org.cef.handler.CefWindowHandler;
import org.cef.handler.CefWindowHandlerAdapter;
import org.cef.misc.CefLog;
import sun.awt.AWTAccessor;

class CefBrowserWr
extends CefBrowser_N {
    private static final boolean USE_CANVAS = OS.isWindows() || OS.isLinux();
    private Canvas canvas_ = null;
    private Component component_ = null;
    private Rectangle content_rect_ = new Rectangle(0, 0, 0, 0);
    private long window_handle_ = 0L;
    private boolean justCreated_ = false;
    private double scaleFactor_ = 1.0;
    private long delayCreationUntilMs_ = 0L;
    private Timer delayedUpdate_ = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CefBrowserWr.this.isClosed()) {
                        return;
                    }
                    if (CefBrowserWr.this.delayCreationUntilMs_ > 0L && System.currentTimeMillis() < CefBrowserWr.this.delayCreationUntilMs_ && CefBrowserWr.this.getNativeRef("CefBrowser") == 0L) {
                        CefLog.Debug("delay native browser creation (need wait %d ms)", CefBrowserWr.this.delayCreationUntilMs_ - System.currentTimeMillis());
                        CefBrowserWr.this.delayedUpdate_.restart();
                        return;
                    }
                    if (AWTAccessor.getComponentAccessor().getPeer(CefBrowserWr.this.component_) == null || CefBrowserWr.this.createBrowserIfRequired(true)) {
                        CefBrowserWr.this.delayedUpdate_.restart();
                    } else if (OS.isMacintosh() || OS.isLinux()) {
                        CefBrowserWr.this.doUpdate();
                    }
                }
            });
        }
    });
    private CefWindowHandlerAdapter win_handler_ = new CefWindowHandlerAdapter(){
        private Point lastPos = new Point(-1, -1);
        private long[] nextClick = new long[MouseInfo.getNumberOfButtons()];
        private int[] clickCnt = new int[MouseInfo.getNumberOfButtons()];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Rectangle getRect(CefBrowser browser) {
            Rectangle rectangle = CefBrowserWr.this.content_rect_;
            synchronized (rectangle) {
                return CefBrowserWr.this.content_rect_;
            }
        }

        @Override
        public void onMouseEvent(CefBrowser browser, int event, final int screenX, final int screenY, final int modifier, final int button2) {
            final Point pt = new Point(screenX, screenY);
            if (event == 503) {
                if (pt.equals(this.lastPos)) {
                    return;
                }
                this.lastPos = pt;
                if ((modifier & 0x400) != 0) {
                    event = 506;
                }
            }
            final int finalEvent = event;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Component parent = SwingUtilities.getRoot(CefBrowserWr.this.component_);
                    if (parent == null) {
                        return;
                    }
                    double scaleX = parent.getGraphicsConfiguration().getDefaultTransform().getScaleX();
                    double scaleY = parent.getGraphicsConfiguration().getDefaultTransform().getScaleY();
                    if (JdkEx.isJetBrainsJDK() && OS.isWindows()) {
                        Point parentPt = parent.getLocationOnScreen();
                        Rectangle devBounds = parent.getGraphicsConfiguration().getDevice().getDefaultConfiguration().getBounds();
                        int scaledScreenX = devBounds.x + (int)Math.round((double)(screenX - devBounds.x) / scaleX);
                        int scaledScreenY = devBounds.y + (int)Math.round((double)(screenY - devBounds.y) / scaleY);
                        pt.x = scaledScreenX - parentPt.x;
                        pt.y = scaledScreenY - parentPt.y;
                    } else {
                        pt.x = (int)Math.round((double)pt.x / scaleX);
                        pt.y = (int)Math.round((double)pt.y / scaleY);
                        SwingUtilities.convertPointFromScreen(pt, parent);
                    }
                    int clickCnt = 0;
                    long now = new Date().getTime();
                    if (finalEvent == 507) {
                        int scrollType = 0;
                        int rotation = button2 > 0 ? 1 : -1;
                        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new MouseWheelEvent(parent, finalEvent, now, modifier, pt.x, pt.y, 0, false, scrollType, 3, rotation));
                    } else {
                        clickCnt = this.getClickCount(finalEvent, button2);
                        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new MouseEvent(parent, finalEvent, now, modifier, pt.x, pt.y, screenX, screenY, clickCnt, false, button2));
                    }
                    if (finalEvent == 502) {
                        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new MouseEvent(parent, 500, now, modifier, pt.x, pt.y, screenX, screenY, clickCnt, false, button2));
                    }
                }
            });
        }

        public int getClickCount(int event, int button2) {
            int idx = button2 % this.nextClick.length;
            switch (event) {
                case 501: {
                    long currTime = new Date().getTime();
                    if (currTime > this.nextClick[idx]) {
                        this.nextClick[idx] = currTime + (long)((Integer)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval")).intValue();
                        this.clickCnt[idx] = 1;
                    } else {
                        int n2 = idx;
                        this.clickCnt[n2] = this.clickCnt[n2] + 1;
                    }
                }
                case 502: {
                    return this.clickCnt[idx];
                }
            }
            return 0;
        }
    };

    CefBrowserWr(CefClient client2, String url, CefRequestContext context, CefBrowserSettings settings2) {
        this(client2, url, context, null, null, settings2);
    }

    private CefBrowserWr(CefClient client2, String url, CefRequestContext context, CefBrowserWr parent, Point inspectAt, CefBrowserSettings settings2) {
        super(client2, url, context, parent, inspectAt, settings2);
        this.delayedUpdate_.setRepeats(false);
        this.delayCreationUntilMs_ = Long.getLong("jcef.debug.cefbrowserwr.delay_creation", 0L);
        if (this.delayCreationUntilMs_ > 0L) {
            this.delayCreationUntilMs_ += System.currentTimeMillis();
        }
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.component_ = new JPanel(new BorderLayout()){
            private MouseListener mouseListener;
            private MouseWheelListener mouseWheelListener;
            private MouseMotionListener mouseMotionListener;
            private boolean removed_;
            {
                this.removed_ = true;
                this.addPropertyChangeListener("graphicsConfiguration", e2 -> CefBrowserWr.this.updateScale());
            }

            @Override
            public void addMouseListener(MouseListener l2) {
                this.mouseListener = l2;
                if (CefBrowserWr.this.canvas_ != null) {
                    CefBrowserWr.this.canvas_.addMouseListener(l2);
                }
                super.addMouseListener(l2);
            }

            @Override
            public void addMouseWheelListener(MouseWheelListener l2) {
                this.mouseWheelListener = l2;
                if (CefBrowserWr.this.canvas_ != null) {
                    CefBrowserWr.this.canvas_.addMouseWheelListener(l2);
                }
                super.addMouseWheelListener(l2);
            }

            @Override
            public void addMouseMotionListener(MouseMotionListener l2) {
                this.mouseMotionListener = l2;
                if (CefBrowserWr.this.canvas_ != null) {
                    CefBrowserWr.this.canvas_.addMouseMotionListener(l2);
                }
                super.addMouseMotionListener(l2);
            }

            @Override
            public void removeMouseListener(MouseListener l2) {
                this.mouseListener = null;
                if (CefBrowserWr.this.canvas_ != null) {
                    CefBrowserWr.this.canvas_.removeMouseListener(l2);
                }
                super.removeMouseListener(l2);
            }

            @Override
            public void removeMouseMotionListener(MouseMotionListener l2) {
                this.mouseMotionListener = null;
                if (CefBrowserWr.this.canvas_ != null) {
                    CefBrowserWr.this.canvas_.removeMouseMotionListener(l2);
                }
                super.removeMouseMotionListener(l2);
            }

            @Override
            public void removeMouseWheelListener(MouseWheelListener l2) {
                this.mouseWheelListener = null;
                if (CefBrowserWr.this.canvas_ != null) {
                    CefBrowserWr.this.canvas_.removeMouseWheelListener(l2);
                }
                super.removeMouseWheelListener(l2);
            }

            private void addCanvas() {
                CefBrowserWr.this.canvas_ = new BrowserCanvas();
                if (this.mouseListener != null) {
                    CefBrowserWr.this.canvas_.addMouseListener(this.mouseListener);
                }
                if (this.mouseWheelListener != null) {
                    CefBrowserWr.this.canvas_.addMouseWheelListener(this.mouseWheelListener);
                }
                if (this.mouseMotionListener != null) {
                    CefBrowserWr.this.canvas_.addMouseMotionListener(this.mouseMotionListener);
                }
                this.add((Component)CefBrowserWr.this.canvas_, "Center");
            }

            private void removeCanvas() {
                if (CefBrowserWr.this.canvas_ == null) {
                    return;
                }
                if (this.mouseListener != null) {
                    CefBrowserWr.this.canvas_.removeMouseListener(this.mouseListener);
                }
                if (this.mouseWheelListener != null) {
                    CefBrowserWr.this.canvas_.removeMouseWheelListener(this.mouseWheelListener);
                }
                if (this.mouseMotionListener != null) {
                    CefBrowserWr.this.canvas_.removeMouseMotionListener(this.mouseMotionListener);
                }
                this.remove(CefBrowserWr.this.canvas_);
                CefBrowserWr.this.canvas_ = null;
            }

            @Override
            public void setBounds(int x2, int y2, int width, int height) {
                super.setBounds(x2, y2, width, height);
                CefBrowserWr.this.wasResized((int)((double)width * CefBrowserWr.this.scaleFactor_), (int)((double)height * CefBrowserWr.this.scaleFactor_));
            }

            @Override
            public void setBounds(Rectangle r2) {
                this.setBounds(r2.x, r2.y, r2.width, r2.height);
            }

            @Override
            public void setSize(int width, int height) {
                super.setSize(width, height);
                CefBrowserWr.this.wasResized((int)((double)width * CefBrowserWr.this.scaleFactor_), (int)((double)height * CefBrowserWr.this.scaleFactor_));
            }

            @Override
            public void setSize(Dimension d2) {
                this.setSize(d2.width, d2.height);
            }

            @Override
            public void paint(Graphics g2) {
                CefBrowserWr.this.doUpdate();
                CefBrowserWr.this.delayedUpdate_.restart();
            }

            @Override
            public void addNotify() {
                super.addNotify();
                CefBrowserWr.this.updateScale();
                if (this.removed_) {
                    if (USE_CANVAS) {
                        this.addCanvas();
                    }
                    CefBrowserWr.this.setParent(CefBrowserWr.getWindowHandle(this), CefBrowserWr.this.canvas_);
                    this.removed_ = false;
                }
                CefBrowserWr.this.delayedUpdate_.restart();
            }

            @Override
            public void removeNotify() {
                if (!this.removed_) {
                    if (!CefBrowserWr.this.isClosed()) {
                        CefBrowserWr.this.setParent(0L, null);
                    }
                    this.removed_ = true;
                    if (USE_CANVAS) {
                        this.removeCanvas();
                    }
                }
                super.removeNotify();
            }
        };
        this.component_.setMinimumSize(new Dimension(0, 0));
        this.component_.setFocusable(true);
        this.component_.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e2) {
                CefBrowserWr.this.setFocus(false);
            }

            @Override
            public void focusGained(FocusEvent e2) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                CefBrowserWr.this.setFocus(true);
            }
        });
        this.component_.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorResized(HierarchyEvent e2) {
                CefBrowserWr.this.doUpdate();
            }

            @Override
            public void ancestorMoved(HierarchyEvent e2) {
                CefBrowserWr.this.doUpdate();
                CefBrowserWr.this.notifyMoveOrResizeStarted();
            }
        });
        this.component_.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e2) {
                if ((e2.getChangeFlags() & 4L) != 0L) {
                    CefBrowserWr.this.setWindowVisibility(e2.getChanged().isVisible());
                }
            }
        });
    }

    private void updateScale() {
        if (!OS.isMacintosh()) {
            this.scaleFactor_ = CefBrowserWr.shouldUpscale() ? JCefAppConfig.getDeviceScaleFactor(this.component_) : 1.0;
        }
    }

    @Override
    public void createImmediately() {
        this.justCreated_ = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefBrowserWr.this.createBrowserIfRequired(false);
            }
        });
    }

    @Override
    public Component getUIComponent() {
        return this.component_;
    }

    @Override
    public CefWindowHandler getWindowHandler() {
        return this.win_handler_;
    }

    @Override
    protected CefBrowser createDevToolsBrowser(CefClient client2, String url, CefRequestContext context, CefBrowser parent, Point inspectAt) {
        return new CefBrowserWr(client2, url, context, this, inspectAt, null);
    }

    private synchronized long getWindowHandle() {
        if (this.window_handle_ == 0L && OS.isMacintosh()) {
            this.window_handle_ = CefBrowserWr.getWindowHandle(this.component_);
        }
        return this.window_handle_;
    }

    static long getWindowHandle(Component component) {
        if (OS.isMacintosh()) {
            try {
                Class<?> cls = Class.forName("org.cef.browser.mac.CefBrowserWindowMac");
                CefBrowserWindow browserWindow = (CefBrowserWindow)cls.newInstance();
                if (browserWindow != null) {
                    return browserWindow.getWindowHandle(component);
                }
            }
            catch (ClassNotFoundException e2) {
                e2.printStackTrace();
            }
            catch (InstantiationException e3) {
                e3.printStackTrace();
            }
            catch (IllegalAccessException e4) {
                e4.printStackTrace();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate() {
        if (this.isClosed()) {
            return;
        }
        Rectangle vr = ((JPanel)this.component_).getVisibleRect();
        Rectangle clipping = new Rectangle((int)(vr.getX() * this.scaleFactor_), (int)(vr.getY() * this.scaleFactor_), (int)(vr.getWidth() * this.scaleFactor_), (int)(vr.getHeight() * this.scaleFactor_));
        if (OS.isMacintosh()) {
            Container next2;
            Container parent = this.component_.getParent();
            Point contentPos = this.component_.getLocation();
            while (!(parent == null || (next2 = parent.getParent()) != null && next2 instanceof Window)) {
                Point parentPos = parent.getLocation();
                contentPos.translate(parentPos.x, parentPos.y);
                parent = next2;
            }
            contentPos.translate(clipping.x, clipping.y);
            Point browserPos = clipping.getLocation();
            browserPos.x *= -1;
            browserPos.y *= -1;
            Rectangle rectangle = this.content_rect_;
            synchronized (rectangle) {
                this.content_rect_ = new Rectangle(contentPos, clipping.getSize());
                Rectangle browserRect = new Rectangle(browserPos, this.component_.getSize());
                this.updateUI(this.content_rect_, browserRect);
            }
        }
        Rectangle rectangle = this.content_rect_;
        synchronized (rectangle) {
            Rectangle bounds;
            Rectangle rectangle2 = bounds = null != this.canvas_ ? this.canvas_.getBounds() : this.component_.getBounds();
            double scale = OS.isLinux() ? (CefBrowserWr.shouldUpscale() ? 1.0 : 1.0 / JCefAppConfig.getDeviceScaleFactor(this.component_)) : this.scaleFactor_;
            this.content_rect_ = new Rectangle((int)(bounds.getX() * scale), (int)(bounds.getY() * scale), (int)(bounds.getWidth() * scale), (int)(bounds.getHeight() * scale));
            this.updateUI(clipping, this.content_rect_);
        }
    }

    private boolean createBrowserIfRequired(boolean hasParent) {
        if (this.isClosed()) {
            return false;
        }
        long windowHandle = 0L;
        Component canvas2 = null;
        if (hasParent) {
            windowHandle = this.getWindowHandle();
            Component component = canvas2 = OS.isWindows() || OS.isLinux() ? this.canvas_ : this.component_;
        }
        if (this.getNativeRef("CefBrowser") == 0L) {
            if (this.getParentBrowser() != null) {
                this.createDevTools(this.getParentBrowser(), this.getClient(), windowHandle, false, false, canvas2, this.getInspectAt());
                return true;
            }
            this.createBrowser(this.getClient(), windowHandle, this.getUrl(), false, false, canvas2);
            return true;
        }
        if (hasParent && this.justCreated_) {
            this.setParent(windowHandle, canvas2);
            this.justCreated_ = false;
        }
        return false;
    }

    @Override
    public CompletableFuture<BufferedImage> createScreenshot(boolean nativeResolution) {
        throw new UnsupportedOperationException("Unsupported for windowed rendering");
    }

    private static boolean shouldUpscale() {
        return JCefAppConfig.getForceDeviceScaleFactor() == -1.0;
    }

    @Override
    public void setWindowlessFrameRate(int frameRate) {
        throw new UnsupportedOperationException("You can only set windowless framerate on OSR browser");
    }

    @Override
    public CompletableFuture<Integer> getWindowlessFrameRate() {
        throw new UnsupportedOperationException("You can only get windowless framerate on OSR browser");
    }

    @Override
    public boolean isWindowless() {
        return false;
    }

    private class BrowserCanvas
    extends Canvas {
        private BrowserCanvas() {
        }

        @Override
        public void paint(Graphics g2) {
            g2.setColor(CefBrowserWr.this.component_.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

