/*
 * Decompiled with CFR 0.152.
 */
package org.cef.security;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public final class CefX509Certificate {
    private X509Certificate[] chain_;

    public CefX509Certificate(byte[][] chainDERData) {
        this.chain_ = new X509Certificate[chainDERData.length];
        try {
            CertificateFactory factory2 = CertificateFactory.getInstance("X.509");
            for (int i2 = 0; i2 < chainDERData.length; ++i2) {
                ByteArrayInputStream in = new ByteArrayInputStream(chainDERData[i2]);
                this.chain_[i2] = (X509Certificate)factory2.generateCertificate(in);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.chain_ = null;
        }
    }

    public X509Certificate getSubjectCertificate() {
        if (this.chain_ == null || this.chain_.length == 0) {
            return null;
        }
        return this.chain_[0];
    }

    public X509Certificate[] getCertificatesChain() {
        return this.chain_;
    }
}

