/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\u00072\n\u0010\n\u001a\u00060\tR\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J \u0010\f\u001a\u00020\u00052\n\u0010\r\u001a\u00060\tR\u00020\u00072\n\u0010\u000e\u001a\u00060\tR\u00020\u0007H\u0016J\u001c\u0010\u000f\u001a\u00020\u00052\n\u0010\u0010\u001a\u00060\tR\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\r\u001a\u00060\tR\u00020\u00072\n\u0010\u000e\u001a\u00060\tR\u00020\u0007H\u0016J\u001c\u0010\u0014\u001a\u00020\u00052\n\u0010\u0010\u001a\u00060\tR\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J2\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\u0017\u001a\u00060\tR\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH&J*\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\u0017\u001a\u00060\tR\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H&\u00a8\u0006 "}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/DelimiterParser;", "", "()V", "canOpenClose", "Lkotlin/Pair;", "", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "left", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "right", "canSplitText", "isLeftFlankingRun", "leftIt", "rightIt", "isPunctuation", "info", "lookup", "", "isRightFlankingRun", "isWhitespace", "process", "", "iterator", "delimiters", "", "Lorg/intellij/markdown/parser/sequentialparsers/DelimiterParser$Info;", "result", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResultBuilder;", "scan", "Companion", "Info", "markdown"})
public abstract class DelimiterParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int maxAdvance = 50;

    public abstract int scan(@NotNull TokensCache var1, @NotNull TokensCache.Iterator var2, @NotNull List<Info> var3);

    public abstract void process(@NotNull TokensCache var1, @NotNull TokensCache.Iterator var2, @NotNull List<Info> var3, @NotNull SequentialParser.ParsingResultBuilder var4);

    @NotNull
    public Pair<Boolean, Boolean> canOpenClose(@NotNull TokensCache tokens, @NotNull TokensCache.Iterator left, @NotNull TokensCache.Iterator right, boolean canSplitText) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        boolean isLeftFlanking = this.isLeftFlankingRun(left, right);
        boolean isRightFlanking = this.isRightFlankingRun(tokens, left, right);
        boolean canOpen = canSplitText ? isLeftFlanking : isLeftFlanking && (!isRightFlanking || SequentialParserUtil.Companion.isPunctuation(left, -1));
        boolean canClose = canSplitText ? isRightFlanking : isRightFlanking && (!isLeftFlanking || SequentialParserUtil.Companion.isPunctuation(right, 1));
        return TuplesKt.to((Object)canOpen, (Object)canClose);
    }

    public boolean isLeftFlankingRun(@NotNull TokensCache.Iterator leftIt, @NotNull TokensCache.Iterator rightIt) {
        Intrinsics.checkNotNullParameter((Object)leftIt, (String)"leftIt");
        Intrinsics.checkNotNullParameter((Object)rightIt, (String)"rightIt");
        return !this.isWhitespace(rightIt, 1) && (!this.isPunctuation(rightIt, 1) || this.isWhitespace(leftIt, -1) || this.isPunctuation(leftIt, -1));
    }

    public boolean isRightFlankingRun(@NotNull TokensCache tokens, @NotNull TokensCache.Iterator leftIt, @NotNull TokensCache.Iterator rightIt) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)leftIt, (String)"leftIt");
        Intrinsics.checkNotNullParameter((Object)rightIt, (String)"rightIt");
        return leftIt.charLookup(-1) != Companion.getType(leftIt) && !this.isWhitespace(leftIt, -1) && (!this.isPunctuation(leftIt, -1) || this.isWhitespace(rightIt, 1) || this.isPunctuation(rightIt, 1));
    }

    public boolean isWhitespace(@NotNull TokensCache.Iterator info, int lookup2) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return SequentialParserUtil.Companion.isWhitespace(info, lookup2);
    }

    public boolean isPunctuation(@NotNull TokensCache.Iterator info, int lookup2) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return SequentialParserUtil.Companion.isPunctuation(info, lookup2);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/DelimiterParser$Companion;", "", "()V", "maxAdvance", "", "getType", "", "iterator", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "markdown"})
    public static final class Companion {
        private Companion() {
        }

        public final char getType(@NotNull TokensCache.Iterator iterator2) {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            return iterator2.getFirstChar();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b \n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\bH\u00c6\u0003J\t\u0010$\u001a\u00020\bH\u00c6\u0003J\t\u0010%\u001a\u00020\u000bH\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003JO\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010(\u001a\u00020\b2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001J\t\u0010+\u001a\u00020,H\u00d6\u0001R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006-"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/DelimiterParser$Info;", "", "tokenType", "Lorg/intellij/markdown/IElementType;", "position", "", "length", "canOpen", "", "canClose", "marker", "", "closerIndex", "(Lorg/intellij/markdown/IElementType;IIZZCI)V", "getCanClose", "()Z", "setCanClose", "(Z)V", "getCanOpen", "setCanOpen", "getCloserIndex", "()I", "setCloserIndex", "(I)V", "getLength", "getMarker", "()C", "setMarker", "(C)V", "getPosition", "getTokenType", "()Lorg/intellij/markdown/IElementType;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "", "markdown"})
    public static final class Info {
        @NotNull
        private final IElementType tokenType;
        private final int position;
        private final int length;
        private boolean canOpen;
        private boolean canClose;
        private char marker;
        private int closerIndex;

        public Info(@NotNull IElementType tokenType, int position, int length, boolean canOpen, boolean canClose, char marker, int closerIndex) {
            Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
            this.tokenType = tokenType;
            this.position = position;
            this.length = length;
            this.canOpen = canOpen;
            this.canClose = canClose;
            this.marker = marker;
            this.closerIndex = closerIndex;
        }

        public /* synthetic */ Info(IElementType iElementType, int n2, int n3, boolean bl2, boolean bl3, char c2, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 4) != 0) {
                n3 = 0;
            }
            if ((n5 & 0x40) != 0) {
                n4 = -1;
            }
            this(iElementType, n2, n3, bl2, bl3, c2, n4);
        }

        @NotNull
        public final IElementType getTokenType() {
            return this.tokenType;
        }

        public final int getPosition() {
            return this.position;
        }

        public final int getLength() {
            return this.length;
        }

        public final boolean getCanOpen() {
            return this.canOpen;
        }

        public final void setCanOpen(boolean bl2) {
            this.canOpen = bl2;
        }

        public final boolean getCanClose() {
            return this.canClose;
        }

        public final void setCanClose(boolean bl2) {
            this.canClose = bl2;
        }

        public final char getMarker() {
            return this.marker;
        }

        public final void setMarker(char c2) {
            this.marker = c2;
        }

        public final int getCloserIndex() {
            return this.closerIndex;
        }

        public final void setCloserIndex(int n2) {
            this.closerIndex = n2;
        }

        @NotNull
        public final IElementType component1() {
            return this.tokenType;
        }

        public final int component2() {
            return this.position;
        }

        public final int component3() {
            return this.length;
        }

        public final boolean component4() {
            return this.canOpen;
        }

        public final boolean component5() {
            return this.canClose;
        }

        public final char component6() {
            return this.marker;
        }

        public final int component7() {
            return this.closerIndex;
        }

        @NotNull
        public final Info copy(@NotNull IElementType tokenType, int position, int length, boolean canOpen, boolean canClose, char marker, int closerIndex) {
            Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
            return new Info(tokenType, position, length, canOpen, canClose, marker, closerIndex);
        }

        public static /* synthetic */ Info copy$default(Info info, IElementType iElementType, int n2, int n3, boolean bl2, boolean bl3, char c2, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                iElementType = info.tokenType;
            }
            if ((n5 & 2) != 0) {
                n2 = info.position;
            }
            if ((n5 & 4) != 0) {
                n3 = info.length;
            }
            if ((n5 & 8) != 0) {
                bl2 = info.canOpen;
            }
            if ((n5 & 0x10) != 0) {
                bl3 = info.canClose;
            }
            if ((n5 & 0x20) != 0) {
                c2 = info.marker;
            }
            if ((n5 & 0x40) != 0) {
                n4 = info.closerIndex;
            }
            return info.copy(iElementType, n2, n3, bl2, bl3, c2, n4);
        }

        @NotNull
        public String toString() {
            return "Info(tokenType=" + this.tokenType + ", position=" + this.position + ", length=" + this.length + ", canOpen=" + this.canOpen + ", canClose=" + this.canClose + ", marker=" + this.marker + ", closerIndex=" + this.closerIndex + ')';
        }

        public int hashCode() {
            int result2 = this.tokenType.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.position);
            result2 = result2 * 31 + Integer.hashCode(this.length);
            result2 = result2 * 31 + Boolean.hashCode(this.canOpen);
            result2 = result2 * 31 + Boolean.hashCode(this.canClose);
            result2 = result2 * 31 + Character.hashCode(this.marker);
            result2 = result2 * 31 + Integer.hashCode(this.closerIndex);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Info)) {
                return false;
            }
            Info info = (Info)other;
            if (!Intrinsics.areEqual((Object)this.tokenType, (Object)info.tokenType)) {
                return false;
            }
            if (this.position != info.position) {
                return false;
            }
            if (this.length != info.length) {
                return false;
            }
            if (this.canOpen != info.canOpen) {
                return false;
            }
            if (this.canClose != info.canClose) {
                return false;
            }
            if (this.marker != info.marker) {
                return false;
            }
            return this.closerIndex == info.closerIndex;
        }
    }
}

