/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;

public class NameFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() == 0) {
            return NameFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (args.size() == 1) {
            return NameFunction.evaluate(args, context.getNavigator());
        }
        throw new FunctionCallException("name() requires zero or one argument.");
    }

    public static String evaluate(List list, Navigator nav2) throws FunctionCallException {
        if (!list.isEmpty()) {
            Object first2 = list.get(0);
            if (first2 instanceof List) {
                return NameFunction.evaluate((List)first2, nav2);
            }
            if (nav2.isElement(first2)) {
                return nav2.getElementQName(first2);
            }
            if (nav2.isAttribute(first2)) {
                return nav2.getAttributeQName(first2);
            }
            if (nav2.isProcessingInstruction(first2)) {
                return nav2.getProcessingInstructionTarget(first2);
            }
            if (nav2.isNamespace(first2)) {
                return nav2.getNamespacePrefix(first2);
            }
            if (nav2.isDocument(first2)) {
                return "";
            }
            if (nav2.isComment(first2)) {
                return "";
            }
            if (nav2.isText(first2)) {
                return "";
            }
            throw new FunctionCallException("The argument to the name function must be a node-set");
        }
        return "";
    }
}

