/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.plaf.LabelUI;
import org.jdesktop.swingx.icon.PainterIcon;
import org.jdesktop.swingx.painter.BusyPainter;
import org.jdesktop.swingx.plaf.BusyLabelAddon;
import org.jdesktop.swingx.plaf.BusyLabelUI;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class JXBusyLabel
extends JLabel {
    private static final long serialVersionUID = 5979268460848257147L;
    private BusyPainter busyPainter;
    private Timer busy;
    private int delay;
    private boolean wasBusyOnNotify = false;
    public static final String uiClassID = "BusyLabelUI";
    private Direction direction;

    public void setDirection(Direction dir) {
        this.direction = dir;
        this.getBusyPainter().setDirection(dir);
    }

    public JXBusyLabel() {
        this((Dimension)null);
    }

    public JXBusyLabel(Dimension dim) {
        BusyLabelUI ui = (BusyLabelUI)((Object)this.getUI());
        if (ui != null) {
            this.delay = ui.getDelay();
        }
        this.setPreferredSize(dim);
        this.getBusyPainter();
    }

    protected void initPainter(Dimension dim) {
        BusyPainter busyPainter = this.getBusyPainter();
        if (null != busyPainter) {
            busyPainter.setCacheable(false);
        }
        PainterIcon icon = new PainterIcon(dim);
        icon.setPainter(busyPainter);
        this.setIcon(icon);
    }

    protected BusyPainter createBusyPainter(Dimension dim) {
        BusyPainter busyPainter = null;
        BusyLabelUI ui = (BusyLabelUI)((Object)this.getUI());
        if (ui != null) {
            busyPainter = ui.getBusyPainter(dim);
        }
        return busyPainter;
    }

    public boolean isBusy() {
        return this.busy != null;
    }

    public void setBusy(boolean busy) {
        boolean old = this.isBusy();
        if (!old && busy) {
            this.startAnimation();
            this.firePropertyChange("busy", old, this.isBusy());
        } else if (old && !busy) {
            this.stopAnimation();
            this.firePropertyChange("busy", old, this.isBusy());
        }
    }

    private void startAnimation() {
        if (this.busy != null) {
            this.stopAnimation();
        }
        this.busy = new Timer(this.delay, new ActionListener(){
            BusyPainter busyPainter;
            int frame;
            {
                this.busyPainter = JXBusyLabel.this.getBusyPainter();
                this.frame = this.busyPainter.getPoints();
            }

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.frame = (this.frame + 1) % this.busyPainter.getPoints();
                this.busyPainter.setFrame(JXBusyLabel.this.direction == Direction.LEFT ? this.busyPainter.getPoints() - this.frame : this.frame);
                JXBusyLabel.this.frameChanged();
            }
        });
        this.busy.start();
    }

    private void stopAnimation() {
        if (this.busy != null) {
            this.busy.stop();
            this.getBusyPainter().setFrame(-1);
            this.repaint();
            this.busy = null;
        }
    }

    @Override
    public void removeNotify() {
        this.wasBusyOnNotify = this.isBusy();
        this.stopAnimation();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.wasBusyOnNotify) {
            this.startAnimation();
        }
    }

    protected void frameChanged() {
        this.repaint();
    }

    public final BusyPainter getBusyPainter() {
        if (null == this.busyPainter) {
            Dimension prefSize = this.getPreferredSize();
            this.busyPainter = this.createBusyPainter((Dimension)(prefSize.width == 0 && prefSize.height == 0 && !this.isPreferredSizeSet() ? null : prefSize));
            if (null != this.busyPainter) {
                if (!(this.isPreferredSizeSet() || null != prefSize && prefSize.width != 0 && prefSize.height != 0)) {
                    Rectangle rt2 = this.busyPainter.getTrajectory().getBounds();
                    Rectangle rp2 = this.busyPainter.getPointShape().getBounds();
                    int max = Math.max(rp2.width, rp2.height);
                    prefSize = new Dimension(rt2.width + max, rt2.height + max);
                }
                this.initPainter(prefSize);
            }
        }
        return this.busyPainter;
    }

    public final void setBusyPainter(BusyPainter busyPainter) {
        this.busyPainter = busyPainter;
        this.initPainter(new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight()));
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        int old = this.getDelay();
        this.delay = delay;
        if (old != this.getDelay()) {
            if (this.busy != null && this.busy.isRunning()) {
                this.busy.setDelay(this.getDelay());
            }
            this.firePropertyChange("delay", old, this.getDelay());
        }
    }

    @Override
    public void updateUI() {
        this.setUI((LabelUI)LookAndFeelAddons.getUI(this, BusyLabelUI.class));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    static {
        LookAndFeelAddons.contribute(new BusyLabelAddon());
    }

    public static enum Direction {
        RIGHT,
        LEFT;

    }
}

