/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.event;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

public class WeakEventListenerList
implements Serializable {
    protected transient List<WeakReference<? extends EventListener>> weakReferences;
    protected transient List<Class<? extends EventListener>> classes;

    public Object[] getListenerList() {
        List listeners = this.cleanReferences();
        Object[] result2 = new Object[listeners.size() * 2];
        for (int i2 = 0; i2 < listeners.size(); ++i2) {
            result2[2 * i2 + 1] = listeners.get(i2);
            result2[2 * i2] = this.getClasses().get(i2);
        }
        return result2;
    }

    private synchronized <T extends EventListener> List<T> cleanReferences() {
        ArrayList<EventListener> listeners = new ArrayList<EventListener>();
        for (int i2 = this.getReferences().size() - 1; i2 >= 0; --i2) {
            Object listener = this.getReferences().get(i2).get();
            if (listener == null) {
                this.getReferences().remove(i2);
                this.getClasses().remove(i2);
                continue;
            }
            listeners.add(0, (EventListener)listener);
        }
        return listeners;
    }

    private List<WeakReference<? extends EventListener>> getReferences() {
        if (this.weakReferences == null) {
            this.weakReferences = new ArrayList<WeakReference<? extends EventListener>>();
        }
        return this.weakReferences;
    }

    private List<Class<? extends EventListener>> getClasses() {
        if (this.classes == null) {
            this.classes = new ArrayList<Class<? extends EventListener>>();
        }
        return this.classes;
    }

    public <T extends EventListener> T[] getListeners(Class<T> t2) {
        List<T> liveListeners = this.cleanReferences();
        ArrayList<T> listeners = new ArrayList<T>();
        for (int i2 = 0; i2 < liveListeners.size(); ++i2) {
            if (this.getClasses().get(i2) != t2) continue;
            listeners.add(liveListeners.get(i2));
        }
        EventListener[] result2 = (EventListener[])Array.newInstance(t2, listeners.size());
        return listeners.toArray(result2);
    }

    public synchronized <T extends EventListener> void add(Class<T> t2, T l2) {
        if (l2 == null) {
            return;
        }
        if (!t2.isInstance(l2)) {
            throw new IllegalArgumentException("Listener " + l2 + " is not of type " + t2);
        }
        this.cleanReferences();
        this.getReferences().add(new WeakReference<T>(l2));
        this.getClasses().add(t2);
    }

    public synchronized <T extends EventListener> void remove(Class<T> t2, T l2) {
        if (l2 == null) {
            return;
        }
        if (!t2.isInstance(l2)) {
            throw new IllegalArgumentException("Listener " + l2 + " is not of type " + t2);
        }
        for (int i2 = 0; i2 < this.getReferences().size(); ++i2) {
            if (!l2.equals(this.getReferences().get(i2).get()) || t2 != this.getClasses().get(i2)) continue;
            this.getReferences().remove(i2);
            this.getClasses().remove(i2);
            break;
        }
    }
}

