/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.TextUI;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.plaf.PromptTextUI;
import org.jdesktop.swingx.search.NativeSearchFieldSupport;

public class PromptTextFieldUI
extends PromptTextUI {
    public PromptTextFieldUI(TextUI delegate) {
        super(delegate);
    }

    @Override
    public JTextComponent getPromptComponent(JTextComponent txt) {
        LabelField lbl = (LabelField)super.getPromptComponent(txt);
        JTextField txtField = (JTextField)txt;
        lbl.setHorizontalAlignment(txtField.getHorizontalAlignment());
        lbl.setColumns(txtField.getColumns());
        lbl.hasFocus = txtField.hasFocus() && NativeSearchFieldSupport.isNativeSearchField(txtField);
        NativeSearchFieldSupport.setSearchField(lbl, NativeSearchFieldSupport.isSearchField(txtField));
        NativeSearchFieldSupport.setFindPopupMenu(lbl, NativeSearchFieldSupport.getFindPopupMenu(txtField));
        Border b2 = txt.getBorder();
        if (b2 == null) {
            lbl.setBorder(txt.getBorder());
        } else {
            Insets insets = b2.getBorderInsets(txt);
            lbl.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        }
        return lbl;
    }

    @Override
    protected JTextComponent createPromptComponent() {
        return new LabelField();
    }

    private static final class LabelField
    extends JTextField {
        boolean hasFocus;

        private LabelField() {
        }

        @Override
        public boolean hasFocus() {
            return this.hasFocus;
        }
    }
}

