/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.search;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXDialog;
import org.jdesktop.swingx.JXFindBar;
import org.jdesktop.swingx.JXFindPanel;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXRootPane;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIDependent;
import org.jdesktop.swingx.search.Searchable;
import org.jdesktop.swingx.util.Utilities;

public class SearchFactory
implements UIDependent {
    private static SearchFactory searchFactory;
    protected JXFindPanel findPanel;
    protected JXFindBar findBar;
    protected JComponent lastFindBarTarget;
    private boolean useFindBar;
    private Point lastFindDialogLocation;
    private FindRemover findRemover;

    public static SearchFactory getInstance() {
        if (searchFactory == null) {
            searchFactory = new SearchFactory();
        }
        return searchFactory;
    }

    public static void setInstance(SearchFactory factory2) {
        searchFactory = factory2;
    }

    public SearchFactory() {
        UIManager.addPropertyChangeListener(new LaFListener(this));
    }

    public KeyStroke getSearchAccelerator() {
        String findMnemonic = "F";
        KeyStroke findStroke = Utilities.stringToKey("D-" + findMnemonic);
        if (findStroke == null) {
            findStroke = KeyStroke.getKeyStroke("control F");
        }
        return findStroke;
    }

    public boolean isUseFindBar(JComponent target, Searchable searchable) {
        return this.useFindBar;
    }

    public void setUseFindBar(boolean incremental) {
        if (incremental == this.useFindBar) {
            return;
        }
        this.useFindBar = incremental;
        this.getFindRemover().endSearching();
    }

    public void showFindInput(JComponent target, Searchable searchable) {
        if (this.isUseFindBar(target, searchable)) {
            this.showFindBar(target, searchable);
        } else {
            this.showFindDialog(target, searchable);
        }
    }

    public void showFindBar(JComponent target, Searchable searchable) {
        if (target == null) {
            return;
        }
        if (this.findBar == null) {
            this.findBar = this.getSharedFindBar();
        } else {
            this.releaseFindBar();
        }
        Window topLevel = SwingUtilities.getWindowAncestor(target);
        if (topLevel instanceof JXFrame) {
            JXRootPane rootPane = ((JXFrame)topLevel).getRootPaneExt();
            JToolBar toolBar = rootPane.getToolBar();
            if (toolBar == null) {
                toolBar = new JToolBar();
                rootPane.setToolBar(toolBar);
            }
            toolBar.add((Component)this.findBar, 0);
            rootPane.revalidate();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this.findBar);
        }
        this.lastFindBarTarget = target;
        this.findBar.setLocale(target.getLocale());
        target.putClientProperty("match.highlighter", Boolean.TRUE);
        this.getSharedFindBar().setSearchable(searchable);
        this.installFindRemover(target, this.findBar);
    }

    public JXFindBar getSharedFindBar() {
        if (this.findBar == null) {
            this.findBar = this.createFindBar();
            this.configureSharedFindBar();
        }
        return this.findBar;
    }

    public JXFindBar createFindBar() {
        return new JXFindBar();
    }

    protected void installFindRemover(Container target, Container findWidget) {
        if (target != null) {
            this.getFindRemover().addTarget(target);
        }
        this.getFindRemover().addTarget(findWidget);
    }

    private FindRemover getFindRemover() {
        if (this.findRemover == null) {
            this.findRemover = new FindRemover();
        }
        return this.findRemover;
    }

    protected void removeFromParent(JComponent component) {
        Container oldParent = component.getParent();
        if (oldParent != null) {
            oldParent.remove(component);
            if (oldParent instanceof JComponent) {
                ((JComponent)oldParent).revalidate();
            } else {
                oldParent.invalidate();
                oldParent.validate();
            }
        }
    }

    protected void stopSearching() {
        if (this.findPanel != null) {
            this.lastFindDialogLocation = this.hideSharedFindPanel(false);
            this.findPanel.setSearchable(null);
        }
        if (this.findBar != null) {
            this.releaseFindBar();
        }
    }

    protected void releaseFindBar() {
        this.findBar.setSearchable(null);
        if (this.lastFindBarTarget != null) {
            this.lastFindBarTarget.putClientProperty("match.highlighter", Boolean.FALSE);
            this.lastFindBarTarget = null;
        }
        this.removeFromParent(this.findBar);
    }

    protected void configureSharedFindBar() {
        AbstractAction removeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SearchFactory.this.removeFromParent(SearchFactory.this.findBar);
            }
        };
        this.findBar.getActionMap().put("close", removeAction);
    }

    public void showFindDialog(JComponent target, Searchable searchable) {
        JXDialog findDialog;
        JXDialog topLevel;
        Window frame = null;
        if (target != null) {
            target.putClientProperty("match.highlighter", Boolean.FALSE);
            frame = SwingUtilities.getWindowAncestor(target);
        }
        if ((topLevel = this.getDialogForSharedFindPanel()) != null && topLevel.getOwner().equals(frame)) {
            findDialog = topLevel;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(findDialog);
        } else {
            Point location = this.hideSharedFindPanel(true);
            findDialog = frame instanceof Frame ? new JXDialog((Frame)frame, (JComponent)this.getSharedFindPanel()) : (frame instanceof Dialog ? new JXDialog((Dialog)frame, (JComponent)this.getSharedFindPanel()) : new JXDialog(JOptionPane.getRootFrame(), (JComponent)this.getSharedFindPanel()));
            findDialog.pack();
            if (location == null) {
                findDialog.setLocationRelativeTo(frame);
            } else {
                findDialog.setLocation(location);
            }
        }
        if (target != null) {
            findDialog.setLocale(target.getLocale());
        }
        this.getSharedFindPanel().setSearchable(searchable);
        this.installFindRemover(target, findDialog);
        findDialog.setVisible(true);
    }

    public JXFindPanel getSharedFindPanel() {
        if (this.findPanel == null) {
            this.findPanel = this.createFindPanel();
            this.configureSharedFindPanel();
        }
        return this.findPanel;
    }

    public JXFindPanel createFindPanel() {
        return new JXFindPanel();
    }

    protected void configureSharedFindPanel() {
    }

    private JXDialog getDialogForSharedFindPanel() {
        if (this.findPanel == null) {
            return null;
        }
        Window window = SwingUtilities.getWindowAncestor(this.findPanel);
        return window instanceof JXDialog ? (JXDialog)window : null;
    }

    protected Point hideSharedFindPanel(boolean dispose) {
        if (this.findPanel == null) {
            return null;
        }
        Window window = SwingUtilities.getWindowAncestor(this.findPanel);
        Point location = this.lastFindDialogLocation;
        if (window != null) {
            if (window.isVisible()) {
                location = window.getLocationOnScreen();
                window.setVisible(false);
            }
            if (dispose) {
                this.findPanel.getParent().remove(this.findPanel);
                window.dispose();
            }
        }
        return location;
    }

    @Override
    public void updateUI() {
        if (this.findBar != null) {
            SwingUtilities.updateComponentTreeUI(this.findBar);
        }
        if (this.findPanel != null) {
            SwingUtilities.updateComponentTreeUI(this.findPanel);
        }
    }

    static {
        LookAndFeelAddons.getAddon();
    }

    public class FindRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;
        Set<Container> targets;

        public FindRemover() {
            this.updateManager();
        }

        public void addTarget(Container target) {
            this.getTargets().add(target);
        }

        public void removeTarget(Container target) {
            this.getTargets().remove(target);
        }

        private Set<Container> getTargets() {
            if (this.targets == null) {
                this.targets = new HashSet<Container>();
            }
            return this.targets;
        }

        private void updateManager() {
            if (this.focusManager != null) {
                this.focusManager.removePropertyChangeListener("permanentFocusOwner", this);
            }
            this.focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.focusManager.addPropertyChangeListener("permanentFocusOwner", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            Component c2 = this.focusManager.getPermanentFocusOwner();
            if (c2 == null) {
                return;
            }
            for (Container element : this.getTargets()) {
                if (element != c2 && !SwingUtilities.isDescendingFrom(c2, element)) continue;
                return;
            }
            this.endSearching();
        }

        public void endSearching() {
            this.getTargets().clear();
            SearchFactory.this.stopSearching();
        }
    }

    private static class LaFListener
    implements PropertyChangeListener {
        private final WeakReference<SearchFactory> ref;

        public LaFListener(SearchFactory sf) {
            this.ref = new WeakReference<SearchFactory>(sf);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SearchFactory sf = (SearchFactory)this.ref.get();
            if (sf == null) {
                UIManager.removePropertyChangeListener(this);
            } else if ("lookAndFeel".equals(evt.getPropertyName())) {
                sf.updateUI();
            }
        }
    }
}

