/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.CannotRestoreValue;
import org.jetbrains.jetCheck.CombinatorialIntCustomizer;
import org.jetbrains.jetCheck.CounterExampleImpl;
import org.jetbrains.jetCheck.Iteration;
import org.jetbrains.jetCheck.NodeId;
import org.jetbrains.jetCheck.PropertyFailure;
import org.jetbrains.jetCheck.ReplayDataStructure;
import org.jetbrains.jetCheck.ShrinkStep;
import org.jetbrains.jetCheck.StructureNode;

class PropertyFailureImpl<T>
implements PropertyFailure<T> {
    private final CounterExampleImpl<T> initial;
    private CounterExampleImpl<T> shrunk;
    private int totalSteps;
    private int successfulSteps;
    final Iteration<T> iteration;
    private Throwable stoppingReason;
    final boolean reproducible;

    PropertyFailureImpl(@NotNull CounterExampleImpl<T> initial, Iteration<T> iteration) {
        this.initial = initial;
        this.shrunk = initial;
        this.iteration = iteration;
        this.reproducible = iteration.session.parameters.serializedData != null || initial.tryReproducing();
        try {
            if (this.reproducible) {
                this.shrink();
            }
        }
        catch (Throwable e2) {
            this.stoppingReason = e2;
        }
    }

    @Override
    @NotNull
    public CounterExampleImpl<T> getFirstCounterExample() {
        return this.initial;
    }

    @Override
    @NotNull
    public CounterExampleImpl<T> getMinimalCounterexample() {
        return this.shrunk;
    }

    @Override
    @Nullable
    public Throwable getStoppingReason() {
        return this.stoppingReason;
    }

    @Override
    public int getTotalShrinkingExampleCount() {
        return this.totalSteps;
    }

    @Override
    public int getShrinkingStageCount() {
        return this.successfulSteps;
    }

    @Override
    public int getIterationNumber() {
        return this.iteration.iterationNumber;
    }

    @Override
    public long getIterationSeed() {
        return this.iteration.iterationSeed;
    }

    @Override
    public long getGlobalSeed() {
        return this.iteration.session.parameters.globalSeed;
    }

    @Override
    public int getSizeHint() {
        return this.iteration.sizeHint;
    }

    private void shrink() {
        ShrinkStep lastSuccessfulShrink = null;
        while ((lastSuccessfulShrink = this.shrinkIteration(lastSuccessfulShrink)) != null) {
        }
    }

    private ShrinkStep shrinkIteration(ShrinkStep limit) {
        ShrinkStep lastSuccessfulShrink = null;
        ShrinkStep step = this.shrunk.data.shrink();
        while (step != null) {
            if ((step = this.findSuccessfulShrink(step, limit)) == null) continue;
            lastSuccessfulShrink = step;
            step = step.onSuccess(this.shrunk.data);
        }
        return lastSuccessfulShrink;
    }

    @Nullable
    private ShrinkStep findSuccessfulShrink(ShrinkStep step, @Nullable ShrinkStep limit) {
        ArrayList<CustomizedNode> combinatorial = new ArrayList<CustomizedNode>();
        while (step != null && !step.equals(limit)) {
            StructureNode node = step.apply(this.shrunk.data);
            if (node != null && this.iteration.session.addGeneratedNode(node)) {
                CombinatorialIntCustomizer customizer = new CombinatorialIntCustomizer();
                if (this.tryStep(node, customizer)) {
                    return step;
                }
                CombinatorialIntCustomizer next2 = customizer.nextAttempt();
                if (next2 != null) {
                    combinatorial.add(new CustomizedNode(next2, step));
                }
            }
            step = step.onFailure();
        }
        return this.processDelayedCombinations(combinatorial);
    }

    @Nullable
    private ShrinkStep processDelayedCombinations(List<CustomizedNode> delayed) {
        Collections.sort(delayed);
        for (CustomizedNode customizedNode : delayed) {
            for (CombinatorialIntCustomizer customizer = customizedNode.customizer; customizer != null; customizer = customizer.nextAttempt()) {
                if (!this.tryStep(customizedNode.step.apply(this.shrunk.data), customizer)) continue;
                return customizedNode.step;
            }
        }
        return null;
    }

    private boolean tryStep(StructureNode node, CombinatorialIntCustomizer customizer) {
        try {
            T value;
            this.iteration.session.notifier.shrinkAttempt(this, this.iteration, node);
            ++this.totalSteps;
            HashSet<NodeId> unneeded = new HashSet<NodeId>();
            try {
                value = this.iteration.generateValue(new ReplayDataStructure(node, this.iteration.sizeHint, customizer, unneeded));
            }
            catch (Throwable e2) {
                this.iteration.session.notifier.replayFailed(e2);
                throw e2;
            }
            CounterExampleImpl<T> example = CounterExampleImpl.checkProperty(this.iteration, value, customizer.writeChanges((StructureNode)node.removeUnneeded(unneeded)));
            if (example != null) {
                this.shrunk = example;
                ++this.successfulSteps;
                return true;
            }
        }
        catch (CannotRestoreValue cannotRestoreValue) {
            // empty catch block
        }
        return false;
    }

    private static class CustomizedNode
    implements Comparable<CustomizedNode> {
        final CombinatorialIntCustomizer customizer;
        final ShrinkStep step;

        CustomizedNode(CombinatorialIntCustomizer customizer, ShrinkStep step) {
            this.customizer = customizer;
            this.step = step;
        }

        @Override
        public int compareTo(@NotNull CustomizedNode o2) {
            return Integer.compare(this.customizer.countVariants(), o2.customizer.countVariants());
        }
    }
}

