/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.jetCheck.CounterExampleImpl;
import org.jetbrains.jetCheck.PropertyFailure;
import org.jetbrains.jetCheck.PropertyFailureImpl;
import org.jetbrains.jetCheck.StatusNotifier;

public class PropertyFalsified
extends RuntimeException {
    static final String FAILURE_REASON_HAS_CHANGED_DURING_SHRINKING = "Failure reason has changed during shrinking, see initial failing example below";
    static final String NOT_REPRODUCIBLE = "The failure is not reproducible on re-run!!! Possible cause: side effects in the test.";
    private static final String SEPARATOR = "\n==========================\n";
    private final PropertyFailureImpl<?> failure;
    private final String message;

    PropertyFalsified(PropertyFailureImpl<?> failure) {
        super(((CounterExampleImpl)failure.getMinimalCounterexample()).getExceptionCause());
        this.failure = failure;
        this.message = this.calcMessage();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    private String calcMessage() {
        Throwable first2;
        String msg;
        StringBuilder traceBuilder = new StringBuilder();
        String exampleString = PropertyFalsified.valueToString(this.failure.getMinimalCounterexample(), traceBuilder);
        Throwable failureReason = ((CounterExampleImpl)this.failure.getMinimalCounterexample()).getExceptionCause();
        Throwable rootCause = failureReason == null ? null : PropertyFalsified.getRootCause(failureReason);
        String string2 = msg = rootCause != null && !rootCause.toString().contains("ComparisonFailure") ? "Failed with " + rootCause + "\nOn " + exampleString : "Falsified on " + exampleString;
        if (!this.failure.reproducible) {
            msg = msg + "\n\nThe failure is not reproducible on re-run!!! Possible cause: side effects in the test.";
        }
        msg = msg + "\n" + this.getShrinkingStats() + "\n" + this.failure.iteration.printToReproduce(failureReason, (CounterExampleImpl<?>)this.failure.getMinimalCounterexample()) + "\n";
        if (failureReason != null) {
            PropertyFalsified.appendTrace(traceBuilder, rootCause == failureReason ? "Property failure reason: " : "Property failure reason, innermost exception (see full trace below): ", rootCause);
        }
        if (this.failure.getStoppingReason() != null) {
            msg = msg + "\n Shrinking stopped prematurely, see the reason below.";
            PropertyFalsified.appendTrace(traceBuilder, "An unexpected exception happened during shrinking: ", this.failure.getStoppingReason());
        }
        if (PropertyFalsified.exceptionsDiffer(first2 = ((CounterExampleImpl)this.failure.getFirstCounterExample()).getExceptionCause(), ((CounterExampleImpl)this.failure.getMinimalCounterexample()).getExceptionCause())) {
            msg = msg + "\n Failure reason has changed during shrinking, see initial failing example below";
            StringBuilder secondaryTrace = new StringBuilder();
            traceBuilder.append("\n Initial value: ").append(PropertyFalsified.valueToString(this.failure.getFirstCounterExample(), secondaryTrace));
            if (first2 == null) {
                traceBuilder.append("\n Initially property was falsified without exceptions");
                traceBuilder.append((CharSequence)secondaryTrace);
            } else {
                traceBuilder.append((CharSequence)secondaryTrace);
                PropertyFalsified.appendTrace(traceBuilder, "Initially failed because of ", first2);
            }
        }
        return msg + traceBuilder;
    }

    private static Throwable getRootCause(Throwable t2) {
        while (t2.getCause() != null) {
            t2 = t2.getCause();
        }
        return t2;
    }

    private static void appendTrace(StringBuilder traceBuilder, String prefix, Throwable e2) {
        traceBuilder.append("\n ").append(prefix).append(StatusNotifier.printStackTrace(e2)).append(SEPARATOR);
    }

    private static String valueToString(CounterExampleImpl<?> example, StringBuilder traceBuilder) {
        try {
            return String.valueOf(example.getExampleValue());
        }
        catch (Throwable e2) {
            PropertyFalsified.appendTrace(traceBuilder, "Exception during toString evaluation: ", e2);
            return "<can't evaluate toString(), see exception below>";
        }
    }

    private String getShrinkingStats() {
        int exampleCount = this.failure.getTotalShrinkingExampleCount();
        if (exampleCount == 0) {
            return "";
        }
        String examples = exampleCount == 1 ? "example" : "examples";
        int stageCount = this.failure.getShrinkingStageCount();
        if (stageCount == 0) {
            return "Couldn't shrink, tried " + exampleCount + " " + examples + "\n";
        }
        String stages = stageCount == 1 ? "stage" : "stages";
        return "Shrunk in " + stageCount + " " + stages + ", by trying " + exampleCount + " " + examples + "\n";
    }

    private static boolean exceptionsDiffer(Throwable e1, Throwable e2) {
        if (e1 == null && e2 == null) {
            return false;
        }
        if (e1 == null != (e2 == null)) {
            return true;
        }
        if (!e1.getClass().equals(e2.getClass())) {
            return true;
        }
        if (e1 instanceof StackOverflowError) {
            return false;
        }
        return !PropertyFalsified.getUserTrace(e1).equals(PropertyFalsified.getUserTrace(e2));
    }

    private static List<String> getUserTrace(Throwable e2) {
        StackTraceElement element;
        String s2;
        ArrayList<String> result2 = new ArrayList<String>();
        StackTraceElement[] stackTraceElementArray = e2.getStackTrace();
        int n2 = stackTraceElementArray.length;
        for (int i2 = 0; i2 < n2 && (!(s2 = (element = stackTraceElementArray[i2]).toString()).startsWith("org.jetbrains.jetCheck.") || s2.contains("Test.")); ++i2) {
            result2.add(s2);
        }
        return result2;
    }

    public PropertyFailure<?> getFailure() {
        return this.failure;
    }

    public Object getBreakingValue() {
        return ((CounterExampleImpl)this.failure.getMinimalCounterexample()).getExampleValue();
    }
}

