/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.CannotRestoreValue;
import org.jetbrains.jetCheck.DataSerializer;
import org.jetbrains.jetCheck.GenerationEnvironment;
import org.jetbrains.jetCheck.GenerativeDataStructure;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.ImperativeCommand;
import org.jetbrains.jetCheck.IntDistribution;
import org.jetbrains.jetCheck.WrongDataStructure;

class Scenario {
    private static final String COMMANDS = "commands:";
    private final StringBuilder log = new StringBuilder();
    private Throwable failure;
    private final Consumer<String> logConsumer;

    private Scenario(@NotNull ImperativeCommand cmd, @NotNull GenerationEnvironment data, Consumer<String> logConsumer) {
        this.logConsumer = logConsumer;
        try {
            this.performCommand(cmd, data, "");
        }
        catch (DataSerializer.EOFException e2) {
            throw e2;
        }
        catch (Throwable e3) {
            this.addFailure(e3);
        }
        if (this.failure instanceof CannotRestoreValue || this.failure instanceof WrongDataStructure) {
            throw (RuntimeException)this.failure;
        }
    }

    private void addFailure(Throwable e2) {
        if (this.failure == null) {
            this.failure = e2;
        }
    }

    private void performCommand(ImperativeCommand command2, final GenerationEnvironment data, final String indent) {
        command2.performCommand(new ImperativeCommand.Environment(){

            @Override
            public void logMessage(@NotNull String message) {
                if (data instanceof GenerativeDataStructure) {
                    ((GenerativeDataStructure)data).ensureActiveStructure();
                }
                if (Scenario.this.hasEmptyLog()) {
                    Scenario.this.log.append(Scenario.COMMANDS);
                    Scenario.this.logConsumer.accept(Scenario.COMMANDS);
                }
                String logEntry = indent + message;
                Scenario.this.log.append("\n").append(logEntry);
                Scenario.this.logConsumer.accept(logEntry);
            }

            @Override
            public <T> T generateValue(@NotNull Generator<T> generator, @Nullable String logMessage) {
                Object value = Scenario.this.safeGenerate(data, generator);
                if (logMessage != null) {
                    this.logMessage(String.format(logMessage, value));
                }
                return (T)value;
            }

            @Override
            public void executeCommands(IntDistribution count, Generator<? extends ImperativeCommand> cmdGen) {
                this.innerCommandLists(Generator.listsOf(count, this.innerCommands(cmdGen)));
            }

            @Override
            public void executeCommands(Generator<? extends ImperativeCommand> cmdGen) {
                this.innerCommandLists(Generator.nonEmptyLists(this.innerCommands(cmdGen)));
            }

            private void innerCommandLists(final Generator<List<Object>> listGen) {
                data.generate(Generator.from(new EquivalentGenerator<List<Object>>(){

                    @Override
                    public List<Object> apply(GenerationEnvironment data) {
                        return (List)listGen.getGeneratorFunction().apply(data);
                    }
                }));
            }

            @NotNull
            private Generator<Object> innerCommands(final Generator<? extends ImperativeCommand> cmdGen) {
                return Generator.from(new EquivalentGenerator<Object>(){

                    @Override
                    public Object apply(GenerationEnvironment cmdData) {
                        Scenario.this.performCommand((ImperativeCommand)Scenario.this.safeGenerate(cmdData, cmdGen), cmdData, indent + "  ");
                        return null;
                    }
                });
            }
        });
    }

    private <T> T safeGenerate(GenerationEnvironment data, Generator<T> generator) {
        try {
            return data.generate(generator);
        }
        catch (CannotRestoreValue e2) {
            this.addFailure(e2);
            throw e2;
        }
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof Scenario && this.toString().equals(o2.toString());
    }

    public int hashCode() {
        return this.log.hashCode();
    }

    public String toString() {
        return this.hasEmptyLog() ? "commands:<none>" : this.log.toString();
    }

    boolean hasEmptyLog() {
        return this.log.length() == 0;
    }

    boolean ensureSuccessful() {
        if (this.failure instanceof Error) {
            throw (Error)this.failure;
        }
        if (this.failure instanceof RuntimeException) {
            throw (RuntimeException)this.failure;
        }
        if (this.failure != null) {
            throw new RuntimeException(this.failure);
        }
        return true;
    }

    static Generator<Scenario> scenarios(@NotNull Supplier<? extends ImperativeCommand> command2, Consumer<String> logConsumer) {
        return Generator.from(data -> new Scenario((ImperativeCommand)command2.get(), (GenerationEnvironment)data, logConsumer));
    }

    private static abstract class EquivalentGenerator<T>
    implements Function<GenerationEnvironment, T> {
        private EquivalentGenerator() {
        }

        public boolean equals(Object obj) {
            return this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

