/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.digest;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.datasource.ByteBufferDataSource;
import org.jetbrains.zip.signer.datasource.DataSource;
import org.jetbrains.zip.signer.digest.ChunkDigester;
import org.jetbrains.zip.signer.digest.ChunkIterator;
import org.jetbrains.zip.signer.metadata.ContentDigestAlgorithm;
import org.jetbrains.zip.signer.metadata.Digest;
import org.jetbrains.zip.signer.zip.ZipSections;
import org.jetbrains.zip.signer.zip.ZipUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ4\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/zip/signer/digest/DigestUtils;", "", "<init>", "()V", "computeDigest", "", "Lorg/jetbrains/zip/signer/metadata/Digest;", "digestAlgorithms", "Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;", "zipSections", "Lorg/jetbrains/zip/signer/zip/ZipSections;", "maximumChunkSize", "", "content", "Lorg/jetbrains/zip/signer/datasource/DataSource;", "lib"})
@ExperimentalUnsignedTypes
@SourceDebugExtension(value={"SMAP\nDigestUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigestUtils.kt\norg/jetbrains/zip/signer/digest/DigestUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,47:1\n1563#2:48\n1634#2,3:49\n1563#2:53\n1634#2,3:54\n1869#2:57\n1869#2,2:59\n1870#2:62\n1563#2:63\n1634#2,3:64\n1#3:52\n32#4:58\n33#4:61\n*S KotlinDebug\n*F\n+ 1 DigestUtils.kt\norg/jetbrains/zip/signer/digest/DigestUtils\n*L\n34#1:48\n34#1:49,3\n36#1:53\n36#1:54,3\n37#1:57\n39#1:59,2\n37#1:62\n45#1:63\n45#1:64,3\n38#1:58\n38#1:61\n*E\n"})
public final class DigestUtils {
    @NotNull
    public static final DigestUtils INSTANCE = new DigestUtils();

    private DigestUtils() {
    }

    @NotNull
    public final List<Digest> computeDigest(@NotNull List<? extends ContentDigestAlgorithm> digestAlgorithms, @NotNull ZipSections zipSections, int maximumChunkSize) {
        Intrinsics.checkNotNullParameter(digestAlgorithms, (String)"digestAlgorithms");
        Intrinsics.checkNotNullParameter((Object)zipSections, (String)"zipSections");
        Object[] objectArray = new DataSource[]{zipSections.getBeforeSigningBlockSection(), zipSections.getCentralDirectorySection(), new ByteBufferDataSource(ZipUtils.INSTANCE.getModifiedEocdRecord(zipSections, 0))};
        return this.computeDigest(digestAlgorithms, CollectionsKt.listOf((Object[])objectArray), maximumChunkSize);
    }

    public static /* synthetic */ List computeDigest$default(DigestUtils digestUtils, List list, ZipSections zipSections, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0x100000;
        }
        return digestUtils.computeDigest((List<? extends ContentDigestAlgorithm>)list, zipSections, n2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Digest> computeDigest(List<? extends ContentDigestAlgorithm> digestAlgorithms, List<? extends DataSource> content, int maximumChunkSize) {
        Iterable $this$mapTo$iv$iv;
        Iterator it;
        void $this$mapTo$iv$iv22;
        Iterable $this$map$iv = content;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv22) {
            DataSource dataSource = (DataSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new ChunkIterator((DataSource)((Object)it), maximumChunkSize));
        }
        List chunkIterators = (List)destination$iv$iv;
        Iterable $i$f$map22 = chunkIterators;
        int $this$mapTo$iv$iv22 = 0;
        for (Object $i$f$mapTo2 : $i$f$map22) {
            void it2;
            ChunkIterator chunkIterator = (ChunkIterator)$i$f$mapTo2;
            int n2 = $this$mapTo$iv$iv22;
            boolean bl3 = false;
            int n3 = it2.getChunkCount();
            $this$mapTo$iv$iv22 = n2 + n3;
        }
        int chunkCount = $this$mapTo$iv$iv22;
        Iterable $this$map$iv2 = digestAlgorithms;
        boolean $i$f$map = false;
        Iterable $i$f$mapTo2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo3 = false;
        it = $this$mapTo$iv$iv.iterator();
        while (it.hasNext()) {
            void it3;
            Object item$iv$iv = it.next();
            ContentDigestAlgorithm contentDigestAlgorithm = (ContentDigestAlgorithm)((Object)item$iv$iv);
            Collection collection = destination$iv$iv2;
            boolean bl4 = false;
            collection.add(new ChunkDigester((ContentDigestAlgorithm)it3, chunkCount));
        }
        List digesters = (List)destination$iv$iv2;
        Iterable $this$forEach$iv = chunkIterators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChunkIterator chunkIterator = (ChunkIterator)element$iv;
            boolean bl5 = false;
            Iterator $this$forEach$iv2 = chunkIterator;
            boolean $i$f$forEach2 = false;
            Iterator bl4 = $this$forEach$iv2;
            while (bl4.hasNext()) {
                Object element$iv2 = bl4.next();
                ByteBuffer chunk = (ByteBuffer)element$iv2;
                boolean bl6 = false;
                Iterable $this$forEach$iv3 = digesters;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    ChunkDigester it4 = (ChunkDigester)element$iv3;
                    boolean bl7 = false;
                    it4.consume(chunk);
                    chunk.rewind();
                }
            }
        }
        $this$map$iv2 = digesters;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it5;
            Object item$iv$iv = iterator2.next();
            ChunkDigester $i$f$forEach2 = (ChunkDigester)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl8 = false;
            collection.add(new Digest(it5.getDigestAlgorithm(), it5.getResult()));
        }
        return (List)destination$iv$iv2;
    }

    static /* synthetic */ List computeDigest$default(DigestUtils digestUtils, List list, List list2, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0x100000;
        }
        return digestUtils.computeDigest((List<? extends ContentDigestAlgorithm>)list, list2, n2);
    }
}

