/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signer;

import java.io.File;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.DSAKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.SignatureAlgorithm;
import org.jetbrains.zip.signer.utils.ByteBufferExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/zip/signer/signer/PublicKeyUtils;", "", "<init>", "()V", "veryHighStrengthKeySize", "", "loadOpenSshKey", "Ljava/security/PublicKey;", "file", "Ljava/io/File;", "getSuggestedSignatureAlgorithm", "Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;", "publicKey", "getSshRsaPublicKey", "buffer", "Ljava/nio/ByteBuffer;", "getSshDsaPublicKey", "getSuggestedRsaAlgorithm", "key", "Ljava/security/interfaces/RSAKey;", "SupportedPublicKeysAlgorithms", "lib"})
public final class PublicKeyUtils {
    @NotNull
    public static final PublicKeyUtils INSTANCE = new PublicKeyUtils();
    private static final int veryHighStrengthKeySize = 3072;

    private PublicKeyUtils() {
    }

    @NotNull
    public final PublicKey loadOpenSshKey(@NotNull File file) {
        PublicKey publicKey;
        String algorithmName;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String base64Encoded = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)FilesKt.readText$default((File)file, null, (int)1, null), (String)" ", null, (int)2, null), (String)" ", null, (int)2, null);
        ByteBuffer decodedKeyByteBuffer = ByteBuffer.wrap(Base64.getDecoder().decode(base64Encoded));
        Intrinsics.checkNotNull((Object)decodedKeyByteBuffer);
        String string2 = StringsKt.removePrefix((String)new String(ByteBufferExtensionsKt.getLengthPrefixedArray(decodedKeyByteBuffer), Charsets.UTF_8), (CharSequence)"ssh-").toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        String string3 = algorithmName = string2;
        if (Intrinsics.areEqual((Object)string3, (Object)SupportedPublicKeysAlgorithms.RSA.getOpenSshName())) {
            publicKey = this.getSshRsaPublicKey(decodedKeyByteBuffer);
        } else if (Intrinsics.areEqual((Object)string3, (Object)SupportedPublicKeysAlgorithms.DSA.getOpenSshName())) {
            publicKey = this.getSshDsaPublicKey(decodedKeyByteBuffer);
        } else {
            throw new IllegalArgumentException("Unsupported public key algorithm " + algorithmName);
        }
        return publicKey;
    }

    @NotNull
    public final SignatureAlgorithm getSuggestedSignatureAlgorithm(@NotNull PublicKey publicKey) {
        SignatureAlgorithm signatureAlgorithm;
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        PublicKey publicKey2 = publicKey;
        if (publicKey2 instanceof RSAKey) {
            signatureAlgorithm = this.getSuggestedRsaAlgorithm((RSAKey)((Object)publicKey));
        } else if (publicKey2 instanceof ECKey) {
            signatureAlgorithm = SignatureAlgorithm.ECDSA_WITH_SHA384;
        } else if (publicKey2 instanceof DSAKey) {
            signatureAlgorithm = SignatureAlgorithm.DSA_WITH_SHA256;
        } else {
            throw new InvalidKeyException("Unsupported key algorithm: " + publicKey.getAlgorithm());
        }
        return signatureAlgorithm;
    }

    private final PublicKey getSshRsaPublicKey(ByteBuffer buffer) {
        BigInteger publicExponent = new BigInteger(ByteBufferExtensionsKt.getLengthPrefixedArray(buffer));
        BigInteger modulus = new BigInteger(ByteBufferExtensionsKt.getLengthPrefixedArray(buffer));
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"generatePublic(...)");
        return publicKey;
    }

    private final PublicKey getSshDsaPublicKey(ByteBuffer buffer) {
        BigInteger prime = new BigInteger(ByteBufferExtensionsKt.getLengthPrefixedArray(buffer));
        BigInteger subPrime = new BigInteger(ByteBufferExtensionsKt.getLengthPrefixedArray(buffer));
        BigInteger base2 = new BigInteger(ByteBufferExtensionsKt.getLengthPrefixedArray(buffer));
        BigInteger publicKey = new BigInteger(ByteBufferExtensionsKt.getLengthPrefixedArray(buffer));
        PublicKey publicKey2 = KeyFactory.getInstance("DSA").generatePublic(new DSAPublicKeySpec(publicKey, prime, subPrime, base2));
        Intrinsics.checkNotNullExpressionValue((Object)publicKey2, (String)"generatePublic(...)");
        return publicKey2;
    }

    private final SignatureAlgorithm getSuggestedRsaAlgorithm(RSAKey key) {
        return key.getModulus().bitLength() <= veryHighStrengthKeySize ? SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA256 : SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA512;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/zip/signer/signer/PublicKeyUtils$SupportedPublicKeysAlgorithms;", "", "openSshName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getOpenSshName", "()Ljava/lang/String;", "RSA", "DSA", "lib"})
    private static final class SupportedPublicKeysAlgorithms
    extends Enum<SupportedPublicKeysAlgorithms> {
        @NotNull
        private final String openSshName;
        public static final /* enum */ SupportedPublicKeysAlgorithms RSA = new SupportedPublicKeysAlgorithms("RSA");
        public static final /* enum */ SupportedPublicKeysAlgorithms DSA = new SupportedPublicKeysAlgorithms("DSS");
        private static final /* synthetic */ SupportedPublicKeysAlgorithms[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SupportedPublicKeysAlgorithms(String openSshName) {
            this.openSshName = openSshName;
        }

        @NotNull
        public final String getOpenSshName() {
            return this.openSshName;
        }

        public static SupportedPublicKeysAlgorithms[] values() {
            return (SupportedPublicKeysAlgorithms[])$VALUES.clone();
        }

        public static SupportedPublicKeysAlgorithms valueOf(String value) {
            return Enum.valueOf(SupportedPublicKeysAlgorithms.class, value);
        }

        @NotNull
        public static EnumEntries<SupportedPublicKeysAlgorithms> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = supportedPublicKeysAlgorithmsArray = new SupportedPublicKeysAlgorithms[]{SupportedPublicKeysAlgorithms.RSA, SupportedPublicKeysAlgorithms.DSA};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

