/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.parser.CharacterReader;

public class TokenQueue
implements AutoCloseable {
    private static final char Esc = '\\';
    private static final char Hyphen_Minus = '-';
    private static final char Unicode_Null = '\u0000';
    private static final char Replacement = '\ufffd';
    private final CharacterReader reader;
    private static final char[] ElementSelectorChars = new char[]{'*', '|', '_', '-'};
    private static final char[] CssIdentifierChars = new char[]{'-', '_'};

    public TokenQueue(String data) {
        this.reader = new CharacterReader(data);
    }

    public boolean isEmpty() {
        return this.reader.isEmpty();
    }

    public char consume() {
        return this.reader.consume();
    }

    public void advance() {
        if (!this.isEmpty()) {
            this.reader.advance();
        }
    }

    char current() {
        return this.reader.current();
    }

    public boolean matches(String seq) {
        return this.reader.matchesIgnoreCase(seq);
    }

    public boolean matches(char c2) {
        return this.reader.matches(c2);
    }

    public boolean matchesAny(char ... seq) {
        return this.reader.matchesAny(seq);
    }

    public boolean matchChomp(String seq) {
        return this.reader.matchConsumeIgnoreCase(seq);
    }

    public boolean matchChomp(char c2) {
        if (this.reader.matches(c2)) {
            this.consume();
            return true;
        }
        return false;
    }

    public boolean matchesWhitespace() {
        return StringUtil.isWhitespace(this.reader.current());
    }

    public boolean matchesWord() {
        return Character.isLetterOrDigit(this.reader.current());
    }

    public void consume(String seq) {
        boolean found = this.reader.matchConsumeIgnoreCase(seq);
        if (!found) {
            throw new IllegalStateException("Queue did not match expected sequence");
        }
    }

    public String consumeTo(String seq) {
        return this.reader.consumeTo(seq);
    }

    public String consumeToAny(String ... seq) {
        StringBuilder sb = StringUtil.borrowBuilder();
        block0: while (!this.isEmpty()) {
            for (String s2 : seq) {
                if (this.reader.matchesIgnoreCase(s2)) break block0;
            }
            sb.append(this.consume());
        }
        return StringUtil.releaseBuilder(sb);
    }

    public String chompBalanced(char open, char close) {
        StringBuilder accum = StringUtil.borrowBuilder();
        int depth = 0;
        int prev = 0;
        boolean inSingle = false;
        boolean inDouble = false;
        boolean inRegexQE = false;
        this.reader.mark();
        while (!this.isEmpty()) {
            char c2 = this.consume();
            if (prev == 92) {
                if (c2 == 'Q') {
                    inRegexQE = true;
                } else if (c2 == 'E') {
                    inRegexQE = false;
                }
                accum.append(c2);
            } else {
                if (c2 == '\'' && c2 != open && !inDouble) {
                    inSingle = !inSingle;
                } else if (c2 == '\"' && c2 != open && !inSingle) {
                    boolean bl2 = inDouble = !inDouble;
                }
                if (inSingle || inDouble || inRegexQE) {
                    accum.append(c2);
                } else if (c2 == open) {
                    if (++depth > 1) {
                        accum.append(c2);
                    }
                } else if (c2 == close) {
                    if (--depth > 0) {
                        accum.append(c2);
                    }
                } else {
                    accum.append(c2);
                }
            }
            prev = c2;
            if (depth > 0) continue;
        }
        String out = StringUtil.releaseBuilder(accum);
        if (depth > 0) {
            this.reader.rewindToMark();
            Validate.fail("Did not find balanced marker at '" + out + "'");
        }
        return out;
    }

    public static String unescape(String in) {
        if (in.indexOf(92) == -1) {
            return in;
        }
        StringBuilder out = StringUtil.borrowBuilder();
        char last = '\u0000';
        for (char c2 : in.toCharArray()) {
            if (c2 == '\\') {
                if (last == '\\') {
                    out.append(c2);
                    c2 = '\u0000';
                }
            } else {
                out.append(c2);
            }
            last = c2;
        }
        return StringUtil.releaseBuilder(out);
    }

    public static String escapeCssIdentifier(String in) {
        if (in.isEmpty()) {
            return in;
        }
        StringBuilder out = StringUtil.borrowBuilder();
        TokenQueue q2 = new TokenQueue(in);
        char firstChar = q2.current();
        if (firstChar == '-') {
            q2.advance();
            if (q2.isEmpty()) {
                TokenQueue.appendEscaped(out, '-');
            } else {
                out.append('-');
                char secondChar = q2.current();
                if (StringUtil.isDigit(secondChar)) {
                    TokenQueue.appendEscapedCodepoint(out, q2.consume());
                }
            }
        } else if (StringUtil.isDigit(firstChar)) {
            TokenQueue.appendEscapedCodepoint(out, q2.consume());
        }
        while (!q2.isEmpty()) {
            char c2 = q2.consume();
            if (c2 == '\u0000') {
                out.append('\ufffd');
                continue;
            }
            if (c2 <= '\u001f' || c2 == '\u007f') {
                TokenQueue.appendEscapedCodepoint(out, c2);
                continue;
            }
            if (TokenQueue.isIdent(c2)) {
                out.append(c2);
                continue;
            }
            TokenQueue.appendEscaped(out, c2);
        }
        q2.close();
        return StringUtil.releaseBuilder(out);
    }

    private static void appendEscaped(StringBuilder out, char c2) {
        out.append('\\').append(c2);
    }

    private static void appendEscapedCodepoint(StringBuilder out, char c2) {
        out.append('\\').append(Integer.toHexString(c2)).append(' ');
    }

    public boolean consumeWhitespace() {
        boolean seen = false;
        while (this.matchesWhitespace()) {
            this.advance();
            seen = true;
        }
        return seen;
    }

    public String consumeElementSelector() {
        return this.consumeEscapedCssIdentifier(ElementSelectorChars);
    }

    public String consumeCssIdentifier() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("CSS identifier expected, but end of input found");
        }
        String identifier = this.reader.consumeMatching(TokenQueue::isIdent);
        char c2 = this.current();
        if (c2 != '\\' && c2 != '\u0000') {
            return identifier;
        }
        StringBuilder out = StringUtil.borrowBuilder();
        if (!identifier.isEmpty()) {
            out.append(identifier);
        }
        while (!this.isEmpty()) {
            c2 = this.current();
            if (TokenQueue.isIdent(c2)) {
                out.append(this.consume());
                continue;
            }
            if (c2 == '\u0000') {
                this.advance();
                out.append('\ufffd');
                continue;
            }
            if (c2 != '\\') break;
            this.advance();
            if (!this.isEmpty() && TokenQueue.isNewline(this.current())) {
                this.reader.unconsume();
                break;
            }
            this.consumeCssEscapeSequenceInto(out);
        }
        return StringUtil.releaseBuilder(out);
    }

    private void consumeCssEscapeSequenceInto(StringBuilder out) {
        if (this.isEmpty()) {
            out.append('\ufffd');
            return;
        }
        char firstEscaped = this.consume();
        if (!StringUtil.isHexDigit(firstEscaped)) {
            out.append(firstEscaped);
        } else {
            int codePoint;
            this.reader.unconsume();
            String hexString = this.reader.consumeMatching(StringUtil::isHexDigit, 6);
            try {
                codePoint = Integer.parseInt(hexString, 16);
            }
            catch (NumberFormatException e2) {
                throw new IllegalArgumentException("Invalid escape sequence: " + hexString, e2);
            }
            if (TokenQueue.isValidCodePoint(codePoint)) {
                out.appendCodePoint(codePoint);
            } else {
                out.append('\ufffd');
            }
            if (!this.isEmpty()) {
                char c2 = this.current();
                if (c2 == '\r') {
                    this.advance();
                    if (!this.isEmpty() && this.current() == '\n') {
                        this.advance();
                    }
                } else if (c2 == ' ' || c2 == '\t' || TokenQueue.isNewline(c2)) {
                    this.advance();
                }
            }
        }
    }

    private static boolean isNonAscii(char c2) {
        return c2 >= '\u0080';
    }

    private static boolean isIdentStart(char c2) {
        return c2 == '_' || StringUtil.isAsciiLetter(c2) || TokenQueue.isNonAscii(c2);
    }

    private static boolean isIdent(char c2) {
        return c2 == '-' || StringUtil.isDigit(c2) || TokenQueue.isIdentStart(c2);
    }

    private static boolean isNewline(char c2) {
        return c2 == '\n' || c2 == '\r' || c2 == '\f';
    }

    private static boolean isValidCodePoint(int codePoint) {
        return codePoint != 0 && Character.isValidCodePoint(codePoint) && !Character.isSurrogate((char)codePoint);
    }

    private String consumeEscapedCssIdentifier(char ... matches) {
        StringBuilder sb = StringUtil.borrowBuilder();
        while (!this.isEmpty()) {
            char c2 = this.current();
            if (c2 == '\\') {
                this.advance();
                if (this.isEmpty()) break;
                sb.append(this.consume());
                continue;
            }
            if (!this.matchesCssIdentifier(matches)) break;
            sb.append(c2);
            this.advance();
        }
        return StringUtil.releaseBuilder(sb);
    }

    private boolean matchesCssIdentifier(char ... matches) {
        return this.matchesWord() || this.reader.matchesAny(matches);
    }

    public String remainder() {
        return this.reader.consumeToEnd();
    }

    public String toString() {
        return this.reader.toString();
    }

    @Override
    public void close() {
        this.reader.close();
    }
}

