/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.exceptions;

import java.io.Serializable;
import org.snakeyaml.engine.v2.common.CharConstants;

public final class Mark
implements Serializable {
    private final String name;
    private final int index;
    private final int line;
    private final int column;
    private final int[] buffer;
    private final int pointer;

    public Mark(String name, int index, int line, int column2, int[] buffer, int pointer) {
        this.name = name;
        this.index = index;
        this.line = line;
        this.column = column2;
        this.buffer = buffer;
        this.pointer = pointer;
    }

    public Mark(String name, int index, int line, int column2, char[] str, int pointer) {
        this(name, index, line, column2, Mark.toCodePoints(str), pointer);
    }

    private static int[] toCodePoints(char[] str) {
        int[] codePoints = new int[Character.codePointCount(str, 0, str.length)];
        int i2 = 0;
        int c2 = 0;
        while (i2 < str.length) {
            int cp2;
            codePoints[c2] = cp2 = Character.codePointAt(str, i2);
            i2 += Character.charCount(cp2);
            ++c2;
        }
        return codePoints;
    }

    private boolean isLineBreak(int c2) {
        return CharConstants.NULL_OR_LINEBR.has(c2);
    }

    public String createSnippet(int indent, int maxLength) {
        int i2;
        float half = (float)maxLength / 2.0f - 1.0f;
        int start = this.pointer;
        String head2 = "";
        while (start > 0 && !this.isLineBreak(this.buffer[start - 1])) {
            if (!((float)(this.pointer - --start) > half)) continue;
            head2 = " ... ";
            start += 5;
            break;
        }
        String tail = "";
        int end = this.pointer;
        while (end < this.buffer.length && !this.isLineBreak(this.buffer[end])) {
            if (!((float)(++end - this.pointer) > half)) continue;
            tail = " ... ";
            end -= 5;
            break;
        }
        StringBuilder result2 = new StringBuilder();
        for (i2 = 0; i2 < indent; ++i2) {
            result2.append(" ");
        }
        result2.append(head2);
        for (i2 = start; i2 < end; ++i2) {
            result2.appendCodePoint(this.buffer[i2]);
        }
        result2.append(tail);
        result2.append("\n");
        for (i2 = 0; i2 < indent + this.pointer - start + head2.length(); ++i2) {
            result2.append(" ");
        }
        result2.append("^");
        return result2.toString();
    }

    public String createSnippet() {
        return this.createSnippet(4, 75);
    }

    public String toString() {
        String snippet = this.createSnippet();
        return " in " + this.name + ", line " + (this.line + 1) + ", column " + (this.column + 1) + ":\n" + snippet;
    }

    public String getName() {
        return this.name;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getIndex() {
        return this.index;
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    public int getPointer() {
        return this.pointer;
    }
}

