/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerRuntimesManager;
import com.intellij.docker.runtimes.DockerServerRuntime;
import com.intellij.docker.runtimes.presentation.api.DockerRuntimePresentationInterface;
import com.intellij.docker.splitApi.DockerRuntimeEventsCollector;
import com.intellij.docker.splitApi.DockerServerRuntimesManagerInterface;
import com.intellij.docker.view.DockerMainServiceViewContributor;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u001e\u0010\u0014\u001a\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0080@\u00a2\u0006\u0004\b\u0016\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/docker/DockerServerRuntimesManager;", "Lcom/intellij/docker/splitApi/DockerServerRuntimesManagerInterface;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myMessageBus", "Lcom/intellij/util/messages/MessageBusConnection;", "myServerRuntimes", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "Lcom/intellij/docker/runtimes/DockerServerRuntime;", "myConnections", "Lkotlinx/coroutines/Deferred;", "getServerRuntime", "server", "getOrCreateConnection", "Ljava/util/concurrent/CompletableFuture;", "disconnect", "", "disconnect$intellij_clouds_docker", "(Lcom/intellij/remoteServer/configuration/RemoteServer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "getRuntimePresentations", "", "Lcom/intellij/docker/runtimes/presentation/api/DockerRuntimePresentationInterface;", "Companion", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerServerRuntimesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerServerRuntimesManager.kt\ncom/intellij/docker/DockerServerRuntimesManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,112:1\n774#2:113\n865#2,2:114\n1563#2:116\n1634#2,3:117\n1#3:120\n13#4:121\n*S KotlinDebug\n*F\n+ 1 DockerServerRuntimesManager.kt\ncom/intellij/docker/DockerServerRuntimesManager\n*L\n110#1:113\n110#1:114,2\n110#1:116\n110#1:117,3\n93#1:121\n*E\n"})
public final class DockerServerRuntimesManager
implements DockerServerRuntimesManagerInterface,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MessageBusConnection myMessageBus;
    @NotNull
    private final ConcurrentHashMap<RemoteServer<DockerCloudConfiguration>, DockerServerRuntime> myServerRuntimes;
    @NotNull
    private final ConcurrentHashMap<RemoteServer<DockerCloudConfiguration>, Deferred<DockerServerRuntime>> myConnections;
    @NotNull
    private static final Logger log;

    private DockerServerRuntimesManager(Project project) {
        this.project = project;
        this.myMessageBus = this.project.getMessageBus().connect((Disposable)this);
        this.myServerRuntimes = new ConcurrentHashMap();
        this.myConnections = new ConcurrentHashMap();
        Topic topic = RemoteServerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        this.myMessageBus.subscribe(topic, (Object)new RemoteServerListener(){

            public void serverAdded(RemoteServer<?> server) {
                Intrinsics.checkNotNullParameter(server, (String)"server");
                if (server.getConfiguration() instanceof DockerCloudConfiguration) {
                    MessageBus messageBus = project.getMessageBus();
                    Topic topic = ServiceEventListener.TOPIC;
                    Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                    ((ServiceEventListener)messageBus.syncPublisher(topic)).handle(ServiceEventListener.ServiceEvent.createResetEvent(DockerMainServiceViewContributor.class));
                }
            }

            public void serverRemoved(RemoteServer<?> server) {
                Intrinsics.checkNotNullParameter(server, (String)"server");
                if (server.getConfiguration() instanceof DockerCloudConfiguration) {
                    Deferred deferred = (Deferred)TypeIntrinsics.asMutableMap((Object)myConnections).remove(server);
                    if (deferred != null) {
                        Job.DefaultImpls.cancel$default((Job)((Job)deferred), null, (int)1, null);
                    }
                    DockerServerRuntime dockerServerRuntime = (DockerServerRuntime)TypeIntrinsics.asMutableMap((Object)myServerRuntimes).remove(server);
                    if (dockerServerRuntime != null) {
                        Disposable p0 = (Disposable)dockerServerRuntime;
                        boolean bl = false;
                        Disposer.dispose((Disposable)p0);
                    }
                    MessageBus messageBus = project.getMessageBus();
                    Topic topic = ServiceEventListener.TOPIC;
                    Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                    ((ServiceEventListener)messageBus.syncPublisher(topic)).handle(ServiceEventListener.ServiceEvent.createResetEvent(DockerMainServiceViewContributor.class));
                    DockerRuntimeEventsCollector.Companion.getInstance(project).fireServerRuntimeRemoved(server);
                }
            }
        });
    }

    @ApiStatus.Internal
    @NotNull
    public final DockerServerRuntime getServerRuntime(@NotNull RemoteServer<DockerCloudConfiguration> server) {
        Intrinsics.checkNotNullParameter(server, (String)"server");
        DockerServerRuntime dockerServerRuntime = this.myServerRuntimes.computeIfAbsent(server, arg_0 -> DockerServerRuntimesManager.getServerRuntime$lambda$1(arg_0 -> DockerServerRuntimesManager.getServerRuntime$lambda$0(this, server, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dockerServerRuntime, (String)"computeIfAbsent(...)");
        return dockerServerRuntime;
    }

    @NotNull
    public final CompletableFuture<DockerServerRuntime> getOrCreateConnection(@NotNull RemoteServer<DockerCloudConfiguration> server) {
        Intrinsics.checkNotNullParameter(server, (String)"server");
        Deferred deferred = this.myConnections.compute(server, (arg_0, arg_1) -> DockerServerRuntimesManager.getOrCreateConnection$lambda$1((arg_0, arg_1) -> DockerServerRuntimesManager.getOrCreateConnection$lambda$0(this, server, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNull((Object)deferred);
        return FutureKt.asCompletableFuture((Deferred)deferred);
    }

    @Nullable
    public final Object disconnect$intellij_clouds_docker(@NotNull RemoteServer<DockerCloudConfiguration> server, @NotNull Continuation<? super Unit> $completion) {
        Deferred<DockerServerRuntime> deferred = this.myConnections.remove(server);
        if (deferred != null) {
            Job.DefaultImpls.cancel$default((Job)((Job)deferred), null, (int)1, null);
        }
        DockerServerRuntime dockerServerRuntime = this.myServerRuntimes.get(server);
        if (dockerServerRuntime != null) {
            Object object = dockerServerRuntime.disconnectImpl$intellij_clouds_docker($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    public void dispose() {
        this.myConnections.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<DockerRuntimePresentationInterface> getRuntimePresentations() {
        void $this$mapTo$iv$iv;
        RemoteServer server;
        Iterable $this$filterTo$iv$iv;
        List servers = RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance());
        Intrinsics.checkNotNull((Object)servers);
        Iterable $this$filter$iv = servers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            server = (RemoteServer)element$iv$iv;
            boolean bl = false;
            if (!((DockerCloudConfiguration)server.getConfiguration()).isVisibleInProject(this.project)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            server = (RemoteServer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.getServerRuntime((RemoteServer<DockerCloudConfiguration>)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final DockerServerRuntime getServerRuntime$lambda$0(DockerServerRuntimesManager this$0, RemoteServer $server, RemoteServer it) {
        Path path2;
        DockerServerRuntime dockerServerRuntime;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DockerServerRuntime serverRuntime = dockerServerRuntime = new DockerServerRuntime((RemoteServer<DockerCloudConfiguration>)it, this$0.project);
        boolean bl = false;
        Disposer.register((Disposable)this$0, (Disposable)((Disposable)serverRuntime));
        DockerCloudConfiguration dockerCloudConfiguration = serverRuntime.getConfiguration();
        String string = this$0.project.getProjectFilePath();
        if (string != null) {
            void path3;
            String string2 = string;
            DockerCloudConfiguration dockerCloudConfiguration2 = dockerCloudConfiguration;
            boolean bl2 = false;
            path2 = Path.of((String)path3, new String[0]);
            dockerCloudConfiguration = dockerCloudConfiguration2;
        } else {
            path2 = null;
        }
        dockerCloudConfiguration.setContextPath(path2);
        DockerRuntimeEventsCollector.Companion.getInstance(this$0.project).fireServerRuntimeAdded($server);
        return dockerServerRuntime;
    }

    private static final DockerServerRuntime getServerRuntime$lambda$1(Function1 $tmp0, Object p0) {
        return (DockerServerRuntime)$tmp0.invoke(p0);
    }

    private static final Deferred getOrCreateConnection$lambda$0(DockerServerRuntimesManager this$0, RemoteServer $server, RemoteServer remoteServer, Deferred cachedValue) {
        Deferred<DockerServerRuntime> validCachedValue;
        Deferred<DockerServerRuntime> deferred;
        Object object;
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)remoteServer, (String)"<unused var>");
        Deferred<DockerServerRuntime> deferred2 = cachedValue;
        Boolean bl2 = bl = deferred2 != null ? Boolean.valueOf(deferred2.isCompleted()) : null;
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            DockerServerRuntime manager;
            Object object2;
            Object object3 = this$0;
            try {
                DockerServerRuntimesManager $this$getOrCreateConnection_u24lambda_u240_u240 = object3;
                boolean bl3 = false;
                object2 = Result.constructor-impl((Object)((DockerServerRuntime)cachedValue.getCompleted()));
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object3 = object2;
            DockerServerRuntime dockerServerRuntime = manager = (DockerServerRuntime)(Result.isFailure-impl((Object)object3) ? null : object3);
            object = (dockerServerRuntime != null ? dockerServerRuntime.isConnected() : false) ? cachedValue : null;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            object = cachedValue;
        } else if (bl == null) {
            object = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if ((deferred = (validCachedValue = object)) == null) {
            deferred = this$0.getServerRuntime((RemoteServer<DockerCloudConfiguration>)$server).connectIfNeeded();
        }
        return deferred;
    }

    private static final Deferred getOrCreateConnection$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Deferred)$tmp0.invoke(p0, p1);
    }

    @JvmStatic
    @NotNull
    public static final DockerServerRuntimesManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @NotNull
    public static final List<DockerRuntimesManager> getConnectedManagers(@NotNull Project project) {
        return Companion.getConnectedManagers(project);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DockerServerRuntimesManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/DockerServerRuntimesManager$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/docker/DockerServerRuntimesManager;", "project", "Lcom/intellij/openapi/project/Project;", "getConnectedManagers", "", "Lcom/intellij/docker/DockerRuntimesManager;", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerServerRuntimesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerServerRuntimesManager.kt\ncom/intellij/docker/DockerServerRuntimesManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n30#2,2:113\n774#3:115\n865#3,2:116\n1563#3:118\n1634#3,3:119\n*S KotlinDebug\n*F\n+ 1 DockerServerRuntimesManager.kt\ncom/intellij/docker/DockerServerRuntimesManager$Companion\n*L\n96#1:113,2\n100#1:115\n100#1:116,2\n100#1:118\n100#1:119,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DockerServerRuntimesManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DockerServerRuntimesManager> serviceClass$iv = DockerServerRuntimesManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DockerServerRuntimesManager)object;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<DockerRuntimesManager> getConnectedManagers(@NotNull Project project) {
            void $this$mapTo$iv$iv;
            DockerServerRuntime p0;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Collection collection = this.getInstance(project).myServerRuntimes.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                p0 = (DockerServerRuntime)element$iv$iv;
                boolean bl = false;
                if (!p0.isConnected()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                p0 = (DockerServerRuntime)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getContext$intellij_clouds_docker().getRuntimesManager());
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

