/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.connection;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.util.WslPath;
import com.intellij.docker.agent.util.WslUtilsKt;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0001\u001a \u0010\u0006\u001a\u00020\u0004*\u00020\u00052\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\bH\u0002\u001a \u0010\t\u001a\u00020\u0004*\u00020\n2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\bH\u0002\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0001H\u0002\u00a8\u0006\f"}, d2={"getWSLId", "", "Lcom/intellij/docker/DockerCloudConfiguration;", "remapWinPathsToWslPaths", "", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "patchParametersAndEnvironment", "transform", "Lkotlin/Function1;", "patch", "Lcom/intellij/execution/configurations/ParametersList;", "assertPathIsNotInWindowsMounts", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerWslConnectionConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerWslConnectionConfigurator.kt\ncom/intellij/docker/connection/DockerWslConnectionConfiguratorKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n216#2,2:194\n1563#3:196\n1634#3,3:197\n*S KotlinDebug\n*F\n+ 1 DockerWslConnectionConfigurator.kt\ncom/intellij/docker/connection/DockerWslConnectionConfiguratorKt\n*L\n171#1:194,2\n177#1:196\n177#1:197,3\n*E\n"})
public final class DockerWslConnectionConfiguratorKt {
    @Nullable
    public static final String getWSLId(@NotNull DockerCloudConfiguration $this$getWSLId) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getWSLId), (String)"<this>");
        Map<String, String> map2 = $this$getWSLId.getContributedData();
        return map2 != null ? map2.get("DockerWslConnectionConfigurator.distribution") : null;
    }

    @VisibleForTesting
    public static final void remapWinPathsToWslPaths(@NotNull GeneralCommandLine $this$remapWinPathsToWslPaths) {
        Intrinsics.checkNotNullParameter((Object)$this$remapWinPathsToWslPaths, (String)"<this>");
        DockerWslConnectionConfiguratorKt.patchParametersAndEnvironment($this$remapWinPathsToWslPaths, (Function1<? super String, String>)((Function1)DockerWslConnectionConfiguratorKt::remapWinPathsToWslPaths$lambda$0));
    }

    private static final void patchParametersAndEnvironment(GeneralCommandLine $this$patchParametersAndEnvironment, Function1<? super String, String> transform) {
        ParametersList parametersList = $this$patchParametersAndEnvironment.getParametersList();
        Intrinsics.checkNotNullExpressionValue((Object)parametersList, (String)"getParametersList(...)");
        DockerWslConnectionConfiguratorKt.patch(parametersList, transform);
        for (ParamsGroup group2 : $this$patchParametersAndEnvironment.getParametersList().getParamsGroups()) {
            ParametersList parametersList2 = group2.getParametersList();
            Intrinsics.checkNotNullExpressionValue((Object)parametersList2, (String)"getParametersList(...)");
            DockerWslConnectionConfiguratorKt.patch(parametersList2, transform);
        }
        Map map2 = $this$patchParametersAndEnvironment.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvironment(...)");
        Map $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map map3;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            String key = (String)entry.getKey();
            String maybePath = (String)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)$this$patchParametersAndEnvironment.getEnvironment(), (String)"getEnvironment(...)");
            Intrinsics.checkNotNull((Object)maybePath);
            Object object = transform.invoke((Object)maybePath);
            map3.put(key, object);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void patch(ParametersList $this$patch, Function1<? super String, String> transform) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list = $this$patch.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
        List originalParameters = CollectionsKt.toList((Iterable)list);
        $this$patch.clearAll();
        Iterable iterable = originalParameters;
        ParametersList parametersList = $this$patch;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv.add(transform.invoke(item$iv$iv));
        }
        parametersList.addAll((List)destination$iv$iv);
    }

    private static final String assertPathIsNotInWindowsMounts(String $this$assertPathIsNotInWindowsMounts) throws IOException {
        if (StringsKt.startsWith$default((String)$this$assertPathIsNotInWindowsMounts, (String)"/mnt/", (boolean)false, (int)2, null)) {
            throw new IOException("Paths for executables in /mnt/ directory are excluded");
        }
        return $this$assertPathIsNotInWindowsMounts;
    }

    private static final String remapWinPathsToWslPaths$lambda$0(String maybePath) {
        Intrinsics.checkNotNullParameter((Object)maybePath, (String)"maybePath");
        Object object = WslPath.Companion.from(maybePath);
        if (object == null || (object = object.getLinuxPath()) == null) {
            object = WslUtilsKt.winPath2WslPath((String)maybePath);
        }
        return object;
    }

    public static final /* synthetic */ String access$assertPathIsNotInWindowsMounts(String $receiver) {
        return DockerWslConnectionConfiguratorKt.assertPathIsNotInWindowsMounts($receiver);
    }
}

