/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.rpc;

import com.intellij.openapi.editor.impl.EditorId;
import com.intellij.platform.debugger.impl.rpc.XBreakpointsSetDto;
import com.intellij.platform.debugger.impl.rpc.XDebugSessionsList;
import com.intellij.platform.debugger.impl.rpc.XDebuggerManagerApi;
import com.intellij.platform.project.ProjectId;
import com.intellij.xdebugger.impl.rpc.XDebugSessionId;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=3, xi=48)
@ApiStatus.Internal
public final class XDebuggerManagerApiClientStub
implements XDebuggerManagerApi {
    @NotNull
    private Function3<String, Object[], Continuation<Object>, Object> invocationHandler;

    public XDebuggerManagerApiClientStub(@NotNull Function3<? super String, ? super Object[], ? super Continuation<Object>, ? extends Object> invocationHandler) {
        Intrinsics.checkNotNullParameter(invocationHandler, (String)"invocationHandler");
        this.invocationHandler = invocationHandler;
    }

    @NotNull
    public final Function3<String, Object[], Continuation<Object>, Object> getInvocationHandler() {
        return this.invocationHandler;
    }

    @Override
    @Nullable
    public final Object currentSession(@NotNull ProjectId projectId, @NotNull Continuation<? super Flow<XDebugSessionId>> $completion) {
        Object[] objectArray = new Object[]{projectId};
        return this.invocationHandler.invoke((Object)"currentSession", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object sessions(@NotNull ProjectId projectId, @NotNull Continuation<? super XDebugSessionsList> $completion) {
        Object[] objectArray = new Object[]{projectId};
        return this.invocationHandler.invoke((Object)"sessions", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object reshowInlays(@NotNull ProjectId projectId, @Nullable EditorId editorId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{projectId, editorId};
        return this.invocationHandler.invoke((Object)"reshowInlays", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object getBreakpoints(@NotNull ProjectId projectId, @NotNull Continuation<? super XBreakpointsSetDto> $completion) {
        Object[] objectArray = new Object[]{projectId};
        return this.invocationHandler.invoke((Object)"getBreakpoints", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object sessionTabSelected(@NotNull ProjectId projectId, @Nullable XDebugSessionId sessionId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{projectId, sessionId};
        return this.invocationHandler.invoke((Object)"sessionTabSelected", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object sessionTabClosed(@NotNull XDebugSessionId sessionId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{sessionId};
        return this.invocationHandler.invoke((Object)"sessionTabClosed", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object showLibraryFrames(boolean show, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{Boxing.boxBoolean((boolean)show)};
        return this.invocationHandler.invoke((Object)"showLibraryFrames", (Object)objectArray, $completion);
    }
}

