/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.reworked;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.terminal.TerminalColorPalette;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.block.output.HighlightingInfo;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputHighlightingsSnapshot;
import org.jetbrains.plugins.terminal.block.output.TextStyleAdapter;
import org.jetbrains.plugins.terminal.block.reworked.AbstractTerminalOutputModelImpl;
import org.jetbrains.plugins.terminal.block.reworked.MutableTerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.MutableTerminalOutputModelImplKt;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOffset;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelListener;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelSnapshot;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelSnapshotImpl;
import org.jetbrains.plugins.terminal.block.ui.BlockTerminalColorPalette;
import org.jetbrains.plugins.terminal.session.StyleRange;
import org.jetbrains.plugins.terminal.session.TerminalOutputModelState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\\B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u00103\u001a\u000204H\u0016J&\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00112\u0006\u00108\u001a\u0002092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;H\u0016J.\u0010=\u001a\u0002062\u0006\u0010>\u001a\u00020\u00162\u0006\u0010?\u001a\u00020\u00062\u0006\u00108\u001a\u0002092\f\u0010@\u001a\b\u0012\u0004\u0012\u00020<0;H\u0016J\u0018\u0010A\u001a\u0002062\u0006\u00107\u001a\u00020\u00112\u0006\u0010B\u001a\u00020\u0006H\u0016J\u0010\u0010A\u001a\u0002062\u0006\u0010>\u001a\u00020\u0016H\u0016J&\u0010C\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u00062\u0006\u00108\u001a\u0002092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;H\u0002J\u0010\u0010E\u001a\u0002062\u0006\u0010D\u001a\u00020\u0006H\u0002J.\u0010F\u001a\u00020\u00062\u0006\u0010G\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\u00062\u0006\u00108\u001a\u0002092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;H\u0002J\b\u0010H\u001a\u000206H\u0002J\b\u0010I\u001a\u00020\u0006H\u0002J\u0010\u0010I\u001a\u00020\u00062\u0006\u0010J\u001a\u00020\u0006H\u0002J \u0010K\u001a\u0002062\b\b\u0002\u00102\u001a\u0002012\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00060MH\u0002J\b\u0010N\u001a\u00020OH\u0016J\u0012\u0010P\u001a\u0004\u0018\u00010Q2\u0006\u0010R\u001a\u00020\u0016H\u0016J\u0018\u0010S\u001a\u0002062\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\"H\u0016J\u0016\u0010W\u001a\u0002062\f\u0010L\u001a\b\u0012\u0004\u0012\u0002060MH\u0016J\b\u0010X\u001a\u00020YH\u0016J\u0010\u0010Z\u001a\u0002062\u0006\u0010[\u001a\u00020YH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u00060\u001fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010 \u001a\u0015\u0012\f\u0012\n #*\u0004\u0018\u00010\"0\"0!\u00a2\u0006\u0002\b$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u00020\u00118\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0013\"\u0004\b'\u0010(R\u001e\u0010)\u001a\u00020\u00118\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0013\"\u0004\b+\u0010(R\u001e\u0010,\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u000f\"\u0004\b.\u0010/R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lorg/jetbrains/plugins/terminal/block/reworked/MutableTerminalOutputModelImpl;", "Lorg/jetbrains/plugins/terminal/block/reworked/AbstractTerminalOutputModelImpl;", "Lorg/jetbrains/plugins/terminal/block/reworked/MutableTerminalOutputModel;", "document", "Lcom/intellij/openapi/editor/Document;", "maxOutputLength", "", "<init>", "(Lcom/intellij/openapi/editor/Document;I)V", "immutableText", "", "getImmutableText", "()Ljava/lang/CharSequence;", "lineCount", "getLineCount", "()I", "modificationStamp", "", "getModificationStamp", "()J", "mutableCursorOffsetState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOffset;", "cursorOffsetState", "Lkotlinx/coroutines/flow/StateFlow;", "getCursorOffsetState", "()Lkotlinx/coroutines/flow/StateFlow;", "cursorOffset", "getCursorOffset", "()Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOffset;", "highlightingsModel", "Lorg/jetbrains/plugins/terminal/block/reworked/MutableTerminalOutputModelImpl$HighlightingsModel;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "trimmedLinesCount", "getTrimmedLinesCount", "setTrimmedLinesCount", "(J)V", "trimmedCharsCount", "getTrimmedCharsCount", "setTrimmedCharsCount", "firstLineTrimmedCharsCount", "getFirstLineTrimmedCharsCount", "setFirstLineTrimmedCharsCount", "(I)V", "contentUpdateInProgress", "", "isTypeAhead", "snapshot", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelSnapshot;", "updateContent", "", "absoluteLineIndex", "text", "", "styles", "", "Lorg/jetbrains/plugins/terminal/session/StyleRange;", "replaceContent", "offset", "length", "newStyles", "updateCursorPosition", "columnIndex", "doUpdateContent", "documentLineIndex", "ensureDocumentHasLine", "doReplaceContent", "relativeStartOffset", "ensureCorrectCursorOffset", "trimToSize", "maxLength", "changeDocumentContent", "block", "Lkotlin/Function0;", "getHighlightings", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;", "getHighlightingAt", "Lorg/jetbrains/plugins/terminal/block/output/HighlightingInfo;", "documentOffset", "addListener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listener", "withTypeAhead", "dumpState", "Lorg/jetbrains/plugins/terminal/session/TerminalOutputModelState;", "restoreFromState", "state", "HighlightingsModel", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMutableTerminalOutputModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableTerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/block/reworked/MutableTerminalOutputModelImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,584:1\n60#2,5:585\n60#2,5:590\n60#2,5:595\n60#2,5:600\n60#2,5:605\n60#2,5:611\n1#3:610\n*S KotlinDebug\n*F\n+ 1 MutableTerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/block/reworked/MutableTerminalOutputModelImpl\n*L\n154#1:585,5\n180#1:590,5\n190#1:595,5\n207#1:600,5\n221#1:605,5\n173#1:611,5\n*E\n"})
public final class MutableTerminalOutputModelImpl
extends AbstractTerminalOutputModelImpl
implements MutableTerminalOutputModel {
    private final int maxOutputLength;
    @NotNull
    private final MutableStateFlow<TerminalOffset> mutableCursorOffsetState;
    @NotNull
    private final StateFlow<TerminalOffset> cursorOffsetState;
    @NotNull
    private final HighlightingsModel highlightingsModel;
    @NotNull
    private final EventDispatcher<TerminalOutputModelListener> dispatcher;
    @VisibleForTesting
    private long trimmedLinesCount;
    @VisibleForTesting
    private long trimmedCharsCount;
    @VisibleForTesting
    private int firstLineTrimmedCharsCount;
    private boolean contentUpdateInProgress;
    private boolean isTypeAhead;

    public MutableTerminalOutputModelImpl(@NotNull Document document, int maxOutputLength) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        super(document, null);
        this.maxOutputLength = maxOutputLength;
        this.mutableCursorOffsetState = StateFlowKt.MutableStateFlow((Object)this.absoluteOffset(0L));
        this.cursorOffsetState = FlowKt.asStateFlow(this.mutableCursorOffsetState);
        this.highlightingsModel = new HighlightingsModel();
        EventDispatcher eventDispatcher2 = EventDispatcher.create(TerminalOutputModelListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher2, (String)"create(...)");
        this.dispatcher = eventDispatcher2;
    }

    @Override
    @NotNull
    public CharSequence getImmutableText() {
        CharSequence charSequence = this.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        return charSequence;
    }

    @Override
    public int getLineCount() {
        return this.getDocument().getLineCount();
    }

    @Override
    public long getModificationStamp() {
        return this.getDocument().getModificationStamp();
    }

    @Override
    @NotNull
    public StateFlow<TerminalOffset> getCursorOffsetState() {
        return this.cursorOffsetState;
    }

    @Override
    @NotNull
    public TerminalOffset getCursorOffset() {
        return (TerminalOffset)this.getCursorOffsetState().getValue();
    }

    @Override
    public long getTrimmedLinesCount() {
        return this.trimmedLinesCount;
    }

    public void setTrimmedLinesCount(long l) {
        this.trimmedLinesCount = l;
    }

    @Override
    public long getTrimmedCharsCount() {
        return this.trimmedCharsCount;
    }

    public void setTrimmedCharsCount(long l) {
        this.trimmedCharsCount = l;
    }

    public final int getFirstLineTrimmedCharsCount() {
        return this.firstLineTrimmedCharsCount;
    }

    public final void setFirstLineTrimmedCharsCount(int n) {
        this.firstLineTrimmedCharsCount = n;
    }

    @Override
    @NotNull
    public TerminalOutputModelSnapshot snapshot() {
        Document document = this.getDocument();
        Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.DocumentImpl");
        FrozenDocument frozenDocument = ((DocumentImpl)document).freeze();
        Intrinsics.checkNotNullExpressionValue((Object)frozenDocument, (String)"freeze(...)");
        return new TerminalOutputModelSnapshotImpl(frozenDocument, this.getTrimmedCharsCount(), this.getTrimmedLinesCount(), this.getCursorOffset());
    }

    @Override
    public void updateContent(long absoluteLineIndex, @NotNull String text, @NotNull List<StyleRange> styles) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(styles, (String)"styles");
        MutableTerminalOutputModelImpl.changeDocumentContent$default(this, false, () -> MutableTerminalOutputModelImpl.updateContent$lambda$0(absoluteLineIndex, this, text, styles), 1, null);
    }

    @Override
    public void replaceContent(@NotNull TerminalOffset offset, int length, @NotNull String text, @NotNull List<StyleRange> newStyles) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(newStyles, (String)"newStyles");
        this.changeDocumentContent(this.isTypeAhead, (Function0<Integer>)((Function0)() -> MutableTerminalOutputModelImpl.replaceContent$lambda$0(this, offset, length, text, newStyles)));
    }

    @Override
    public void updateCursorPosition(long absoluteLineIndex, int columnIndex) {
        Logger logger;
        int documentLineIndex = (int)(absoluteLineIndex - this.getTrimmedLinesCount());
        Logger $this$debug_u24default$iv = MutableTerminalOutputModelImplKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Updating the cursor position to absolute line = " + absoluteLineIndex + " (relative " + documentLineIndex + "), column = " + columnIndex, e$iv);
        }
        this.ensureDocumentHasLine(documentLineIndex);
        int lineStartOffset = this.getDocument().getLineStartOffset(documentLineIndex);
        int lineEndOffset = this.getDocument().getLineEndOffset(documentLineIndex);
        int trimmedCharsInLine = documentLineIndex == 0 ? this.firstLineTrimmedCharsCount : 0;
        int trimmedColumnIndex = columnIndex - trimmedCharsInLine;
        int lineLength = lineEndOffset - lineStartOffset;
        if (trimmedColumnIndex > lineLength) {
            int spacesToAdd = trimmedColumnIndex - lineLength;
            String spaces = StringsKt.repeat((CharSequence)" ", (int)spacesToAdd);
            MutableTerminalOutputModelImpl.changeDocumentContent$default(this, false, () -> MutableTerminalOutputModelImpl.updateCursorPosition$lambda$1(this, lineEndOffset, spaces, spacesToAdd), 1, null);
        }
        int newCursorOffset = lineStartOffset + trimmedColumnIndex;
        Logger $this$debug_u24default$iv2 = MutableTerminalOutputModelImplKt.access$getLOG$p();
        Throwable e$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("Updated the cursor position to " + newCursorOffset, e$iv2);
        }
        this.mutableCursorOffsetState.setValue((Object)this.relativeOffset(newCursorOffset));
    }

    @Override
    public void updateCursorPosition(@NotNull TerminalOffset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        this.mutableCursorOffsetState.setValue((Object)offset);
    }

    private final int doUpdateContent(int documentLineIndex, String text, List<StyleRange> styles) {
        Logger logger;
        Logger $this$debug_u24default$iv = MutableTerminalOutputModelImplKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Content update from the relative line = " + documentLineIndex + " (absolute " + ((long)documentLineIndex + this.getTrimmedLinesCount()) + "), length = " + text.length() + ", current length = " + this.getDocument().getTextLength() + " chars, " + this.getDocument().getLineCount() + " lines, currently trimmed = " + this.getTrimmedCharsCount() + " chars, " + this.getTrimmedLinesCount() + " lines", e$iv);
        }
        this.ensureDocumentHasLine(documentLineIndex);
        int replaceStartOffset = this.getDocument().getLineStartOffset(documentLineIndex);
        this.getDocument().replaceString(replaceStartOffset, this.getDocument().getTextLength(), (CharSequence)text);
        this.ensureCorrectCursorOffset();
        this.highlightingsModel.removeAfter(replaceStartOffset);
        this.highlightingsModel.addHighlightings(replaceStartOffset, styles);
        int trimmedCount = this.trimToSize();
        Logger $this$debug_u24default$iv2 = MutableTerminalOutputModelImplKt.access$getLOG$p();
        Throwable e$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("Content updated from relative offset = " + replaceStartOffset + ", new length = " + this.getDocument().getTextLength() + " chars, " + this.getDocument().getLineCount() + " lines, currently trimmed = " + this.getTrimmedCharsCount() + " chars, " + this.getTrimmedLinesCount() + " lines", e$iv2);
        }
        return Math.max(0, replaceStartOffset - trimmedCount);
    }

    private final void ensureDocumentHasLine(int documentLineIndex) {
        if (documentLineIndex > 0 && documentLineIndex >= this.getDocument().getLineCount()) {
            int newLinesToAdd = documentLineIndex - this.getDocument().getLineCount() + 1;
            String newLines = StringsKt.repeat((CharSequence)"\n", (int)newLinesToAdd);
            this.getDocument().insertString(this.getDocument().getTextLength(), (CharSequence)newLines);
            Logger $this$debug_u24default$iv = MutableTerminalOutputModelImplKt.access$getLOG$p();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Added " + newLinesToAdd + " lines to make the line valid", e$iv);
            }
        }
    }

    private final int doReplaceContent(int relativeStartOffset, int length, String text, List<StyleRange> styles) {
        int relativeEndOffset = relativeStartOffset + length;
        this.getDocument().replaceString(relativeStartOffset, relativeEndOffset, (CharSequence)text);
        this.highlightingsModel.updateHighlightings(relativeStartOffset, length, text.length(), styles);
        int trimmedCount = this.trimToSize();
        this.ensureCorrectCursorOffset();
        return Math.max(0, relativeStartOffset - trimmedCount);
    }

    private final void ensureCorrectCursorOffset() {
        int newLength = this.getDocument().getTextLength();
        TerminalOffset docEndOffset = this.relativeOffset(newLength);
        if (((TerminalOffset)this.mutableCursorOffsetState.getValue()).compareTo(docEndOffset) > 0) {
            this.mutableCursorOffsetState.setValue((Object)docEndOffset);
        }
    }

    private final int trimToSize() {
        return this.maxOutputLength > 0 && this.getDocument().getTextLength() > this.maxOutputLength ? this.trimToSize(this.maxOutputLength) : 0;
    }

    private final int trimToSize(int maxLength) {
        int textLength = this.getDocument().getTextLength();
        if (!(textLength > maxLength)) {
            boolean $i$a$-check-MutableTerminalOutputModelImpl$trimToSize$22 = false;
            String $i$a$-check-MutableTerminalOutputModelImpl$trimToSize$22 = "This method should be called only if text length " + textLength + " is greater than max length " + maxLength;
            throw new IllegalStateException($i$a$-check-MutableTerminalOutputModelImpl$trimToSize$22.toString());
        }
        int lineCountBefore = this.getDocument().getLineCount();
        int removeUntilOffset = textLength - maxLength;
        int futureFirstLineNumber = this.getDocument().getLineNumber(removeUntilOffset);
        int futureFirstLineStart = this.getDocument().getLineStartOffset(futureFirstLineNumber);
        this.highlightingsModel.removeBefore(removeUntilOffset);
        this.setTrimmedCharsCount(this.getTrimmedCharsCount() + (long)removeUntilOffset);
        this.getDocument().deleteString(0, removeUntilOffset);
        this.setTrimmedLinesCount(this.getTrimmedLinesCount() + (long)(lineCountBefore - this.getDocument().getLineCount()));
        this.firstLineTrimmedCharsCount = removeUntilOffset - futureFirstLineStart;
        return removeUntilOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void changeDocumentContent(boolean isTypeAhead, Function0<Integer> block) {
        int n;
        ((TerminalOutputModelListener)this.dispatcher.getMulticaster()).beforeContentChanged(this);
        this.contentUpdateInProgress = true;
        try {
            n = ((Number)block.invoke()).intValue();
        }
        finally {
            this.contentUpdateInProgress = false;
        }
        int changeStartOffset = n;
        ((TerminalOutputModelListener)this.dispatcher.getMulticaster()).afterContentChanged(this, this.relativeOffset(changeStartOffset), isTypeAhead);
    }

    static /* synthetic */ void changeDocumentContent$default(MutableTerminalOutputModelImpl mutableTerminalOutputModelImpl, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        mutableTerminalOutputModelImpl.changeDocumentContent(bl, (Function0<Integer>)function0);
    }

    @Override
    @NotNull
    public TerminalOutputHighlightingsSnapshot getHighlightings() {
        return this.contentUpdateInProgress ? new TerminalOutputHighlightingsSnapshot(this.getDocument(), CollectionsKt.emptyList()) : this.highlightingsModel.getHighlightingsSnapshot();
    }

    @Override
    @Nullable
    public HighlightingInfo getHighlightingAt(@NotNull TerminalOffset documentOffset) {
        Intrinsics.checkNotNullParameter((Object)documentOffset, (String)"documentOffset");
        return this.highlightingsModel.getHighlightingAt(this.toRelative(documentOffset));
    }

    @Override
    public void addListener(@NotNull Disposable parentDisposable, @NotNull TerminalOutputModelListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.dispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withTypeAhead(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!(!this.isTypeAhead)) {
            boolean bl = false;
            String string = "Already in the type-ahead mode";
            throw new IllegalStateException(string.toString());
        }
        this.isTypeAhead = true;
        try {
            block.invoke();
        }
        finally {
            this.isTypeAhead = false;
        }
    }

    @Override
    @NotNull
    public TerminalOutputModelState dumpState() {
        String string = this.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new TerminalOutputModelState(string, this.getTrimmedLinesCount(), this.getTrimmedCharsCount(), this.firstLineTrimmedCharsCount, this.toRelative((TerminalOffset)this.getCursorOffsetState().getValue()), this.highlightingsModel.dumpState());
    }

    @Override
    public void restoreFromState(@NotNull TerminalOutputModelState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        MutableTerminalOutputModelImpl.changeDocumentContent$default(this, false, () -> MutableTerminalOutputModelImpl.restoreFromState$lambda$0(this, state), 1, null);
    }

    private static final int updateContent$lambda$0(long $absoluteLineIndex, MutableTerminalOutputModelImpl this$0, String $text, List $styles) {
        if ($absoluteLineIndex < this$0.getTrimmedLinesCount()) {
            this$0.setTrimmedLinesCount(0L);
            this$0.setTrimmedCharsCount(0L);
            this$0.firstLineTrimmedCharsCount = 0;
        }
        int documentLineIndex = (int)($absoluteLineIndex - this$0.getTrimmedLinesCount());
        return this$0.doUpdateContent(documentLineIndex, $text, $styles);
    }

    private static final int replaceContent$lambda$0(MutableTerminalOutputModelImpl this$0, TerminalOffset $offset, int $length, String $text, List $newStyles) {
        int relativeStartOffset = this$0.toRelative($offset);
        return this$0.doReplaceContent(relativeStartOffset, $length, $text, $newStyles);
    }

    private static final int updateCursorPosition$lambda$1(MutableTerminalOutputModelImpl this$0, int $lineEndOffset, String $spaces, int $spacesToAdd) {
        this$0.getDocument().insertString($lineEndOffset, (CharSequence)$spaces);
        Logger $this$debug_u24default$iv = MutableTerminalOutputModelImplKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Added " + $spacesToAdd + " spaces to make the column valid", e$iv);
        }
        this$0.highlightingsModel.insertEmptyHighlightings($lineEndOffset, $spacesToAdd);
        return $lineEndOffset;
    }

    private static final int restoreFromState$lambda$0(MutableTerminalOutputModelImpl this$0, TerminalOutputModelState $state) {
        this$0.setTrimmedLinesCount($state.getTrimmedLinesCount());
        this$0.setTrimmedCharsCount($state.getTrimmedCharsCount());
        this$0.firstLineTrimmedCharsCount = $state.getFirstLineTrimmedCharsCount();
        this$0.getDocument().setText((CharSequence)$state.getText());
        this$0.highlightingsModel.restoreFromState($state.getHighlightings());
        this$0.mutableCursorOffsetState.setValue((Object)this$0.relativeOffset($state.getCursorOffset()));
        return 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\nJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013J\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ,\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J \u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\u0013J\u0014\u0010$\u001a\u00020\u00112\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/terminal/block/reworked/MutableTerminalOutputModelImpl$HighlightingsModel;", "", "<init>", "(Lorg/jetbrains/plugins/terminal/block/reworked/MutableTerminalOutputModelImpl;)V", "colorPalette", "Lcom/intellij/terminal/TerminalColorPalette;", "styleRanges", "", "Lorg/jetbrains/plugins/terminal/session/StyleRange;", "highlightingsSnapshot", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;", "getHighlightingsSnapshot", "getHighlightingAt", "Lorg/jetbrains/plugins/terminal/block/output/HighlightingInfo;", "documentOffset", "", "addHighlightings", "", "styles", "", "insertEmptyHighlightings", "length", "removeAfter", "removeBefore", "updateHighlightings", "relativeStartOffset", "oldLength", "newLength", "shift", "shiftFromIndex", "updateAffectedRanges", "affectedIndexes", "Lkotlin/ranges/IntRange;", "affectedAbsoluteOffsets", "Lkotlin/ranges/LongRange;", "dumpState", "restoreFromState", "state", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nMutableTerminalOutputModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableTerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/block/reworked/MutableTerminalOutputModelImpl$HighlightingsModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,584:1\n1563#2:585\n1634#2,3:586\n1563#2:590\n1634#2,3:591\n1563#2:594\n1634#2,3:595\n1#3:589\n*S KotlinDebug\n*F\n+ 1 MutableTerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/block/reworked/MutableTerminalOutputModelImpl$HighlightingsModel\n*L\n368#1:585\n368#1:586,3\n408#1:590\n408#1:591,3\n482#1:594\n482#1:595,3\n*E\n"})
    private final class HighlightingsModel {
        @NotNull
        private final TerminalColorPalette colorPalette = new BlockTerminalColorPalette();
        @NotNull
        private final List<StyleRange> styleRanges = (List)new ArrayDeque();
        @Nullable
        private TerminalOutputHighlightingsSnapshot highlightingsSnapshot;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TerminalOutputHighlightingsSnapshot getHighlightingsSnapshot() {
            TerminalOutputHighlightingsSnapshot snapshot;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (this.highlightingsSnapshot != null) {
                TerminalOutputHighlightingsSnapshot terminalOutputHighlightingsSnapshot = this.highlightingsSnapshot;
                Intrinsics.checkNotNull((Object)terminalOutputHighlightingsSnapshot);
                return terminalOutputHighlightingsSnapshot;
            }
            Iterable iterable = this.styleRanges;
            MutableTerminalOutputModelImpl mutableTerminalOutputModelImpl = MutableTerminalOutputModelImpl.this;
            boolean $i$f$map = false;
            void var5_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StyleRange styleRange = (StyleRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new HighlightingInfo((int)(it.getStartOffset() - mutableTerminalOutputModelImpl.getTrimmedCharsCount()), (int)(it.getEndOffset() - mutableTerminalOutputModelImpl.getTrimmedCharsCount()), new TextStyleAdapter(it.getStyle(), this.colorPalette, it.getIgnoreContrastAdjustment())));
            }
            List documentRelativeHighlightings = (List)destination$iv$iv;
            this.highlightingsSnapshot = snapshot = new TerminalOutputHighlightingsSnapshot(MutableTerminalOutputModelImpl.this.getDocument(), documentRelativeHighlightings);
            return snapshot;
        }

        @Nullable
        public final HighlightingInfo getHighlightingAt(int documentOffset) {
            HighlightingInfo highlightingInfo;
            if (documentOffset < 0 || documentOffset >= MutableTerminalOutputModelImpl.this.getDocument().getTextLength()) {
                return null;
            }
            long absoluteOffset = (long)documentOffset + MutableTerminalOutputModelImpl.this.getTrimmedCharsCount();
            int index = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.getHighlightingAt$lambda$0(absoluteOffset, arg_0), (int)3, null);
            if (index >= 0) {
                StyleRange range = this.styleRanges.get(index);
                highlightingInfo = new HighlightingInfo((int)(range.getStartOffset() - MutableTerminalOutputModelImpl.this.getTrimmedCharsCount()), (int)(range.getEndOffset() - MutableTerminalOutputModelImpl.this.getTrimmedCharsCount()), new TextStyleAdapter(range.getStyle(), this.colorPalette, range.getIgnoreContrastAdjustment()));
            } else {
                highlightingInfo = null;
            }
            return highlightingInfo;
        }

        /*
         * WARNING - void declaration
         */
        public final void addHighlightings(int documentOffset, @NotNull List<StyleRange> styles) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(styles, (String)"styles");
            long absoluteOffset = (long)documentOffset + MutableTerminalOutputModelImpl.this.getTrimmedCharsCount();
            if (!(this.styleRanges.isEmpty() || ((StyleRange)CollectionsKt.last(this.styleRanges)).getEndOffset() <= absoluteOffset)) {
                boolean $i$a$-check-MutableTerminalOutputModelImpl$HighlightingsModel$addHighlightings$22 = false;
                String $i$a$-check-MutableTerminalOutputModelImpl$HighlightingsModel$addHighlightings$22 = "New highlightings overlap with existing";
                throw new IllegalStateException($i$a$-check-MutableTerminalOutputModelImpl$HighlightingsModel$addHighlightings$22.toString());
            }
            Iterable $this$map$iv = styles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StyleRange styleRange = (StyleRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StyleRange.copy$default((StyleRange)it, absoluteOffset + it.getStartOffset(), absoluteOffset + it.getEndOffset(), null, false, 12, null));
            }
            List adjustedStyles = (List)destination$iv$iv;
            this.styleRanges.addAll(adjustedStyles);
            this.highlightingsSnapshot = null;
        }

        public final void insertEmptyHighlightings(int documentOffset, int length) {
            int updateFromIndex;
            long absoluteOffset = (long)documentOffset + MutableTerminalOutputModelImpl.this.getTrimmedCharsCount();
            int styleIndex = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.insertEmptyHighlightings$lambda$0(absoluteOffset, arg_0), (int)3, null);
            int n = updateFromIndex = styleIndex < 0 ? -styleIndex - 1 : styleIndex;
            if (updateFromIndex < this.styleRanges.size()) {
                int n2 = this.styleRanges.size();
                for (int ind = updateFromIndex; ind < n2; ++ind) {
                    StyleRange cur = this.styleRanges.get(ind);
                    this.styleRanges.set(ind, StyleRange.copy$default(cur, cur.getStartOffset() + (long)length, cur.getEndOffset() + (long)length, null, false, 12, null));
                }
                this.highlightingsSnapshot = null;
            }
        }

        public final void removeAfter(int documentOffset) {
            int ind;
            long absoluteOffset = (long)documentOffset + MutableTerminalOutputModelImpl.this.getTrimmedCharsCount();
            int styleIndex = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.removeAfter$lambda$0(absoluteOffset, arg_0), (int)3, null);
            int removeFromIndex = styleIndex < 0 ? -styleIndex - 1 : styleIndex + 1;
            if (removeFromIndex <= (ind = this.styleRanges.size() - 1)) {
                while (true) {
                    this.styleRanges.remove(ind);
                    if (ind == removeFromIndex) break;
                    --ind;
                }
            }
            this.highlightingsSnapshot = null;
        }

        public final void removeBefore(int documentOffset) {
            long absoluteOffset = (long)documentOffset + MutableTerminalOutputModelImpl.this.getTrimmedCharsCount();
            int styleIndex = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.removeBefore$lambda$0(absoluteOffset, arg_0), (int)3, null);
            int removeUntilHighlightingIndex = styleIndex < 0 ? -styleIndex - 1 : styleIndex;
            int n = 0;
            while (n < removeUntilHighlightingIndex) {
                int it = n++;
                boolean bl = false;
                this.styleRanges.remove(0);
            }
            this.highlightingsSnapshot = null;
        }

        /*
         * WARNING - void declaration
         */
        public final void updateHighlightings(int relativeStartOffset, int oldLength, int newLength, @NotNull List<StyleRange> styles) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(styles, (String)"styles");
            long absoluteStartOffset = (long)relativeStartOffset + MutableTerminalOutputModelImpl.this.getTrimmedCharsCount();
            long absoluteEndOffset = absoluteStartOffset + (long)oldLength;
            int i = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.updateHighlightings$lambda$0(absoluteStartOffset, arg_0), (int)3, null);
            boolean bl = false;
            int lastUnaffectedIndexBefore = i >= 0 ? i : -i - 2;
            int i2 = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.updateHighlightings$lambda$2(absoluteEndOffset, arg_0), (int)3, null);
            boolean bl2 = false;
            int firstUnaffectedIndexAfter = i2 >= 0 ? i2 : -i2 - 1;
            int shift = newLength - oldLength;
            this.shift(firstUnaffectedIndexAfter, shift);
            this.updateAffectedRanges(RangesKt.until((int)(lastUnaffectedIndexBefore + 1), (int)firstUnaffectedIndexAfter), RangesKt.until((long)absoluteStartOffset, (long)absoluteEndOffset), shift);
            int i3 = CollectionsKt.binarySearch$default(this.styleRanges, (int)0, (int)0, arg_0 -> HighlightingsModel.updateHighlightings$lambda$4(absoluteEndOffset, shift, arg_0), (int)3, null);
            boolean bl3 = false;
            int insertionIndex = i3 >= 0 ? i3 : -i3 - 1;
            Iterable $this$map$iv = styles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void styleRange;
                StyleRange styleRange2 = (StyleRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(StyleRange.copy$default((StyleRange)styleRange, styleRange.getStartOffset() + absoluteStartOffset, styleRange.getEndOffset() + absoluteStartOffset, null, false, 12, null));
            }
            List absoluteStyles = (List)destination$iv$iv;
            this.styleRanges.addAll(insertionIndex, absoluteStyles);
        }

        private final void shift(int shiftFromIndex, int shift) {
            if (shift == 0) {
                return;
            }
            int n = this.styleRanges.size();
            for (int i = shiftFromIndex; i < n; ++i) {
                StyleRange styleRange = this.styleRanges.get(i);
                this.styleRanges.set(i, StyleRange.copy$default(styleRange, styleRange.getStartOffset() + (long)shift, styleRange.getEndOffset() + (long)shift, null, false, 12, null));
            }
        }

        private final void updateAffectedRanges(IntRange affectedIndexes, LongRange affectedAbsoluteOffsets, int shift) {
            if (affectedIndexes.isEmpty()) {
                return;
            }
            long absoluteStartOffset = affectedAbsoluteOffsets.getFirst();
            long absoluteEndOffset = affectedAbsoluteOffsets.getLast() + 1L;
            List<StyleRange> affectedRanges = this.styleRanges.subList(affectedIndexes.getFirst(), affectedIndexes.getLast() + 1);
            List updatedRanges = new ArrayList();
            for (StyleRange range : affectedRanges) {
                if (range.getStartOffset() < absoluteStartOffset && range.getEndOffset() <= absoluteEndOffset) {
                    updatedRanges.add(StyleRange.copy$default(range, 0L, absoluteStartOffset, null, false, 13, null));
                    continue;
                }
                long l = affectedAbsoluteOffsets.getFirst();
                long l2 = affectedAbsoluteOffsets.getLast();
                long l3 = range.getStartOffset();
                boolean bl = l <= l3 ? l3 <= l2 : false;
                if (bl && range.getEndOffset() > absoluteEndOffset) {
                    updatedRanges.add(StyleRange.copy$default(range, absoluteEndOffset + (long)shift, range.getEndOffset() + (long)shift, null, false, 12, null));
                    continue;
                }
                if (range.getStartOffset() >= absoluteStartOffset || range.getEndOffset() <= absoluteEndOffset) continue;
                updatedRanges.add(StyleRange.copy$default(range, 0L, absoluteStartOffset, null, false, 13, null));
                updatedRanges.add(StyleRange.copy$default(range, absoluteEndOffset + (long)shift, range.getEndOffset() + (long)shift, null, false, 12, null));
            }
            affectedRanges.clear();
            affectedRanges.addAll(updatedRanges);
        }

        @NotNull
        public final List<StyleRange> dumpState() {
            return CollectionsKt.toList((Iterable)this.styleRanges);
        }

        public final void restoreFromState(@NotNull List<StyleRange> state) {
            Intrinsics.checkNotNullParameter(state, (String)"state");
            this.styleRanges.clear();
            this.styleRanges.addAll((Collection<StyleRange>)state);
            this.highlightingsSnapshot = null;
        }

        private static final int getHighlightingAt$lambda$0(long $absoluteOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getEndOffset() <= $absoluteOffset ? -1 : (it.getStartOffset() > $absoluteOffset ? 1 : 0);
        }

        private static final int insertEmptyHighlightings$lambda$0(long $absoluteOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((long)it.getStartOffset(), (long)$absoluteOffset);
        }

        private static final int removeAfter$lambda$0(long $absoluteOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((long)it.getEndOffset(), (long)$absoluteOffset);
        }

        private static final int removeBefore$lambda$0(long $absoluteOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((long)it.getStartOffset(), (long)$absoluteOffset);
        }

        private static final int updateHighlightings$lambda$0(long $absoluteStartOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((long)it.getEndOffset(), (long)$absoluteStartOffset);
        }

        private static final int updateHighlightings$lambda$2(long $absoluteEndOffset, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((long)it.getStartOffset(), (long)$absoluteEndOffset);
        }

        private static final int updateHighlightings$lambda$4(long $absoluteEndOffset, int $shift, StyleRange it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.compare((long)it.getStartOffset(), (long)($absoluteEndOffset + (long)$shift));
        }
    }
}

