/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.runner;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelExecApi;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.eel.provider.utils.EelUtilsKt;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.util.EnvironmentRestorer;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.OS;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalStartupKt;
import org.jetbrains.plugins.terminal.runner.LocalTerminalStartCommandBuilder;
import org.jetbrains.plugins.terminal.util.TerminalEnvironment;

@ApiStatus.Internal
public final class LocalOptionsConfigurer {
    private static final Logger LOG = Logger.getInstance(LocalOptionsConfigurer.class);

    @NotNull
    public static ShellStartupOptions configureStartupOptions(@NotNull ShellStartupOptions baseOptions, @NotNull Project project) {
        if (baseOptions == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(0);
        }
        if (project == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(1);
        }
        String workingDir = LocalOptionsConfigurer.getWorkingDirectory(baseOptions.getWorkingDirectory(), project);
        List<String> initialCommand = LocalOptionsConfigurer.getInitialCommand(baseOptions, project, workingDir);
        EelDescriptor eelDescriptor = TerminalStartupKt.findEelDescriptor(workingDir, initialCommand);
        Map<String, String> envs = LocalOptionsConfigurer.getTerminalEnvironment(baseOptions.getEnvVariables(), project, eelDescriptor, initialCommand);
        TerminalWidget widget = baseOptions.getWidget();
        if (widget != null) {
            widget.setShellCommand(initialCommand);
        }
        ShellStartupOptions shellStartupOptions = baseOptions.builder().shellCommand(initialCommand).workingDirectory(workingDir).envVariables(envs).build();
        if (shellStartupOptions == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(2);
        }
        return shellStartupOptions;
    }

    @VisibleForTesting
    @NotNull
    static String getWorkingDirectory(@Nullable String directory, Project project) {
        String validDirectory = LocalOptionsConfigurer.findValidWorkingDirectory(directory);
        if (validDirectory != null) {
            String string = validDirectory;
            if (string == null) {
                LocalOptionsConfigurer.$$$reportNull$$$0(3);
            }
            return string;
        }
        String configuredWorkingDirectory = TerminalProjectOptionsProvider.getInstance(project).getStartingDirectory();
        if (configuredWorkingDirectory != null && LocalTerminalDirectRunner.isDirectory(configuredWorkingDirectory)) {
            String string = configuredWorkingDirectory;
            if (string == null) {
                LocalOptionsConfigurer.$$$reportNull$$$0(4);
            }
            return string;
        }
        String defaultWorkingDirectory = TerminalProjectOptionsProvider.getInstance(project).getDefaultStartingDirectory();
        if (defaultWorkingDirectory != null && LocalTerminalDirectRunner.isDirectory(defaultWorkingDirectory)) {
            String string = defaultWorkingDirectory;
            if (string == null) {
                LocalOptionsConfigurer.$$$reportNull$$$0(5);
            }
            return string;
        }
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        if (projectDir != null) {
            String string = VfsUtilCore.virtualToIoFile((VirtualFile)projectDir).getAbsolutePath();
            if (string == null) {
                LocalOptionsConfigurer.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = SystemProperties.getUserHome();
        if (string == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static String findValidWorkingDirectory(@Nullable String path) {
        Path directoryPath;
        if (path == null) {
            return null;
        }
        try {
            directoryPath = Path.of(path, new String[0]);
        }
        catch (InvalidPathException e) {
            return null;
        }
        if (Files.isDirectory(directoryPath, new LinkOption[0])) {
            return directoryPath.toString();
        }
        Path parentPath = directoryPath.getParent();
        if (parentPath != null && Files.isDirectory(parentPath, new LinkOption[0])) {
            return parentPath.toString();
        }
        return null;
    }

    @NotNull
    private static Map<String, String> getTerminalEnvironment(@NotNull Map<String, String> baseEnvs, @NotNull Project project, @NotNull EelDescriptor eelDescriptor, @NotNull List<String> shellCommand) {
        EnvironmentVariablesData trustedEnvData;
        boolean isWindows;
        if (baseEnvs == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(8);
        }
        if (project == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(9);
        }
        if (eelDescriptor == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(10);
        }
        if (shellCommand == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(11);
        }
        Map envs = (isWindows = EelPlatformKt.isWindows((EelOsFamily)eelDescriptor.getOsFamily())) ? CollectionFactory.createCaseInsensitiveStringMap() : new HashMap();
        EnvironmentVariablesData envData = TerminalProjectOptionsProvider.getInstance(project).getEnvData();
        if (envData.isPassParentEnvs()) {
            if (eelDescriptor == LocalEelDescriptor.INSTANCE) {
                envs.putAll(System.getenv());
            } else {
                envs.putAll(LocalOptionsConfigurer.fetchLoginShellEnvVariables(eelDescriptor));
            }
            EnvironmentRestorer.restoreOverriddenVars((Map)envs);
            if (envs.isEmpty()) {
                LOG.warn("Empty parent environment for " + String.valueOf(shellCommand) + " on (" + eelDescriptor.getMachine().getName() + ")");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parent environment for " + String.valueOf(shellCommand) + " on (" + eelDescriptor.getMachine().getName() + "): " + String.valueOf(envs));
            }
        } else {
            LOG.info("No parent environment passed");
        }
        envs.putAll(baseEnvs);
        if (!isWindows) {
            envs.put("TERM", "xterm-256color");
        }
        envs.put("TERMINAL_EMULATOR", "JetBrains-JediTerm");
        envs.put("TERM_SESSION_ID", UUID.randomUUID().toString());
        TerminalEnvironment.INSTANCE.setCharacterEncoding(envs);
        Object object = trustedEnvData = TrustedProjects.isProjectTrusted((Project)project) ? envData : null;
        if (trustedEnvData != null) {
            PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)project);
            for (Map.Entry env : trustedEnvData.getEnvs().entrySet()) {
                envs.put((String)env.getKey(), macroManager.expandPath((String)env.getValue()));
            }
        }
        TerminalEnvironment.setWslEnv(eelDescriptor, shellCommand, trustedEnvData, envs);
        Map map2 = envs;
        if (map2 == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(12);
        }
        return map2;
    }

    @NotNull
    private static List<String> getInitialCommand(@NotNull ShellStartupOptions options, @NotNull Project project, @NotNull String workingDir) {
        List<String> shellCommand;
        if (options == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(13);
        }
        if (project == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(14);
        }
        if (workingDir == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(15);
        }
        if ((shellCommand = LocalOptionsConfigurer.fixShellCommand(options.getShellCommand())) != null) {
            List<String> list = shellCommand;
            if (list == null) {
                LocalOptionsConfigurer.$$$reportNull$$$0(16);
            }
            return list;
        }
        String shellPath2 = LocalOptionsConfigurer.fixShellPath(LocalOptionsConfigurer.getShellPath(project), workingDir);
        List<String> list = LocalTerminalStartCommandBuilder.convertShellPathToCommand(shellPath2, workingDir);
        if (list == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Nullable
    private static List<String> fixShellCommand(@Nullable List<String> shellCommand) {
        if (OS.CURRENT == OS.Windows && !TerminalStartupKt.shouldUseEelApi() && LocalOptionsConfigurer.isUnixPath((String)ContainerUtil.getFirstItem(shellCommand))) {
            return null;
        }
        return shellCommand;
    }

    @NotNull
    private static String fixShellPath(@NotNull String shellPath2, @NotNull String workingDirectory) {
        WslPath wslPath;
        if (shellPath2 == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(18);
        }
        if (workingDirectory == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(19);
        }
        if (OS.CURRENT == OS.Windows && !TerminalStartupKt.shouldUseEelApi() && LocalOptionsConfigurer.isUnixPath(shellPath2) && (wslPath = WslPath.parseWindowsUncPath((String)workingDirectory)) != null) {
            String string = "wsl.exe --distribution " + wslPath.getDistributionId();
            if (string == null) {
                LocalOptionsConfigurer.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = shellPath2;
        if (string == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static boolean isUnixPath(@Nullable String path) {
        return path != null && path.startsWith("/") && !path.startsWith("//");
    }

    @NotNull
    private static String getShellPath(@NotNull Project project) {
        if (project == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(22);
        }
        String string = TerminalProjectOptionsProvider.getInstance(project).getShellPath();
        if (string == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static Map<String, String> fetchLoginShellEnvVariables(@NotNull EelDescriptor eelDescriptor) {
        if (eelDescriptor == null) {
            LocalOptionsConfigurer.$$$reportNull$$$0(24);
        }
        return EelUtilsKt.fetchLoginShellEnvVariablesBlocking((EelExecApi)EelProviderUtil.toEelApiBlocking((EelDescriptor)eelDescriptor).getExec());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 12, 16, 17, 20, 21, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseOptions";
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/runner/LocalOptionsConfigurer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseEnvs";
                break;
            }
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eelDescriptor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellCommand";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellPath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/runner/LocalOptionsConfigurer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "configureStartupOptions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalEnvironment";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialCommand";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "fixShellPath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureStartupOptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTerminalEnvironment";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getInitialCommand";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fixShellPath";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getShellPath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fetchLoginShellEnvVariables";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 12, 16, 17, 20, 21, 23 -> new IllegalStateException(string);
        };
    }
}

