/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.common;

import com.google.common.collect.ImmutableList;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PortsBuilder {
    @NotNull
    private final ImmutableList.Builder<Integer> myExposedPorts = ImmutableList.builder();
    @NotNull
    private final ImmutableList.Builder<DockerPortBinding> myPortBinding = ImmutableList.builder();

    private PortsBuilder() {
    }

    @NotNull
    public static PortsBuilder builder() {
        return new PortsBuilder();
    }

    @NotNull
    public PortsBuilder addPortBinding(int containerPort, int hostPort) {
        DockerPortBindingImpl binding = new DockerPortBindingImpl();
        binding.setContainerPort(containerPort);
        binding.setHostPort(hostPort);
        this.myPortBinding.add((Object)binding);
        this.myExposedPorts.add((Object)containerPort);
        PortsBuilder portsBuilder = this;
        if (portsBuilder == null) {
            PortsBuilder.$$$reportNull$$$0(0);
        }
        return portsBuilder;
    }

    @NotNull
    public PortsBuilder addPortBindings(List<? extends DockerPortBinding> bindings) {
        this.myPortBinding.addAll(bindings);
        this.myExposedPorts.addAll((Iterable)ContainerUtil.map(bindings, DockerPortBinding::getContainerPort));
        PortsBuilder portsBuilder = this;
        if (portsBuilder == null) {
            PortsBuilder.$$$reportNull$$$0(1);
        }
        return portsBuilder;
    }

    public DockerPortBinding[] buildPortBindings() {
        ImmutableList result2 = this.myPortBinding.build();
        return (DockerPortBinding[])result2.toArray((Object[])new DockerPortBinding[0]);
    }

    public Integer @NotNull [] buildExposedPorts() {
        ImmutableList exposedPorts = this.myExposedPorts.build();
        Integer[] integerArray = (Integer[])exposedPorts.toArray((Object[])new Integer[0]);
        if (integerArray == null) {
            PortsBuilder.$$$reportNull$$$0(2);
        }
        return integerArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/docker/remote/run/common/PortsBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "addPortBinding";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "addPortBindings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExposedPorts";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

