/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ReadEnv;
import com.intellij.util.system.OS;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class ShellEnvironmentReader {
    private static final Logger LOG = Logger.getInstance(ShellEnvironmentReader.class);
    private static final String OUTPUT_PLACEHOLDER = "__OUTPUT_PLACEHOLDER__";
    private static final String INTELLIJ_ENVIRONMENT_READER = "INTELLIJ_ENVIRONMENT_READER";
    private static final String DISABLE_OMZ_AUTO_UPDATE = "DISABLE_AUTO_UPDATE";
    private static final long DEFAULT_TIMEOUT_MILLIS = 20000L;

    private ShellEnvironmentReader() {
    }

    @NotNull
    public static ProcessBuilder shellCommand(@Nullable String shell, @Nullable Path shFile, @Nullable List<@NotNull String> args) {
        Object reader;
        if (shell == null && ((shell = System.getenv("SHELL")) == null || shell.isBlank())) {
            throw new IllegalStateException("'SHELL' environment variable is not set");
        }
        if (shFile != null && !Files.exists(shFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Missing: " + String.valueOf(shFile));
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(shell);
        String name = Path.of(shell, new String[0]).getFileName().toString();
        if (!"csh".equals(name) && !"tcsh".equals(name)) {
            command.add("-l");
        }
        if (!"fish".equals(name)) {
            command.add("-i");
        }
        Object object = reader = OS.CURRENT == OS.macOS ? "'" + String.valueOf(PathManager.findBinFileWithException((String)"printenv")) + "'" : "/usr/bin/env -0";
        if (shFile != null) {
            if ("nu".equals(name) || "pwsh".equals(name) || "xonsh".equals(name)) {
                throw new UnsupportedOperationException("Sourcing external scripts is not supported for '" + name + "'");
            }
            reader = ". '" + String.valueOf(shFile) + "' && " + (String)reader;
        }
        command.add("-c");
        if ("nu".equals(name)) {
            command.add((((String)reader).charAt(0) == '\'' ? "^" : "") + (String)reader + " out> '__OUTPUT_PLACEHOLDER__'");
        } else if ("pwsh".equals(name) && ((String)reader).charAt(0) == '\'') {
            command.add("&" + (String)reader + " > '__OUTPUT_PLACEHOLDER__'");
        } else if ("xonsh".equals(name) && ((String)reader).charAt(0) == '\'') {
            command.add("$[" + (String)reader + " > '__OUTPUT_PLACEHOLDER__']");
        } else {
            command.add((String)reader + " > '__OUTPUT_PLACEHOLDER__'");
        }
        if (shFile != null) {
            command.add(shFile.toString());
            if (args != null) {
                command.addAll(args);
            }
        }
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        ShellEnvironmentReader.setWorkingDir(shFile, processBuilder);
        if ("zsh".equals(name)) {
            processBuilder.environment().put(DISABLE_OMZ_AUTO_UPDATE, "true");
        }
        ProcessBuilder processBuilder2 = processBuilder;
        if (processBuilder2 == null) {
            ShellEnvironmentReader.$$$reportNull$$$0(0);
        }
        return processBuilder2;
    }

    @NotNull
    public static ProcessBuilder winShellCommand(@Nullable Path batFile, @Nullable List<@NotNull String> args) {
        if (batFile != null && !Files.exists(batFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Missing: " + String.valueOf(batFile));
        }
        ArrayList<String> callArgs = new ArrayList<String>();
        if (batFile != null) {
            callArgs.add("call");
            callArgs.add(batFile.toString());
            if (args != null) {
                callArgs.addAll(args);
            }
            callArgs.add("&&");
        }
        callArgs.add(ShellEnvironmentReader.javaExePath());
        callArgs.add("-cp");
        callArgs.add(ShellEnvironmentReader.readEnvClasspath());
        callArgs.add(ReadEnv.class.getName());
        callArgs.add(OUTPUT_PLACEHOLDER);
        callArgs.add("||");
        callArgs.add("exit");
        callArgs.add("/B");
        callArgs.add("%ERRORLEVEL%");
        ProcessBuilder processBuilder = new ProcessBuilder(CommandLineUtil.getWinShellName(), "/c", ShellEnvironmentReader.prepareCallArgs(callArgs));
        ShellEnvironmentReader.setWorkingDir(batFile, processBuilder);
        ProcessBuilder processBuilder2 = processBuilder;
        if (processBuilder2 == null) {
            ShellEnvironmentReader.$$$reportNull$$$0(1);
        }
        return processBuilder2;
    }

    private static String prepareCallArgs(List<String> callArgs) {
        List preparedCallArgs = CommandLineUtil.toCommandLine(callArgs);
        String firstArg = (String)preparedCallArgs.remove(0);
        preparedCallArgs.add(0, CommandLineUtil.escapeParameterOnWindows((String)firstArg, (boolean)false));
        return "\"" + String.join((CharSequence)" ", preparedCallArgs) + "\"";
    }

    @NotNull
    public static ProcessBuilder powerShellCommand(@Nullable Path psFile, @Nullable List<@NotNull String> args) {
        if (psFile != null && !Files.exists(psFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Missing: " + String.valueOf(psFile));
        }
        String innerScriptlet = "";
        if (psFile != null) {
            String argsStr = args == null ? "" : String.join((CharSequence)" ", args);
            innerScriptlet = String.format(Locale.ROOT, "& '%s' %s ; if (-not $?) { exit $LASTEXITCODE }; ", psFile, argsStr);
        }
        String scriptlet = String.format(Locale.ROOT, "& { %s & '%s' -cp '%s' %s '%s' ; exit $LASTEXITCODE }", innerScriptlet, ShellEnvironmentReader.javaExePath(), ShellEnvironmentReader.readEnvClasspath(), ReadEnv.class.getName(), OUTPUT_PLACEHOLDER);
        String shellName = PathEnvironmentVariableUtil.findExecutableInWindowsPath("pwsh", "powershell.exe");
        ProcessBuilder processBuilder = new ProcessBuilder(shellName, "-ExecutionPolicy", "Bypass", "-NonInteractive", "-Command", scriptlet);
        ShellEnvironmentReader.setWorkingDir(psFile, processBuilder);
        ProcessBuilder processBuilder2 = processBuilder;
        if (processBuilder2 == null) {
            ShellEnvironmentReader.$$$reportNull$$$0(2);
        }
        return processBuilder2;
    }

    private static void setWorkingDir(@Nullable Path file, ProcessBuilder processBuilder) {
        if (file != null) {
            processBuilder.directory(file.getParent().toFile());
        }
    }

    private static String javaExePath() {
        return Path.of(System.getProperty("java.home"), "bin\\java.exe").toString();
    }

    private static String readEnvClasspath() {
        String cp = PathManager.getJarPathForClass(ReadEnv.class);
        if (cp == null) {
            throw new IllegalStateException("Cannot find the '" + ReadEnv.class.getName() + "' class path");
        }
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static @NotNull Pair<@NotNull Map<String, String>, @NotNull String> readEnvironment(@NotNull ProcessBuilder command, long timeoutMillis) throws IOException {
        String log;
        if (command == null) {
            ShellEnvironmentReader.$$$reportNull$$$0(3);
        }
        if (timeoutMillis <= 0L) {
            timeoutMillis = 20000L;
        }
        Path dataFile = Files.createTempFile("ij-shell-env-data.", ".tmp", new FileAttribute[0]);
        Path logFile = Files.createTempFile("ij-shell-env-log.", ".tmp", new FileAttribute[0]);
        List<String> args = command.command();
        boolean substituted = false;
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            if (!arg.contains(OUTPUT_PLACEHOLDER)) continue;
            args.set(i, arg.replace(OUTPUT_PLACEHOLDER, dataFile.toString()));
            substituted = true;
            break;
        }
        if (!substituted) {
            throw new IllegalArgumentException("The output file placeholder is missing: " + String.valueOf(command.command()));
        }
        command.environment().put(INTELLIJ_ENVIRONMENT_READER, "true");
        Process process = command.redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.to(logFile.toFile())).start();
        int exitCode = ShellEnvironmentReader.waitAndTerminateAfter(process, timeoutMillis);
        String envData = Files.readString(dataFile, Charset.defaultCharset());
        String string = log = Files.exists(logFile, new LinkOption[0]) ? Files.readString(logFile, Charset.defaultCharset()) : "(no log file)";
        if (exitCode != 0 || envData.isEmpty()) {
            if (!log.isEmpty()) {
                LOG.info("stdout/stderr: " + log);
            }
            throw new EnvironmentReaderException(String.valueOf(command.command()) + ", " + (String)(exitCode == 0 ? "no data" : "ec=" + exitCode), envData, log);
        }
        Map env2 = EnvironmentUtil.parseEnv((String[])envData.split("\u0000"));
        env2.remove(INTELLIJ_ENVIRONMENT_READER);
        if ("zsh".equals(Path.of(command.command().get(0), new String[0]).getFileName().toString())) {
            env2.remove(DISABLE_OMZ_AUTO_UPDATE);
        }
        LOG.info("shell environment loaded (" + command.command().get(0) + ", " + env2.size() + " vars)");
        Pair pair = new Pair((Object)env2, (Object)log);
        Pair pair2 = pair;
        if (pair2 == null) {
            ShellEnvironmentReader.$$$reportNull$$$0(4);
        }
        return pair2;
        finally {
            ShellEnvironmentReader.deleteTempFile(logFile);
            ShellEnvironmentReader.deleteTempFile(dataFile);
        }
    }

    private static int waitAndTerminateAfter(Process process, long timeoutMillis) {
        Integer exitCode = ShellEnvironmentReader.waitFor(process, timeoutMillis);
        if (exitCode != null) {
            return exitCode;
        }
        LOG.warn("shell env loader is timed out");
        List<ProcessHandle> handles = Stream.concat(Stream.of(process.toHandle()), process.descendants()).toList();
        ListIterator<ProcessHandle> iterator2 = handles.listIterator(handles.size());
        while (iterator2.hasPrevious()) {
            iterator2.previous().destroy();
        }
        exitCode = ShellEnvironmentReader.waitFor(process, 1000L);
        if (exitCode != null) {
            return exitCode;
        }
        LOG.warn("failed to terminate shell env loader process gracefully, terminating forcibly");
        iterator2 = handles.listIterator(handles.size());
        while (iterator2.hasPrevious()) {
            iterator2.previous().destroyForcibly();
        }
        exitCode = ShellEnvironmentReader.waitFor(process, 1000L);
        if (exitCode != null) {
            return exitCode;
        }
        LOG.warn("failed to kill shell env loader");
        return -1;
    }

    @Nullable
    private static Integer waitFor(Process process, long timeoutMillis) {
        try {
            if (process.waitFor(timeoutMillis, TimeUnit.MILLISECONDS)) {
                return process.exitValue();
            }
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted while waiting for process", (Throwable)e);
        }
        return null;
    }

    private static void deleteTempFile(Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            LOG.warn("Cannot delete temporary file", (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ShellEnvironmentReader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "shellCommand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "winShellCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "powerShellCommand";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ShellEnvironmentReader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readEnvironment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }

    private static final class EnvironmentReaderException
    extends IOException
    implements ExceptionWithAttachments {
        private final Attachment[] myAttachments;

        private EnvironmentReaderException(String message, String data, String log) {
            super(message);
            this.myAttachments = new Attachment[]{new Attachment("EnvReaderData.txt", data), new Attachment("EnvReaderLog.txt", log)};
        }

        public Attachment @NotNull [] getAttachments() {
            if (this.myAttachments == null) {
                EnvironmentReaderException.$$$reportNull$$$0(0);
            }
            return this.myAttachments;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ShellEnvironmentReader$EnvironmentReaderException", "getAttachments"));
        }
    }
}

