/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend.hyperlinks;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.filters.HyperlinkInfoBaseKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.backend.hyperlinks.BackendTerminalHyperlinkFacade;
import com.intellij.terminal.backend.hyperlinks.BackendTerminalHyperlinkHighlighter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.hyperlinks.TerminalHyperlinksModel;
import org.jetbrains.plugins.terminal.fus.ReworkedTerminalUsageCollector;
import org.jetbrains.plugins.terminal.hyperlinks.BackendHyperlinkInfo;
import org.jetbrains.plugins.terminal.session.TerminalFilterResultInfo;
import org.jetbrains.plugins.terminal.session.TerminalHyperlinkId;
import org.jetbrains.plugins.terminal.session.TerminalHyperlinksChangedEvent;
import org.jetbrains.plugins.terminal.session.TerminalHyperlinksHeartbeatEvent;
import org.jetbrains.plugins.terminal.session.TerminalHyperlinksModelState;
import org.jetbrains.plugins.terminal.session.dto.TerminalFilterResultInfoDto;
import org.jetbrains.plugins.terminal.session.dto.TerminalHyperlinksDtoKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u000e\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0019J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0086@\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u001dH\u0087@\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/terminal/backend/hyperlinks/BackendTerminalHyperlinkFacade;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "isInAlternateBuffer", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;Z)V", "highlighter", "Lcom/intellij/terminal/backend/hyperlinks/BackendTerminalHyperlinkHighlighter;", "model", "Lorg/jetbrains/plugins/terminal/block/reworked/hyperlinks/TerminalHyperlinksModel;", "heartbeatFlow", "Lkotlinx/coroutines/flow/Flow;", "Lorg/jetbrains/plugins/terminal/session/TerminalHyperlinksHeartbeatEvent;", "getHeartbeatFlow", "()Lkotlinx/coroutines/flow/Flow;", "pendingUpdateEvents", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "collectResultsAndMaybeStartNewTask", "Lorg/jetbrains/plugins/terminal/session/TerminalHyperlinksChangedEvent;", "updateModelState", "event", "hyperlinkClicked", "", "hyperlinkId", "Lorg/jetbrains/plugins/terminal/session/TerminalHyperlinkId;", "mouseEvent", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "(Lorg/jetbrains/plugins/terminal/session/TerminalHyperlinkId;Lcom/intellij/openapi/editor/event/EditorMouseEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getHyperlink", "Lorg/jetbrains/plugins/terminal/hyperlinks/BackendHyperlinkInfo;", "dumpState", "Lorg/jetbrains/plugins/terminal/session/TerminalHyperlinksModelState;", "awaitTaskCompletion", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.terminal.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBackendTerminalHyperlinkFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendTerminalHyperlinkFacade.kt\ncom/intellij/terminal/backend/hyperlinks/BackendTerminalHyperlinkFacade\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n230#2,5:92\n230#2,5:97\n230#2,5:106\n1563#3:102\n1634#3,3:103\n*S KotlinDebug\n*F\n+ 1 BackendTerminalHyperlinkFacade.kt\ncom/intellij/terminal/backend/hyperlinks/BackendTerminalHyperlinkFacade\n*L\n46#1:92,5\n49#1:97,5\n60#1:106,5\n59#1:102\n59#1:103,3\n*E\n"})
public final class BackendTerminalHyperlinkFacade {
    @NotNull
    private final Project project;
    @NotNull
    private final BackendTerminalHyperlinkHighlighter highlighter;
    @NotNull
    private final TerminalHyperlinksModel model;
    @NotNull
    private final MutableStateFlow<Integer> pendingUpdateEvents;

    public BackendTerminalHyperlinkFacade(@NotNull Project project, @NotNull CoroutineScope coroutineScope, @NotNull TerminalOutputModel outputModel, boolean isInAlternateBuffer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        this.project = project;
        this.highlighter = new BackendTerminalHyperlinkHighlighter(this.project, coroutineScope, outputModel, isInAlternateBuffer);
        this.model = new TerminalHyperlinksModel(isInAlternateBuffer ? "Backend AltBuf" : "Backend Output", outputModel);
        this.pendingUpdateEvents = StateFlowKt.MutableStateFlow((Object)0);
    }

    @NotNull
    public final Flow<TerminalHyperlinksHeartbeatEvent> getHeartbeatFlow() {
        return this.highlighter.getHeartbeatFlow();
    }

    @Nullable
    public final TerminalHyperlinksChangedEvent collectResultsAndMaybeStartNewTask() {
        int it;
        Integer nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<Integer> $this$update$iv = this.pendingUpdateEvents;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = ((Number)prevValue$iv).intValue();
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Integer.valueOf(it + 1))));
        TerminalHyperlinksChangedEvent modelUpdateEvent = this.highlighter.collectResultsAndMaybeStartNewTask();
        if (modelUpdateEvent == null) {
            int it2;
            Integer nextValue$iv2;
            Object prevValue$iv2;
            MutableStateFlow<Integer> $this$update$iv2 = this.pendingUpdateEvents;
            boolean $i$f$update2 = false;
            do {
                prevValue$iv2 = $this$update$iv2.getValue();
                it2 = ((Number)prevValue$iv2).intValue();
                boolean bl = false;
            } while (!$this$update$iv2.compareAndSet(prevValue$iv2, (Object)(nextValue$iv2 = Integer.valueOf(it2 - 1))));
        }
        return modelUpdateEvent;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean updateModelState(@NotNull TerminalHyperlinksChangedEvent event) {
        int it;
        Integer nextValue$iv;
        Object prevValue$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Long removedFrom = event.getRemoveFromOffset();
        if (removedFrom != null) {
            this.model.removeHyperlinks(removedFrom);
        }
        Iterable iterable = event.getHyperlinks();
        TerminalHyperlinksModel terminalHyperlinksModel = this.model;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            TerminalFilterResultInfoDto terminalFilterResultInfoDto = (TerminalFilterResultInfoDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TerminalHyperlinksDtoKt.toFilterResultInfo((TerminalFilterResultInfoDto)it2));
        }
        terminalHyperlinksModel.addHyperlinks((List)destination$iv$iv);
        MutableStateFlow<Integer> $this$update$iv = this.pendingUpdateEvents;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = ((Number)prevValue$iv).intValue();
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Integer.valueOf(it - 1))));
        return true;
    }

    @Nullable
    public final Object hyperlinkClicked(@NotNull TerminalHyperlinkId hyperlinkId, @Nullable EditorMouseEvent mouseEvent, @NotNull Continuation<? super Unit> $completion) {
        TerminalFilterResultInfo terminalFilterResultInfo = this.model.getHyperlink(hyperlinkId);
        if (terminalFilterResultInfo == null || (terminalFilterResultInfo = terminalFilterResultInfo.getHyperlinkInfo()) == null) {
            return Unit.INSTANCE;
        }
        TerminalFilterResultInfo hyperlink = terminalFilterResultInfo;
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((HyperlinkInfo)hyperlink, mouseEvent, this, null){
            int label;
            final /* synthetic */ HyperlinkInfo $hyperlink;
            final /* synthetic */ EditorMouseEvent $mouseEvent;
            final /* synthetic */ BackendTerminalHyperlinkFacade this$0;
            {
                this.$hyperlink = $hyperlink;
                this.$mouseEvent = $mouseEvent;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (this.$hyperlink instanceof HyperlinkInfoBase && this.$mouseEvent != null) {
                            HyperlinkInfoBaseKt.navigate((HyperlinkInfo)this.$hyperlink, (Project)BackendTerminalHyperlinkFacade.access$getProject$p(this.this$0), (Editor)this.$mouseEvent.getEditor(), (LogicalPosition)this.$mouseEvent.getLogicalPosition());
                        } else {
                            this.$hyperlink.navigate(BackendTerminalHyperlinkFacade.access$getProject$p(this.this$0));
                        }
                        ReworkedTerminalUsageCollector.INSTANCE.logHyperlinkFollowed(this.$hyperlink.getClass());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final BackendHyperlinkInfo getHyperlink(@NotNull TerminalHyperlinkId hyperlinkId) {
        BackendHyperlinkInfo backendHyperlinkInfo;
        Intrinsics.checkNotNullParameter((Object)hyperlinkId, (String)"hyperlinkId");
        TerminalFilterResultInfo terminalFilterResultInfo = this.model.getHyperlink(hyperlinkId);
        if (terminalFilterResultInfo != null && (terminalFilterResultInfo = terminalFilterResultInfo.getHyperlinkInfo()) != null) {
            TerminalFilterResultInfo hyperlinkInfo = terminalFilterResultInfo;
            boolean bl = false;
            backendHyperlinkInfo = new BackendHyperlinkInfo((HyperlinkInfo)hyperlinkInfo, this.highlighter.getFakeMouseEvent());
        } else {
            backendHyperlinkInfo = null;
        }
        return backendHyperlinkInfo;
    }

    @NotNull
    public final TerminalHyperlinksModelState dumpState() {
        return this.model.dumpState();
    }

    /*
     * Unable to fully structure code
     */
    @TestOnly
    @Nullable
    public final Object awaitTaskCompletion(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof awaitTaskCompletion.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ BackendTerminalHyperlinkFacade this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.awaitTaskCompletion((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.highlighter.awaitTaskCompletion$intellij_terminal_backend((Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                $continuation.label = 2;
                v1 = FlowKt.first((Flow)((Flow)this.pendingUpdateEvents), (Function2)((Function2)new Function2<Integer, Continuation<? super Boolean>, Object>(null){
                    int label;
                    /* synthetic */ int I$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        int n = this.I$0;
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void it;
                                ResultKt.throwOnFailure((Object)$result);
                                return Boxing.boxBoolean((it == false ? 1 : 0) != 0);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.I$0 = ((Number)value).intValue();
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(int p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl28
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl28:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Project access$getProject$p(BackendTerminalHyperlinkFacade $this) {
        return $this.project;
    }
}

