/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import com.jetbrains.cef.SharedMemory;
import java.io.IOException;

class WindowsPipe {
    private static final String WIN32_PIPE_PREFIX = "\\\\.\\pipe\\";
    public static final int ERROR_IO_PENDING;
    public static final int ERROR_NO_DATA;
    public static final int ERROR_PIPE_CONNECTED;
    public static final int FILE_ALL_ACCESS;
    public static final int FILE_FLAG_FIRST_PIPE_INSTANCE;
    public static final int FILE_FLAG_OVERLAPPED;
    public static final int FILE_GENERIC_READ;
    public static final int PIPE_ACCESS_DUPLEX;

    WindowsPipe() {
    }

    static String normalizePipePath(String path) {
        return path.startsWith(WIN32_PIPE_PREFIX) ? path : WIN32_PIPE_PREFIX + path;
    }

    static native String[] findPipes(String var0);

    static native long CreateNamedPipe(String var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7) throws IOException;

    static native long OpenFile(String var0) throws IOException;

    static native int ConnectNamedPipe(long var0, long var2);

    static native boolean DisconnectNamedPipe(long var0);

    static native int read(long var0, long var2, byte[] var4, int var5, int var6) throws IOException;

    static native void write(long var0, long var2, byte[] var4, int var5, int var6) throws IOException;

    static native boolean CloseHandle(long var0);

    static native boolean GetOverlappedResult(long var0, long var2);

    static native long CreateEvent(boolean var0, boolean var1, String var2) throws IOException;

    public static native int GetLastError();

    static native long NewOverlapped(long var0);

    static native boolean FlushFileBuffers(long var0);

    static native void DeleteOverlapped(long var0);

    private static native int ERROR_IO_PENDING();

    private static native int ERROR_NO_DATA();

    private static native int ERROR_PIPE_CONNECTED();

    private static native int FILE_ALL_ACCESS();

    private static native int FILE_FLAG_FIRST_PIPE_INSTANCE();

    private static native int FILE_FLAG_OVERLAPPED();

    private static native int FILE_GENERIC_READ();

    private static native int PIPE_ACCESS_DUPLEX();

    static {
        SharedMemory.loadDynamicLib();
        ERROR_IO_PENDING = WindowsPipe.ERROR_IO_PENDING();
        ERROR_NO_DATA = WindowsPipe.ERROR_NO_DATA();
        ERROR_PIPE_CONNECTED = WindowsPipe.ERROR_PIPE_CONNECTED();
        FILE_ALL_ACCESS = WindowsPipe.FILE_ALL_ACCESS();
        FILE_FLAG_FIRST_PIPE_INSTANCE = WindowsPipe.FILE_FLAG_FIRST_PIPE_INSTANCE();
        FILE_FLAG_OVERLAPPED = WindowsPipe.FILE_FLAG_OVERLAPPED();
        FILE_GENERIC_READ = WindowsPipe.FILE_GENERIC_READ();
        PIPE_ACCESS_DUPLEX = WindowsPipe.PIPE_ACCESS_DUPLEX();
    }
}

