/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api.compute;

import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import libraries.io.DataSizeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0011\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0003H\u0086\u0002J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcirclet/client/api/compute/MemoryAmount;", "", "bytes", "", "<init>", "(J)V", "getBytes", "()J", "toString", "", "toMb", "", "toGb", "compareTo", "other", "minus", "otherBytes", "component1", "copy", "equals", "", "", "hashCode", "spaceport-client-api"})
public final class MemoryAmount
implements Comparable<MemoryAmount> {
    private final long bytes;

    public MemoryAmount(long bytes) {
        this.bytes = bytes;
    }

    public final long getBytes() {
        return this.bytes;
    }

    @NotNull
    public String toString() {
        return DataSizeKt.toDataSize(this.bytes, true);
    }

    public final int toMb() {
        return (int)(this.bytes / (long)0x100000);
    }

    public final int toGb() {
        return this.toMb() / 1024;
    }

    @Override
    public int compareTo(@NotNull MemoryAmount other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ComparisonsKt.compareValues((Comparable)Long.valueOf(this.bytes), (Comparable)Long.valueOf(other.bytes));
    }

    @NotNull
    public final MemoryAmount minus(@NotNull MemoryAmount other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new MemoryAmount(this.bytes - other.bytes);
    }

    @NotNull
    public final MemoryAmount minus(long otherBytes) {
        return new MemoryAmount(this.bytes - otherBytes);
    }

    public final long component1() {
        return this.bytes;
    }

    @NotNull
    public final MemoryAmount copy(long bytes) {
        return new MemoryAmount(bytes);
    }

    public static /* synthetic */ MemoryAmount copy$default(MemoryAmount memoryAmount, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = memoryAmount.bytes;
        }
        return memoryAmount.copy(l);
    }

    public int hashCode() {
        return Long.hashCode(this.bytes);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MemoryAmount)) {
            return false;
        }
        MemoryAmount memoryAmount = (MemoryAmount)other;
        return this.bytes == memoryAmount.bytes;
    }
}

