/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRegexpAwareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RegexpValidationRule;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumValidationRule
extends PerformanceCareRule
implements FUSRegexpAwareRule {
    private final Collection<String> myEnumValues;

    public EnumValidationRule(@Nullable Collection<String> strings) {
        this.myEnumValues = strings == null ? Collections.emptySet() : Collections.unmodifiableCollection(strings);
    }

    @Override
    @NotNull
    public ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        if (this.myEnumValues.isEmpty()) {
            return ValidationResultType.INCORRECT_RULE;
        }
        String escaped = StatisticsEventEscaper.escapeEventIdOrFieldValue(data);
        if (this.myEnumValues.contains(escaped)) {
            return ValidationResultType.ACCEPTED;
        }
        String legacyData = StatisticsEventEscaper.cleanupForLegacyRulesIfNeeded(escaped);
        return legacyData != null && this.myEnumValues.contains(legacyData) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
    }

    @Override
    @NotNull
    public String asRegexp() {
        return this.myEnumValues.stream().map(RegexpValidationRule::escapeText).collect(Collectors.joining("|"));
    }

    public String toString() {
        return "EnumValidationRule: myEnumValues=" + this.asRegexp();
    }
}

