/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard;

import com.intellij.execution.RunContentDescriptorId;
import com.intellij.execution.RunContentDescriptorIdImpl;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardCustomizationBuilder;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationStatus;
import com.intellij.execution.dashboard.RunDashboardService;
import com.intellij.execution.dashboard.RunDashboardServiceId;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.execution.dashboard.BackendRunDashboardManagerState;
import com.intellij.platform.execution.dashboard.BackendRunDashboardUpdatesQueue;
import com.intellij.platform.execution.dashboard.RunDashboardCoroutineScopeProvider;
import com.intellij.platform.execution.dashboard.RunDashboardCustomizationBuilderImpl;
import com.intellij.platform.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.platform.execution.dashboard.splitApi.CustomLinkDto;
import com.intellij.platform.execution.dashboard.splitApi.RunDashboardAdditionalServiceDto;
import com.intellij.platform.execution.dashboard.splitApi.RunDashboardMainServiceDto;
import com.intellij.platform.execution.dashboard.splitApi.RunDashboardServiceDto;
import com.intellij.platform.execution.dashboard.splitApi.RunDashboardSettingsDto;
import com.intellij.platform.execution.dashboard.splitApi.ServiceCustomizationDto;
import com.intellij.platform.execution.dashboard.splitApi.ServiceStatusDto;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 ?2\u00020\u0001:\u0001?B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J/\u0010\u001c\u001a\u00020\u001d2 \u0010\u001e\u001a\u001c\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0 \u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001fj\u0002`!H\u0002\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u0011J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0(J\u0012\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0(J\u001a\u0010*\u001a\u00020\u001d2\u0012\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\n0\nJ\u000e\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020/J\u0014\u00100\u001a\u00020\u001d2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u0012\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170(J\u0018\u00103\u001a\u00020\u001d2\u0006\u00104\u001a\u00020,2\b\u00105\u001a\u0004\u0018\u000106J\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00150(J\u001c\u00108\u001a\u00020\u001d2\u0006\u00104\u001a\u00020,2\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0\nJ\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000e0(J\u001e\u0010<\u001a\u00020\u000e2\u0006\u00104\u001a\u00020,2\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0\nH\u0002J\u0014\u0010=\u001a\u00020\u001d2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u0012\u0010>\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u000f\u001a*\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\n0\u0010j\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\n`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/intellij/platform/execution/dashboard/BackendRunDashboardManagerState;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "sharedSettings", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/platform/execution/dashboard/splitApi/RunDashboardSettingsDto;", "sharedServicesState", "", "Lcom/intellij/platform/execution/dashboard/splitApi/RunDashboardServiceDto;", "sharedServicesCustomizations", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/platform/execution/dashboard/splitApi/ServiceCustomizationDto;", "tagCallbacksByServiceId", "Ljava/util/HashMap;", "Lcom/intellij/execution/dashboard/RunDashboardServiceId;", "Lcom/intellij/platform/execution/dashboard/splitApi/CustomLinkDto;", "Lkotlin/collections/HashMap;", "sharedStatuses", "Lcom/intellij/platform/execution/dashboard/splitApi/ServiceStatusDto;", "sharedConfigurationTypes", "", "", "sharedExcludedTypes", "sharedStateUpdatesQueue", "Lcom/intellij/platform/execution/dashboard/BackendRunDashboardUpdatesQueue;", "scheduleSharedStateUpdate", "", "update", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "Lcom/intellij/platform/execution/dashboard/SequentialComputationRequest;", "(Lkotlin/jvm/functions/Function1;)V", "getLinkByServiceId", "Ljava/lang/Runnable;", "link", "serviceId", "getSettings", "Lkotlinx/coroutines/flow/Flow;", "getServices", "setServices", "value", "Lcom/intellij/execution/dashboard/RunDashboardService;", "setSettings", "openRunningConfigInTab", "", "fireExcludedTypesUpdated", "excludedTypes", "getExcludedTypes", "fireStatusUpdated", "backendService", "persistedStatus", "Lcom/intellij/execution/dashboard/RunDashboardRunConfigurationStatus;", "getStatuses", "fireCustomizationUpdated", "customizers", "Lcom/intellij/execution/dashboard/RunDashboardCustomizer;", "getCustomizations", "createCustomizationDto", "setConfigurationTypes", "getConfigurationTypes", "Companion", "intellij.platform.execution.dashboard"})
@SourceDebugExtension(value={"SMAP\nBackendRunDashboardManagerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendRunDashboardManagerState.kt\ncom/intellij/platform/execution/dashboard/BackendRunDashboardManagerState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n295#2,2:171\n*S KotlinDebug\n*F\n+ 1 BackendRunDashboardManagerState.kt\ncom/intellij/platform/execution/dashboard/BackendRunDashboardManagerState\n*L\n40#1:171,2\n*E\n"})
public final class BackendRunDashboardManagerState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MutableStateFlow<RunDashboardSettingsDto> sharedSettings;
    @NotNull
    private final MutableStateFlow<List<RunDashboardServiceDto>> sharedServicesState;
    @NotNull
    private final MutableSharedFlow<ServiceCustomizationDto> sharedServicesCustomizations;
    @NotNull
    private final HashMap<RunDashboardServiceId, List<CustomLinkDto>> tagCallbacksByServiceId;
    @NotNull
    private final MutableSharedFlow<ServiceStatusDto> sharedStatuses;
    @NotNull
    private final MutableStateFlow<Set<String>> sharedConfigurationTypes;
    @NotNull
    private final MutableStateFlow<Set<String>> sharedExcludedTypes;
    @NotNull
    private final BackendRunDashboardUpdatesQueue sharedStateUpdatesQueue;

    public BackendRunDashboardManagerState(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.sharedSettings = StateFlowKt.MutableStateFlow((Object)new RunDashboardSettingsDto(false, 1, null));
        this.sharedServicesState = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.sharedServicesCustomizations = SharedFlowKt.MutableSharedFlow((int)1, (int)100, (BufferOverflow)BufferOverflow.DROP_OLDEST);
        this.tagCallbacksByServiceId = new HashMap();
        this.sharedStatuses = SharedFlowKt.MutableSharedFlow((int)1, (int)100, (BufferOverflow)BufferOverflow.DROP_OLDEST);
        this.sharedConfigurationTypes = StateFlowKt.MutableStateFlow((Object)SetsKt.emptySet());
        this.sharedExcludedTypes = StateFlowKt.MutableStateFlow((Object)SetsKt.emptySet());
        this.sharedStateUpdatesQueue = new BackendRunDashboardUpdatesQueue(CoroutineScopeKt.childScope$default((CoroutineScope)RunDashboardCoroutineScopeProvider.Companion.getInstance(this.project).getCs(), (String)"Backend run dashboard shared state updates", null, (boolean)false, (int)6, null));
    }

    private final void scheduleSharedStateUpdate(Function1<? super Continuation<? super Unit>, ? extends Object> update) {
        this.sharedStateUpdatesQueue.submit(update);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Runnable getLinkByServiceId(@NotNull String link, @NotNull RunDashboardServiceId serviceId) {
        Object v2;
        Object object;
        block1: {
            Intrinsics.checkNotNullParameter((Object)link, (String)"link");
            Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
            List<CustomLinkDto> list = this.tagCallbacksByServiceId.get(serviceId);
            object = list;
            if (list == null) return null;
            Iterable $this$firstOrNull$iv = (Iterable)object;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CustomLinkDto linkDto = (CustomLinkDto)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)linkDto.getPresentableText(), (Object)link)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        CustomLinkDto customLinkDto = v2;
        object = customLinkDto;
        if (customLinkDto == null) return null;
        Runnable runnable = ((CustomLinkDto)object).getCallback();
        return runnable;
    }

    @NotNull
    public final Flow<RunDashboardSettingsDto> getSettings() {
        return (Flow)FlowKt.asStateFlow(this.sharedSettings);
    }

    @NotNull
    public final Flow<List<RunDashboardServiceDto>> getServices() {
        return (Flow)FlowKt.asStateFlow(this.sharedServicesState);
    }

    public final void setServices(@NotNull List<? extends List<? extends RunDashboardService>> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.scheduleSharedStateUpdate((Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(value, this, null){
            int label;
            final /* synthetic */ List<List<RunDashboardService>> $value;
            final /* synthetic */ BackendRunDashboardManagerState this$0;
            {
                this.$value = $value;
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        List flattenServices = CollectionsKt.flatten((Iterable)this.$value);
                        Iterable iterable = flattenServices;
                        MutableStateFlow mutableStateFlow = BackendRunDashboardManagerState.access$getSharedServicesState$p(this.this$0);
                        boolean $i$f$map = false;
                        void var5_6 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void backendServiceModel;
                            RunDashboardService runDashboardService = (RunDashboardService)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(BackendRunDashboardManagerState.Companion.createServiceDto((RunDashboardService)backendServiceModel));
                        }
                        mutableStateFlow.setValue((Object)((List)destination$iv$iv));
                        Set effectiveServicesSet = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)flattenServices), setServices.1::invokeSuspend$lambda$1));
                        BackendRunDashboardManagerState.access$getTagCallbacksByServiceId$p(this.this$0).keySet().retainAll(effectiveServicesSet);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }

            private static final RunDashboardServiceId invokeSuspend$lambda$1(RunDashboardService it) {
                return it.getUuid();
            }
        }));
    }

    public final void setSettings(boolean openRunningConfigInTab) {
        this.scheduleSharedStateUpdate((Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, openRunningConfigInTab, null){
            int label;
            final /* synthetic */ BackendRunDashboardManagerState this$0;
            final /* synthetic */ boolean $openRunningConfigInTab;
            {
                this.this$0 = $receiver;
                this.$openRunningConfigInTab = $openRunningConfigInTab;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        BackendRunDashboardManagerState.access$getSharedSettings$p(this.this$0).setValue((Object)new RunDashboardSettingsDto(this.$openRunningConfigInTab));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public final void fireExcludedTypesUpdated(@NotNull Set<String> excludedTypes) {
        Intrinsics.checkNotNullParameter(excludedTypes, (String)"excludedTypes");
        this.scheduleSharedStateUpdate((Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, excludedTypes, null){
            int label;
            final /* synthetic */ BackendRunDashboardManagerState this$0;
            final /* synthetic */ Set<String> $excludedTypes;
            {
                this.this$0 = $receiver;
                this.$excludedTypes = $excludedTypes;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        BackendRunDashboardManagerState.access$getSharedExcludedTypes$p(this.this$0).setValue(this.$excludedTypes);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public final Flow<Set<String>> getExcludedTypes() {
        return (Flow)FlowKt.asStateFlow(this.sharedExcludedTypes);
    }

    public final void fireStatusUpdated(@NotNull RunDashboardService backendService, @Nullable RunDashboardRunConfigurationStatus persistedStatus) {
        Intrinsics.checkNotNullParameter((Object)backendService, (String)"backendService");
        this.scheduleSharedStateUpdate((Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(backendService, persistedStatus, this, null){
            int label;
            final /* synthetic */ RunDashboardService $backendService;
            final /* synthetic */ RunDashboardRunConfigurationStatus $persistedStatus;
            final /* synthetic */ BackendRunDashboardManagerState this$0;
            {
                this.$backendService = $backendService;
                this.$persistedStatus = $persistedStatus;
                this.this$0 = $receiver;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        RunDashboardRunConfigurationStatus runDashboardRunConfigurationStatus;
                        ResultKt.throwOnFailure((Object)$result);
                        if (this.$backendService.getDescriptor() == null && this.$persistedStatus != null) {
                            runDashboardRunConfigurationStatus = this.$persistedStatus;
                        } else {
                            RunDashboardRunConfigurationStatus runDashboardRunConfigurationStatus2 = RunDashboardRunConfigurationStatus.getStatus((RunContentDescriptor)this.$backendService.getDescriptor());
                            runDashboardRunConfigurationStatus = runDashboardRunConfigurationStatus2;
                            Intrinsics.checkNotNullExpressionValue((Object)runDashboardRunConfigurationStatus2, (String)"getStatus(...)");
                        }
                        RunDashboardRunConfigurationStatus effectiveStatus = runDashboardRunConfigurationStatus;
                        MutableSharedFlow mutableSharedFlow = BackendRunDashboardManagerState.access$getSharedStatuses$p(this.this$0);
                        RunDashboardServiceId runDashboardServiceId = this.$backendService.getUuid();
                        Intrinsics.checkNotNullExpressionValue((Object)runDashboardServiceId, (String)"getUuid(...)");
                        String string = effectiveStatus.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        mutableSharedFlow.tryEmit((Object)new ServiceStatusDto(runDashboardServiceId, string));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public final Flow<ServiceStatusDto> getStatuses() {
        return (Flow)FlowKt.asSharedFlow(this.sharedStatuses);
    }

    public final void fireCustomizationUpdated(@NotNull RunDashboardService backendService, @NotNull List<? extends RunDashboardCustomizer> customizers) {
        Intrinsics.checkNotNullParameter((Object)backendService, (String)"backendService");
        Intrinsics.checkNotNullParameter(customizers, (String)"customizers");
        this.scheduleSharedStateUpdate((Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, backendService, customizers, null){
            int label;
            final /* synthetic */ BackendRunDashboardManagerState this$0;
            final /* synthetic */ RunDashboardService $backendService;
            final /* synthetic */ List<RunDashboardCustomizer> $customizers;
            {
                this.this$0 = $receiver;
                this.$backendService = $backendService;
                this.$customizers = $customizers;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ServiceCustomizationDto value = BackendRunDashboardManagerState.access$createCustomizationDto(this.this$0, this.$backendService, this.$customizers);
                        ((Map)BackendRunDashboardManagerState.access$getTagCallbacksByServiceId$p(this.this$0)).put(this.$backendService.getUuid(), value.getLinks());
                        BackendRunDashboardManagerState.access$getSharedServicesCustomizations$p(this.this$0).tryEmit((Object)value);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public final Flow<ServiceCustomizationDto> getCustomizations() {
        return (Flow)FlowKt.asSharedFlow(this.sharedServicesCustomizations);
    }

    private final ServiceCustomizationDto createCustomizationDto(RunDashboardService backendService, List<? extends RunDashboardCustomizer> customizers) {
        RunDashboardCustomizationBuilderImpl customizationBuilder = new RunDashboardCustomizationBuilderImpl();
        for (RunDashboardCustomizer runDashboardCustomizer : customizers) {
            if (runDashboardCustomizer.updatePresentation((RunDashboardCustomizationBuilder)customizationBuilder, backendService.getConfigurationSettings(), backendService.getDescriptor())) break;
        }
        RunDashboardServiceId runDashboardServiceId = backendService.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)runDashboardServiceId, (String)"getUuid(...)");
        return customizationBuilder.buildDto$intellij_platform_execution_dashboard(runDashboardServiceId);
    }

    public final void setConfigurationTypes(@NotNull Set<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.scheduleSharedStateUpdate((Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, value, null){
            int label;
            final /* synthetic */ BackendRunDashboardManagerState this$0;
            final /* synthetic */ Set<String> $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        BackendRunDashboardManagerState.access$getSharedConfigurationTypes$p(this.this$0).setValue(this.$value);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public final Flow<Set<String>> getConfigurationTypes() {
        return (Flow)FlowKt.asStateFlow(this.sharedConfigurationTypes);
    }

    @JvmStatic
    @NotNull
    public static final RunDashboardServiceDto createServiceDto(@NotNull RunDashboardService backendServiceModel) {
        return Companion.createServiceDto(backendServiceModel);
    }

    public static final /* synthetic */ MutableStateFlow access$getSharedServicesState$p(BackendRunDashboardManagerState $this) {
        return $this.sharedServicesState;
    }

    public static final /* synthetic */ HashMap access$getTagCallbacksByServiceId$p(BackendRunDashboardManagerState $this) {
        return $this.tagCallbacksByServiceId;
    }

    public static final /* synthetic */ MutableStateFlow access$getSharedSettings$p(BackendRunDashboardManagerState $this) {
        return $this.sharedSettings;
    }

    public static final /* synthetic */ MutableStateFlow access$getSharedExcludedTypes$p(BackendRunDashboardManagerState $this) {
        return $this.sharedExcludedTypes;
    }

    public static final /* synthetic */ MutableSharedFlow access$getSharedStatuses$p(BackendRunDashboardManagerState $this) {
        return $this.sharedStatuses;
    }

    public static final /* synthetic */ ServiceCustomizationDto access$createCustomizationDto(BackendRunDashboardManagerState $this, RunDashboardService backendService, List customizers) {
        return $this.createCustomizationDto(backendService, customizers);
    }

    public static final /* synthetic */ MutableSharedFlow access$getSharedServicesCustomizations$p(BackendRunDashboardManagerState $this) {
        return $this.sharedServicesCustomizations;
    }

    public static final /* synthetic */ MutableStateFlow access$getSharedConfigurationTypes$p(BackendRunDashboardManagerState $this) {
        return $this.sharedConfigurationTypes;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/execution/dashboard/BackendRunDashboardManagerState$Companion;", "", "<init>", "()V", "createServiceDto", "Lcom/intellij/platform/execution/dashboard/splitApi/RunDashboardServiceDto;", "backendServiceModel", "Lcom/intellij/execution/dashboard/RunDashboardService;", "intellij.platform.execution.dashboard"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RunDashboardServiceDto createServiceDto(@NotNull RunDashboardService backendServiceModel) {
            RunContentDescriptorIdImpl contentIdImpl;
            Intrinsics.checkNotNullParameter((Object)backendServiceModel, (String)"backendServiceModel");
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = backendServiceModel.getConfigurationSettings();
            Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"getConfigurationSettings(...)");
            RunnerAndConfigurationSettings settings = runnerAndConfigurationSettings;
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            RunConfiguration configuration = runConfiguration;
            Project project = configuration.getProject();
            RunContentDescriptor runContentDescriptor = backendServiceModel.getDescriptor();
            RunContentDescriptorId runContentDescriptorId = runContentDescriptor != null ? runContentDescriptor.getId() : null;
            RunContentDescriptorIdImpl runContentDescriptorIdImpl = contentIdImpl = runContentDescriptorId instanceof RunContentDescriptorIdImpl ? (RunContentDescriptorIdImpl)runContentDescriptorId : null;
            if (backendServiceModel instanceof RunDashboardManagerImpl.RunDashboardServiceImpl) {
                RunDashboardServiceId runDashboardServiceId = ((RunDashboardManagerImpl.RunDashboardServiceImpl)backendServiceModel).getUuid();
                Intrinsics.checkNotNullExpressionValue((Object)runDashboardServiceId, (String)"getUuid(...)");
                String string = configuration.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                Icon icon = RunManagerEx.getInstanceEx((Project)project).getConfigurationIcon(settings);
                Object object = icon != null ? IconIdKt.rpcId((Icon)icon) : null;
                String string2 = configuration.getType().getId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
                String string3 = configuration.getType().getDisplayName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDisplayName(...)");
                Icon icon2 = configuration.getType().getIcon();
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getIcon(...)");
                IconId iconId = IconIdKt.rpcId((Icon)icon2);
                String string4 = settings.getFolderName();
                Intrinsics.checkNotNull((Object)project);
                boolean bl = RunManager.Companion.getInstance(project).hasSettings(settings);
                String string5 = ((RunDashboardManagerImpl.RunDashboardServiceImpl)backendServiceModel).getServiceViewId();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getServiceViewId(...)");
                return new RunDashboardMainServiceDto(runDashboardServiceId, string, (IconId)object, string2, string3, iconId, string4, contentIdImpl, bl, string5, RunManager.Companion.getInstance(project).hasSettings(settings), settings.isActivateToolWindowBeforeRun(), settings.isFocusToolWindowBeforeRun());
            }
            RunDashboardServiceId runDashboardServiceId = backendServiceModel.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)runDashboardServiceId, (String)"getUuid(...)");
            String string = configuration.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Icon icon = RunManagerEx.getInstanceEx((Project)project).getConfigurationIcon(settings);
            Object object = icon != null ? IconIdKt.rpcId((Icon)icon) : null;
            String string6 = configuration.getType().getId();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getId(...)");
            String string7 = configuration.getType().getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getDisplayName(...)");
            Icon icon3 = configuration.getType().getIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"getIcon(...)");
            IconId iconId = IconIdKt.rpcId((Icon)icon3);
            String string8 = settings.getFolderName();
            Intrinsics.checkNotNull((Object)project);
            boolean bl = RunManager.Companion.getInstance(project).hasSettings(settings);
            String string9 = backendServiceModel.getServiceViewId();
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getServiceViewId(...)");
            return new RunDashboardAdditionalServiceDto(runDashboardServiceId, string, (IconId)object, string6, string7, iconId, string8, contentIdImpl, bl, string9, RunManager.Companion.getInstance(project).hasSettings(settings), settings.isActivateToolWindowBeforeRun(), settings.isFocusToolWindowBeforeRun());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

