/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView.backend;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardManagerProxy;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.ide.vfs.VirtualFileId;
import com.intellij.ide.vfs.VirtualFileIdKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.execution.serviceView.ServiceViewImplementationChooserKt;
import com.intellij.platform.execution.serviceView.backend.ServiceViewLocatableSearcher;
import com.intellij.platform.execution.serviceView.splitApi.ServiceViewConfigurationType;
import com.intellij.platform.execution.serviceView.splitApi.ServiceViewConfigurationTypeSettings;
import com.intellij.platform.execution.serviceView.splitApi.ServiceViewRpc;
import com.intellij.platform.project.ProjectId;
import com.intellij.platform.project.ProjectIdKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000eJ(\u0010\u000f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00050\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/execution/serviceView/backend/ServiceViewRpcImpl;", "Lcom/intellij/platform/execution/serviceView/splitApi/ServiceViewRpc;", "<init>", "()V", "findServices", "", "", "fileId", "Lcom/intellij/ide/vfs/VirtualFileId;", "projectId", "Lcom/intellij/platform/project/ProjectId;", "(Lcom/intellij/ide/vfs/VirtualFileId;Lcom/intellij/platform/project/ProjectId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadConfigurationTypes", "Lcom/intellij/platform/execution/serviceView/splitApi/ServiceViewConfigurationTypeSettings;", "(Lcom/intellij/platform/project/ProjectId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "collectTypes", "Lkotlin/Pair;", "Lcom/intellij/execution/configurations/ConfigurationType;", "project", "Lcom/intellij/openapi/project/Project;", "saveConfigurationTypes", "", "includedTypes", "", "(Lcom/intellij/platform/project/ProjectId;Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "changeServiceViewImplementationForNextIdeRunAndRestart", "shouldEnableSplitImplementation", "", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.platform.execution.serviceView.backend"})
@SourceDebugExtension(value={"SMAP\nServiceViewRpcImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceViewRpcImpl.kt\ncom/intellij/platform/execution/serviceView/backend/ServiceViewRpcImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1563#2:74\n1634#2,3:75\n1563#2:78\n1634#2,3:79\n*S KotlinDebug\n*F\n+ 1 ServiceViewRpcImpl.kt\ncom/intellij/platform/execution/serviceView/backend/ServiceViewRpcImpl\n*L\n44#1:74\n44#1:75,3\n45#1:78\n45#1:79,3\n*E\n"})
public final class ServiceViewRpcImpl
implements ServiceViewRpc {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ExtensionPointName<ServiceViewLocatableSearcher> EP_NAME = ExtensionPointName.Companion.create("com.intellij.serviceViewLocatableSearcher");

    @Nullable
    public Object findServices(@NotNull VirtualFileId fileId, @NotNull ProjectId projectId, @NotNull Continuation<? super List<String>> $completion) {
        VirtualFile virtualFile = VirtualFileIdKt.virtualFile((VirtualFileId)fileId);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project = ProjectIdKt.findProjectOrNull((ProjectId)projectId);
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        return CoroutinesKt.readAction(() -> ServiceViewRpcImpl.findServices$lambda$0(project2, virtualFile2), $completion);
    }

    @Nullable
    public Object loadConfigurationTypes(@NotNull ProjectId projectId, @NotNull Continuation<? super ServiceViewConfigurationTypeSettings> $completion) {
        ConfigurationType it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Project project = ProjectIdKt.findProjectOrNull((ProjectId)projectId);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Pair<List<ConfigurationType>, List<ConfigurationType>> configuredTypes = this.collectTypes(project2);
        Iterable $this$map$iv = (Iterable)configuredTypes.getFirst();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ConfigurationType configurationType = (ConfigurationType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            String string2 = it.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
            Icon icon = it.getIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
            collection.add(new ServiceViewConfigurationType(string, string2, IconIdKt.rpcId((Icon)icon)));
        }
        $this$map$iv = (Iterable)configuredTypes.getSecond();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ConfigurationType)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String string = it.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            String string3 = it.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDisplayName(...)");
            Icon icon = it.getIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
            collection2.add(new ServiceViewConfigurationType(string, string3, IconIdKt.rpcId((Icon)icon)));
        }
        List list = (List)destination$iv$iv;
        Collection collection3 = collection;
        return new ServiceViewConfigurationTypeSettings((List)collection3, list);
    }

    private final Pair<List<ConfigurationType>, List<ConfigurationType>> collectTypes(Project project) {
        ArrayList<ConfigurationType> includedTypes = new ArrayList<ConfigurationType>();
        ArrayList<ConfigurationType> excludedTypes = new ArrayList<ConfigurationType>();
        Set set = RunDashboardManagerProxy.Companion.getInstance(project).getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTypes(...)");
        Set types = set;
        for (ConfigurationType type : ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList()) {
            boolean bl = types.contains(type.getId()) ? includedTypes.add(type) : excludedTypes.add(type);
        }
        return new Pair(includedTypes, excludedTypes);
    }

    @Nullable
    public Object saveConfigurationTypes(@NotNull ProjectId projectId, @NotNull Set<String> includedTypes, @NotNull Continuation<? super Unit> $completion) {
        Project project = ProjectIdKt.findProjectOrNull((ProjectId)projectId);
        if (project == null) {
            return Unit.INSTANCE;
        }
        Project project2 = project;
        RunDashboardManagerProxy.Companion.getInstance(project2).setTypes(includedTypes);
        return Unit.INSTANCE;
    }

    @Nullable
    public Object changeServiceViewImplementationForNextIdeRunAndRestart(boolean shouldEnableSplitImplementation, @NotNull Continuation<? super Unit> $completion) {
        ServiceViewImplementationChooserKt.setServiceViewImplementationForNextIdeRun((boolean)shouldEnableSplitImplementation);
        ApplicationManagerEx.getApplicationEx().restart(true);
        return Unit.INSTANCE;
    }

    private static final List findServices$lambda$0(Project $project, VirtualFile $virtualFile) {
        Set result = new LinkedHashSet();
        for (ServiceViewLocatableSearcher searcher : (ServiceViewLocatableSearcher[])EP_NAME.getExtensions()) {
            result.addAll((Collection)searcher.find($project, $virtualFile));
        }
        return CollectionsKt.toList((Iterable)result);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/execution/serviceView/backend/ServiceViewRpcImpl$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/platform/execution/serviceView/backend/ServiceViewLocatableSearcher;", "intellij.platform.execution.serviceView.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

