/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spaceport.gateway.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.icons.HiDPIImage;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/spaceport/gateway/ui/ImageLoader;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "loadImage", "Ljava/awt/Image;", "path", "", "width", "", "height", "intellij.spaceport.gateway"})
@SourceDebugExtension(value={"SMAP\npromo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 promo.kt\ncom/intellij/spaceport/gateway/ui/ImageLoader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,158:1\n13#2:159\n*S KotlinDebug\n*F\n+ 1 promo.kt\ncom/intellij/spaceport/gateway/ui/ImageLoader\n*L\n129#1:159\n*E\n"})
final class ImageLoader {
    @NotNull
    public static final ImageLoader INSTANCE = new ImageLoader();
    @NotNull
    private static final Logger LOG;

    private ImageLoader() {
    }

    @Nullable
    public final Image loadImage(@NotNull String path, int width, int height) {
        Image image;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResourceAsStream(path));
            Intrinsics.checkNotNull((Object)img);
            image = (Image)new HiDPIImage((Image)img, width, height, img.getType());
        }
        catch (Exception e) {
            LOG.error("Image " + path + " is not loaded");
            image = null;
        }
        return image;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ImageLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

