/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.PrimitivesExKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.date.DateFormat;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0004j\u0002`\u0003\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00060\u0004j\u0002`\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0015\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ.\u0010\u0016\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0004j\u0002`\u00032\u0010\b\u0002\u0010\u0005\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u001b\u0010\u0005\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\tR\u0013\u0010\f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001c"}, d2={"Lcirclet/common/calendar/DatesInterval;", "", "start", "Lcirclet/platform/api/ADate;", "Lcirclet/platform/api/KotlinXDate;", "endExclusive", "<init>", "(Lcirclet/platform/api/KotlinXDate;Lcirclet/platform/api/KotlinXDate;)V", "getStart", "()Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/KotlinXDate;", "getEndExclusive", "endInclusive", "getEndInclusive", "contains", "", "date", "(Lcirclet/platform/api/KotlinXDate;)Z", "toString", "", "component1", "component2", "copy", "(Lcirclet/platform/api/KotlinXDate;Lcirclet/platform/api/KotlinXDate;)Lcirclet/common/calendar/DatesInterval;", "equals", "other", "hashCode", "", "spaceport-common"})
public final class DatesInterval {
    @NotNull
    private final KotlinXDate start;
    @Nullable
    private final KotlinXDate endExclusive;
    @Nullable
    private final KotlinXDate endInclusive;

    public DatesInterval(@NotNull KotlinXDate start2, @Nullable KotlinXDate endExclusive) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        this.start = start2;
        KotlinXDate kotlinXDate = this.endExclusive = endExclusive;
        this.endInclusive = kotlinXDate != null ? ADateJvmKt.plusDays(kotlinXDate, -1) : null;
        if (!(this.endExclusive == null || this.start.compareTo(this.endExclusive) < 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ DatesInterval(KotlinXDate kotlinXDate, KotlinXDate kotlinXDate2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kotlinXDate2 = null;
        }
        this(kotlinXDate, kotlinXDate2);
    }

    @NotNull
    public final KotlinXDate getStart() {
        return this.start;
    }

    @Nullable
    public final KotlinXDate getEndExclusive() {
        return this.endExclusive;
    }

    @Nullable
    public final KotlinXDate getEndInclusive() {
        return this.endInclusive;
    }

    public final boolean contains(@NotNull KotlinXDate date2) {
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        return this.start.compareTo(date2) <= 0 && (this.endExclusive == null || date2.compareTo(this.endExclusive) < 0);
    }

    @NotNull
    public String toString() {
        KotlinXDate kotlinXDate = this.endExclusive;
        return PrimitivesExKt.format(this.start, DateFormat.DAY_MONTH_AND_YEAR) + " - " + (kotlinXDate != null ? PrimitivesExKt.format(kotlinXDate, DateFormat.DAY_MONTH_AND_YEAR) : null);
    }

    @NotNull
    public final KotlinXDate component1() {
        return this.start;
    }

    @Nullable
    public final KotlinXDate component2() {
        return this.endExclusive;
    }

    @NotNull
    public final DatesInterval copy(@NotNull KotlinXDate start2, @Nullable KotlinXDate endExclusive) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        return new DatesInterval(start2, endExclusive);
    }

    public static /* synthetic */ DatesInterval copy$default(DatesInterval datesInterval, KotlinXDate kotlinXDate, KotlinXDate kotlinXDate2, int n, Object object) {
        if ((n & 1) != 0) {
            kotlinXDate = datesInterval.start;
        }
        if ((n & 2) != 0) {
            kotlinXDate2 = datesInterval.endExclusive;
        }
        return datesInterval.copy(kotlinXDate, kotlinXDate2);
    }

    public int hashCode() {
        int result2 = this.start.hashCode();
        result2 = result2 * 31 + (this.endExclusive == null ? 0 : this.endExclusive.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DatesInterval)) {
            return false;
        }
        DatesInterval datesInterval = (DatesInterval)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)datesInterval.start)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.endExclusive, (Object)datesInterval.endExclusive);
    }
}

