/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.Maybe;
import runtime.reactive.Signal;
import runtime.reactive.Source;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u000fJ\u0013\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J$\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000f0\u0017H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lruntime/reactive/ValueSource;", "T", "Lruntime/reactive/Source;", "<init>", "()V", "broadcastSignal", "Lruntime/reactive/Signal;", "value", "Lruntime/reactive/Maybe;", "maybeValue", "getMaybeValue", "()Lruntime/reactive/Maybe;", "setMaybeValue", "(Lruntime/reactive/Maybe;)V", "notifyIfValue", "", "clearValue", "setValue", "(Ljava/lang/Object;)V", "forEach", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "sink", "Lkotlin/Function1;", "platform-runtime"})
public final class ValueSource<T>
implements Source<T> {
    @NotNull
    private final Signal<T> broadcastSignal = Signal.Companion.create();
    @NotNull
    private Maybe<? extends T> maybeValue = Maybe.None.INSTANCE;

    @NotNull
    public final Maybe<T> getMaybeValue() {
        return this.maybeValue;
    }

    private final void setMaybeValue(Maybe<? extends T> value2) {
        this.maybeValue = value2;
        this.notifyIfValue();
    }

    private final void notifyIfValue() {
        Maybe<? extends T> maybe = this.maybeValue;
        Maybe.Just just2 = maybe instanceof Maybe.Just ? (Maybe.Just)maybe : null;
        if (just2 == null) {
            return;
        }
        Maybe.Just justValue = just2;
        this.broadcastSignal.fire(justValue.getValue());
    }

    public final void clearValue() {
        this.setMaybeValue(Maybe.None.INSTANCE);
    }

    public final void setValue(T value2) {
        this.setMaybeValue((Maybe)new Maybe.Just<T>(value2));
    }

    @Override
    public void forEach(@NotNull Lifetime lifetime, @NotNull Function1<? super T, Unit> sink) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(sink, (String)"sink");
        this.broadcastSignal.forEach(lifetime, sink);
        Maybe<? extends T> maybe = this.maybeValue;
        if (maybe instanceof Maybe.Just) {
            sink.invoke(((Maybe.Just)maybe).getValue());
        }
    }

    @Override
    public void forEachWithPrevious(@NotNull Lifetime lifetime, @NotNull Function2<? super T, ? super T, Unit> consume) {
        Source.DefaultImpls.forEachWithPrevious(this, lifetime, consume);
    }
}

