/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.connection;

import com.jetbrains.fus.reporting.connection.JavaHttpRequestBuilder;
import com.jetbrains.fus.reporting.model.exceptions.StatsResponseException;
import com.jetbrains.fus.reporting.model.http.HttpClient;
import com.jetbrains.fus.reporting.model.http.HttpRequest;
import com.jetbrains.fus.reporting.model.http.HttpResponse;
import com.jetbrains.fus.reporting.model.http.Method;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/fus/reporting/connection/JavaHttpClient;", "Lcom/jetbrains/fus/reporting/model/http/HttpClient;", "builder", "Ljava/net/http/HttpClient$Builder;", "(Ljava/net/http/HttpClient$Builder;)V", "getBuilder", "()Ljava/net/http/HttpClient$Builder;", "send", "Lcom/jetbrains/fus/reporting/model/http/HttpResponse;", "httpRequest", "Lcom/jetbrains/fus/reporting/model/http/HttpRequest;", "connection-client"})
public final class JavaHttpClient
implements HttpClient {
    @NotNull
    private final HttpClient.Builder builder;

    public JavaHttpClient(@NotNull HttpClient.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.builder = builder;
    }

    @NotNull
    public final HttpClient.Builder getBuilder() {
        return this.builder;
    }

    @Override
    @NotNull
    public HttpResponse send(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        if (httpRequest.getMethod() == Method.GET) {
            java.net.http.HttpClient javaHttpClient = this.builder.build();
            java.net.http.HttpRequest javaHttpRequest = JavaHttpRequestBuilder.Companion.newJavaGetHttpRequest(httpRequest);
            java.net.http.HttpResponse<String> javaHttpResponse = javaHttpClient.send(javaHttpRequest, HttpResponse.BodyHandlers.ofString());
            HttpResponse httpResponse2 = new HttpResponse(javaHttpResponse){
                private final int statusCode;
                @Nullable
                private final String body;
                {
                    this.statusCode = $javaHttpResponse.statusCode();
                    this.body = $javaHttpResponse.body();
                }

                public int getStatusCode() {
                    return this.statusCode;
                }

                @Nullable
                public String getBody() {
                    return this.body;
                }
            };
            return httpResponse2;
        }
        throw new StatsResponseException("Unsupported http method: " + httpRequest.getMethod() + ". Only GET method is supported. Url: " + httpRequest.getUrl());
    }
}

