/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtils;
import com.intellij.idea.AppMode;
import com.intellij.internal.statistic.eventLog.EmptyStatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.PlatformUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\tJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000e\u001a\u00020\tJ\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0002J\u001a\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\f0\bH\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\nH\u0002R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\f0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogProvidersHolder;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "eventLoggerProviders", "Ljava/util/concurrent/atomic/AtomicReference;", "", "", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "eventLoggerProvidersExt", "", "getEventLogProvider", "recorderId", "getEventLogProviders", "getEventLogProvidersExt", "calculateEventLogProvider", "calculateEventLogProviderExt", "getAllEventLogProviders", "Lkotlin/sequences/Sequence;", "isJetBrainsProduct", "", "isProviderApplicable", "extension", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nStatisticsEventLogProvidersHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsEventLogProvidersHolder.kt\ncom/intellij/internal/statistic/eventLog/StatisticsEventLogProvidersHolder\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,87:1\n463#2:88\n413#2:89\n382#2,7:98\n1252#3,2:90\n1255#3:93\n1#4:92\n996#5:94\n1025#5,3:95\n1028#5,3:105\n*S KotlinDebug\n*F\n+ 1 StatisticsEventLogProvidersHolder.kt\ncom/intellij/internal/statistic/eventLog/StatisticsEventLogProvidersHolder\n*L\n44#1:88\n44#1:89\n55#1:98,7\n44#1:90,2\n44#1:93\n55#1:94\n55#1:95,3\n55#1:105,3\n*E\n"})
public final class StatisticsEventLogProvidersHolder {
    @NotNull
    private final AtomicReference<Map<String, StatisticsEventLoggerProvider>> eventLoggerProviders;
    @NotNull
    private final AtomicReference<Map<String, Collection<StatisticsEventLoggerProvider>>> eventLoggerProvidersExt;

    public StatisticsEventLogProvidersHolder(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.eventLoggerProviders = new AtomicReference<Map<String, StatisticsEventLoggerProvider>>(this.calculateEventLogProvider());
        this.eventLoggerProvidersExt = new AtomicReference<Map<String, Collection<StatisticsEventLoggerProvider>>>(this.calculateEventLogProviderExt());
        if (ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(StatisticsEventLoggerProvider.Companion.getEP_NAME())) {
            StatisticsEventLoggerProvider.Companion.getEP_NAME().addChangeListener(coroutineScope, () -> StatisticsEventLogProvidersHolder._init_$lambda$0(this));
            StatisticsEventLoggerProvider.Companion.getEP_NAME().addChangeListener(coroutineScope, () -> StatisticsEventLogProvidersHolder._init_$lambda$1(this));
        }
    }

    @NotNull
    public final StatisticsEventLoggerProvider getEventLogProvider(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        StatisticsEventLoggerProvider statisticsEventLoggerProvider = this.eventLoggerProviders.get().get(recorderId);
        if (statisticsEventLoggerProvider == null) {
            statisticsEventLoggerProvider = new EmptyStatisticsEventLoggerProvider(recorderId);
        }
        return statisticsEventLoggerProvider;
    }

    @NotNull
    public final Collection<StatisticsEventLoggerProvider> getEventLogProviders() {
        return this.eventLoggerProviders.get().values();
    }

    @NotNull
    public final Collection<StatisticsEventLoggerProvider> getEventLogProvidersExt(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Collection collection = this.eventLoggerProvidersExt.get().get(recorderId);
        if (collection == null) {
            collection = CollectionsKt.listOf((Object)new EmptyStatisticsEventLoggerProvider(recorderId));
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, StatisticsEventLoggerProvider> calculateEventLogProvider() {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map<String, Collection<StatisticsEventLoggerProvider>> $this$mapValues$iv = this.calculateEventLogProviderExt();
        boolean $i$f$mapValues = false;
        Map<String, Collection<StatisticsEventLoggerProvider>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            StatisticsEventLoggerProvider statisticsEventLoggerProvider;
            Object v2;
            void it;
            Map map2;
            Object k;
            block7: {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map2 = map3;
                boolean bl2 = false;
                Iterable iterable2 = (Iterable)it.getValue();
                for (Object t : iterable2) {
                    boolean bl3;
                    StatisticsEventLoggerProvider provider = (StatisticsEventLoggerProvider)t;
                    boolean bl4 = false;
                    if (PluginManagerCore.isRunningFromSources() || AppMode.isRunningFromDevBuild()) {
                        bl3 = true;
                    } else {
                        String string = provider.getClass().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        PluginDescriptor pluginDescriptor = PluginUtils.getPluginDescriptorOrPlatformByClassName((String)string);
                        if (pluginDescriptor != null) {
                            PluginDescriptor plugin = pluginDescriptor;
                            boolean bl5 = false;
                            bl3 = PluginManagerCore.isDevelopedExclusivelyByJetBrains((PluginDescriptor)plugin);
                        } else {
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    v2 = t;
                    break block7;
                }
                v2 = null;
            }
            if ((statisticsEventLoggerProvider = (StatisticsEventLoggerProvider)v2) == null) {
                statisticsEventLoggerProvider = new EmptyStatisticsEventLoggerProvider((String)it.getKey());
            }
            StatisticsEventLoggerProvider statisticsEventLoggerProvider2 = statisticsEventLoggerProvider;
            map2.put(k, statisticsEventLoggerProvider2);
        }
        return destination$iv$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Collection<StatisticsEventLoggerProvider>> calculateEventLogProviderExt() {
        void $this$groupByTo$iv$iv;
        Sequence<StatisticsEventLoggerProvider> $this$groupBy$iv = this.getAllEventLogProviders();
        boolean $i$f$groupBy = false;
        Sequence<StatisticsEventLoggerProvider> sequence = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            StatisticsEventLoggerProvider it = (StatisticsEventLoggerProvider)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getRecorderId();
            Map map = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    private final Sequence<StatisticsEventLoggerProvider> getAllEventLogProviders() {
        List providers = StatisticsEventLoggerProvider.Companion.getEP_NAME().getExtensionsIfPointIsRegistered();
        if (providers.isEmpty()) {
            return SequencesKt.emptySequence();
        }
        boolean isJetBrainsProduct = this.isJetBrainsProduct();
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)providers), arg_0 -> StatisticsEventLogProvidersHolder.getAllEventLogProviders$lambda$0(this, isJetBrainsProduct, arg_0));
    }

    private final boolean isJetBrainsProduct() {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        CharSequence charSequence = applicationInfo != null ? applicationInfo.getShortCompanyName() : null;
        return charSequence == null || charSequence.length() == 0 || PlatformUtils.isJetBrainsProduct();
    }

    private final boolean isProviderApplicable(boolean isJetBrainsProduct, String recorderId, StatisticsEventLoggerProvider extension) {
        if (Intrinsics.areEqual((Object)recorderId, (Object)extension.getRecorderId())) {
            if (!isJetBrainsProduct || !StatisticsRecorderUtil.isBuildInRecorder(recorderId)) {
                return true;
            }
            PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(extension.getClass());
            return Intrinsics.areEqual((Object)recorderId, (Object)"MLSE") || Intrinsics.areEqual((Object)recorderId, (Object)"ML") ? pluginInfo.isDevelopedByJetBrains() : pluginInfo.getType() == PluginType.PLATFORM || pluginInfo.getType() == PluginType.FROM_SOURCES || pluginInfo.isAllowedToInjectIntoFUS();
        }
        return false;
    }

    private static final void _init_$lambda$0(StatisticsEventLogProvidersHolder this$0) {
        this$0.eventLoggerProviders.set(this$0.calculateEventLogProvider());
    }

    private static final void _init_$lambda$1(StatisticsEventLogProvidersHolder this$0) {
        this$0.eventLoggerProvidersExt.set(this$0.calculateEventLogProviderExt());
    }

    private static final boolean getAllEventLogProviders$lambda$0(StatisticsEventLogProvidersHolder this$0, boolean $isJetBrainsProduct, StatisticsEventLoggerProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isProviderApplicable($isJetBrainsProduct, it.getRecorderId(), it);
    }
}

