/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.client.arenas;

import circlet.platform.api.ARecord;
import circlet.platform.api.ArenasKt;
import circlet.platform.api.OptionalRecord;
import circlet.platform.client.ArenaPersistence;
import circlet.platform.client.ResolvedRecord;
import circlet.platform.client.arenas.Etag;
import circlet.platform.client.arenas.EtagUnknown;
import circlet.platform.client.arenas.OptimisticRecord;
import circlet.platform.client.arenas.Record;
import circlet.platform.client.circlet.platform.client.arenas.ClientFailureReason;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u0002H/0.\"\b\b\u0000\u0010/*\u000200J\u0016\u00101\u001a\b\u0012\u0004\u0012\u0002H/02\"\b\b\u0000\u0010/*\u000200J+\u00103\u001a\u0004\u0018\u0001H/\"\b\b\u0000\u0010/*\u0002002\n\u00104\u001a\u00060\u0003j\u0002`52\u0006\u00106\u001a\u00020\u001e\u00a2\u0006\u0002\u00107J'\u00108\u001a\b\u0012\u0004\u0012\u0002H/09\"\b\b\u0000\u0010/*\u0002002\n\u00104\u001a\u00060\u0003j\u0002`5\u00a2\u0006\u0002\u0010:J\u000e\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>J\u0006\u0010?\u001a\u00020\u001eJ\u000e\u0010@\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u0003J\u001c\u0010A\u001a\u00020<2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020D0CH\u0086@\u00a2\u0006\u0002\u0010EJ\b\u0010F\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010&\u00a8\u0006G"}, d2={"Lcirclet/platform/client/arenas/ClientArenaRecordsCache;", "", "arenaId", "", "persistence", "Lcirclet/platform/client/ArenaPersistence;", "<init>", "(Ljava/lang/String;Lcirclet/platform/client/ArenaPersistence;)V", "getArenaId", "()Ljava/lang/String;", "getPersistence", "()Lcirclet/platform/client/ArenaPersistence;", "records", "", "Lcirclet/platform/client/arenas/Record;", "getRecords", "()Ljava/util/Map;", "etag", "Lcirclet/platform/client/arenas/Etag;", "getEtag", "()Lcirclet/platform/client/arenas/Etag;", "setEtag", "(Lcirclet/platform/client/arenas/Etag;)V", "etagFullyLoaded", "getEtagFullyLoaded", "setEtagFullyLoaded", "hasAllUpdatesFromEtag", "getHasAllUpdatesFromEtag", "setHasAllUpdatesFromEtag", "loadedFully", "", "getLoadedFully", "()Z", "setLoadedFully", "(Z)V", "size", "", "getSize", "()I", "recordIds", "", "getRecordIds", "()Ljava/util/Set;", "checksum", "getChecksum", "allRecords", "Lkotlin/sequences/Sequence;", "T", "Lcirclet/platform/api/ARecord;", "allRecordsList", "", "lookupRef", "id", "Lcirclet/platform/api/TID;", "acceptUnresolved", "(Ljava/lang/String;Z)Lcirclet/platform/api/ARecord;", "lookupOptionalRef", "Lcirclet/platform/api/OptionalRecord;", "(Ljava/lang/String;)Lcirclet/platform/api/OptionalRecord;", "putOptimisticRecord", "", "optimistic", "Lcirclet/platform/client/arenas/OptimisticRecord;", "hasOptimisticUpdates", "needResolve", "persistUpdates", "actual", "", "Lcirclet/platform/client/ResolvedRecord;", "(Ljava/util/Collection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "platform-client"})
@SourceDebugExtension(value={"SMAP\nClientArenaRecordsCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientArenaRecordsCache.kt\ncirclet/platform/client/arenas/ClientArenaRecordsCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1611#2,9:117\n1863#2:126\n1864#2:128\n1620#2:129\n1782#2,4:130\n1611#2,9:134\n1863#2:143\n1864#2:145\n1620#2:146\n1611#2,9:147\n1863#2:156\n1864#2:158\n1620#2:159\n1755#2,3:161\n1#3:127\n1#3:144\n1#3:157\n1#3:160\n*S KotlinDebug\n*F\n+ 1 ClientArenaRecordsCache.kt\ncirclet/platform/client/arenas/ClientArenaRecordsCache\n*L\n22#1:117,9\n22#1:126\n22#1:128\n22#1:129\n22#1:130,4\n27#1:134,9\n27#1:143\n27#1:145\n27#1:146\n29#1:147,9\n29#1:156\n29#1:158\n29#1:159\n47#1:161,3\n22#1:127\n27#1:144\n29#1:157\n*E\n"})
public final class ClientArenaRecordsCache {
    @NotNull
    private final String arenaId;
    @Nullable
    private final ArenaPersistence persistence;
    @NotNull
    private final Map<String, Record> records;
    @NotNull
    private Etag etag;
    @NotNull
    private Etag etagFullyLoaded;
    @Nullable
    private Etag hasAllUpdatesFromEtag;
    private boolean loadedFully;

    public ClientArenaRecordsCache(@NotNull String arenaId, @Nullable ArenaPersistence persistence2) {
        Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
        this.arenaId = arenaId;
        this.persistence = persistence2;
        this.records = new LinkedHashMap();
        this.etag = EtagUnknown.INSTANCE;
        this.etagFullyLoaded = EtagUnknown.INSTANCE;
    }

    @NotNull
    public final String getArenaId() {
        return this.arenaId;
    }

    @Nullable
    public final ArenaPersistence getPersistence() {
        return this.persistence;
    }

    @NotNull
    public final Map<String, Record> getRecords() {
        return this.records;
    }

    @NotNull
    public final Etag getEtag() {
        return this.etag;
    }

    public final void setEtag(@NotNull Etag etag) {
        Intrinsics.checkNotNullParameter((Object)etag, (String)"<set-?>");
        this.etag = etag;
    }

    @NotNull
    public final Etag getEtagFullyLoaded() {
        return this.etagFullyLoaded;
    }

    public final void setEtagFullyLoaded(@NotNull Etag etag) {
        Intrinsics.checkNotNullParameter((Object)etag, (String)"<set-?>");
        this.etagFullyLoaded = etag;
    }

    @Nullable
    public final Etag getHasAllUpdatesFromEtag() {
        return this.hasAllUpdatesFromEtag;
    }

    public final void setHasAllUpdatesFromEtag(@Nullable Etag etag) {
        this.hasAllUpdatesFromEtag = etag;
    }

    public final boolean getLoadedFully() {
        return this.loadedFully;
    }

    public final void setLoadedFully(boolean bl) {
        this.loadedFully = bl;
    }

    /*
     * WARNING - void declaration
     */
    public final int getSize() {
        int n;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.records.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ARecord it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Record it = (Record)element$iv$iv;
            boolean bl2 = false;
            if (Record.value$default(it, false, 1, null) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$count$iv = (List)destination$iv$iv;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_4;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ARecord it = (ARecord)element$iv;
                boolean bl = false;
                if (!(!it.getArchived()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_4;
        }
        return n;
    }

    @NotNull
    public final Set<String> getRecordIds() {
        return this.records.keySet();
    }

    private final int getChecksum() {
        return this.records.size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends ARecord> Sequence<T> allRecords() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.records.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ARecord it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Record it = (Record)element$iv$iv;
            boolean bl2 = false;
            if (Record.value$default(it, false, 1, null) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Sequence sequence = CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<T of circlet.platform.client.arenas.ClientArenaRecordsCache.allRecords>");
        return sequence;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends ARecord> List<T> allRecordsList() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.records.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ARecord it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Record it = (Record)element$iv$iv;
            boolean bl2 = false;
            if (Record.value$default(it, false, 1, null) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final <T extends ARecord> T lookupRef(@NotNull String id2, boolean acceptUnresolved) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Record record2 = this.records.get(id2);
        return (T)(record2 != null ? record2.value(acceptUnresolved) : null);
    }

    @NotNull
    public final <T extends ARecord> OptionalRecord<T> lookupOptionalRef(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Object object = this.records.get(id2);
        if (object == null || (object = ((Record)object).optValue(this.arenaId, id2)) == null) {
            object = new OptionalRecord.Failed<Object>(this.arenaId, id2, null, new ClientFailureReason.RefNotFoundInCache(this.arenaId, id2));
        }
        return object;
    }

    public final void putOptimisticRecord(@NotNull OptimisticRecord optimistic) {
        Record oldRecord;
        Intrinsics.checkNotNullParameter((Object)optimistic, (String)"optimistic");
        if (!ArenasKt.isTemporary(optimistic.getRecord())) {
            String string = optimistic.getRecord().getTemporaryId();
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.records.remove(it);
            }
        }
        String key = optimistic.getRecord().getId();
        Record record2 = oldRecord = this.records.get(key);
        this.records.put(key, new Record(optimistic, record2 != null ? record2.getServer() : null));
    }

    public final boolean hasOptimisticUpdates() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.records.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Record it = (Record)element$iv;
                    boolean bl2 = false;
                    if (!(it.getOptimistic() != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean needResolve(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Record record2 = this.records.get(id2);
        return (record2 != null ? record2.getServer() : null) == null;
    }

    @Nullable
    public final Object persistUpdates(@NotNull Collection<ResolvedRecord> actual, @NotNull Continuation<? super Unit> $completion) {
        if (this.persistence != null && (!actual.isEmpty() || !this.persistence.isUpToDate(this.etag, this.etagFullyLoaded))) {
            Object object = this.persistence.persist(actual, this.etag, this.etagFullyLoaded, this.getChecksum(), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n            etag = " + this.etag + ", size = " + this.getSize() + ",\n            etagFL = " + this.etagFullyLoaded + ",\n            hasAllUpdatesFromEtag = " + this.hasAllUpdatesFromEtag + ",\n        "));
    }
}

