/*
 * Decompiled with CFR 0.152.
 */
package platform.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.Typography;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import platform.common.EmojiCommonKt;
import platform.common.EmojiFormat;
import platform.common.EmojiScale;
import platform.common.EmojiSize;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u0017J \u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a0\u00190\u00112\u0006\u0010\u0012\u001a\u00020\u0005JB\u0010\u001b\u001a\u00020\u001c2\u0018\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a0\u00190\u001e2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00110 2\u0006\u0010\u0012\u001a\u00020\u0005J(\u0010!\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0018\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a0\u00190\u0011JP\u0010\"\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u001a\b\b\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00110 2\u001e\u0010#\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00110 H\u0086\b\u00f8\u0001\u0000Jb\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a0\u00190\u001e2\u0006\u0010\u0012\u001a\u00020\u00052\u001a\b\b\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00110 2\u001e\u0010#\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00110 H\u0086\b\u00f8\u0001\u0000J\u000e\u0010$\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010(R\u0011\u0010+\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010(\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006-"}, d2={"Lplatform/common/EmojiCommon;", "", "<init>", "()V", "emojiHref", "", "emoji", "format", "Lplatform/common/EmojiFormat;", "size", "Lplatform/common/EmojiSize;", "scale", "Lplatform/common/EmojiScale;", "version", "", "(Ljava/lang/String;Lplatform/common/EmojiFormat;Lplatform/common/EmojiSize;Lplatform/common/EmojiScale;Ljava/lang/Long;)Ljava/lang/String;", "emojis", "", "text", "emojiUserInput", "emojiInMarkdown", "emojiFromMarkdown", "dropVariation", "", "findMatches", "Lkotlin/Pair;", "Lkotlin/ranges/IntRange;", "preprocessMatches", "", "matches", "", "getVariations", "Lkotlin/Function1;", "doDecorate", "decorate", "filterExisting", "undecorate", "NAME_PATTERN", "Lkotlin/text/Regex;", "getNAME_PATTERN", "()Lkotlin/text/Regex;", "USER_INPUT_PATTERN", "getUSER_INPUT_PATTERN", "MD_PATTERN", "getMD_PATTERN", "platform-common"})
@SourceDebugExtension(value={"SMAP\nEmojiCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmojiCommon.kt\nplatform/common/EmojiCommon\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n195#1,2:249\n197#1,5:255\n1159#2,3:244\n295#3,2:247\n1557#3:251\n1628#3,3:252\n1557#3:260\n1628#3,3:261\n*S KotlinDebug\n*F\n+ 1 EmojiCommon.kt\nplatform/common/EmojiCommon\n*L\n190#1:249,2\n190#1:255,5\n139#1:244,3\n160#1:247,2\n190#1:251\n190#1:252,3\n196#1:260\n196#1:261,3\n*E\n"})
public final class EmojiCommon {
    @NotNull
    public static final EmojiCommon INSTANCE = new EmojiCommon();
    @NotNull
    private static final Regex NAME_PATTERN = new Regex("[a-z0-9+\\-_]+");
    @NotNull
    private static final Regex USER_INPUT_PATTERN = new Regex(":([a-z0-9+\\-_]{1,100}):");
    @NotNull
    private static final Regex MD_PATTERN = new Regex(":" + EmojiCommonKt.getZwsp(Typography.INSTANCE) + "([a-z0-9+\\-_:]{1,100})" + EmojiCommonKt.getZwsp(Typography.INSTANCE) + ":");

    private EmojiCommon() {
    }

    @NotNull
    public final String emojiHref(@NotNull String emoji, @NotNull EmojiFormat format, @NotNull EmojiSize size, @NotNull EmojiScale scale, @Nullable Long version) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Intrinsics.checkNotNullParameter((Object)((Object)size), (String)"size");
        Intrinsics.checkNotNullParameter((Object)((Object)scale), (String)"scale");
        StringBuilder $this$emojiHref_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$emojiHref_u24lambda_u240.append("/emojis/");
        $this$emojiHref_u24lambda_u240.append(format.getStringValue());
        $this$emojiHref_u24lambda_u240.append('/');
        $this$emojiHref_u24lambda_u240.append(size.getStringValue());
        $this$emojiHref_u24lambda_u240.append('/');
        $this$emojiHref_u24lambda_u240.append(emoji);
        $this$emojiHref_u24lambda_u240.append(scale.suffix());
        if (version != null) {
            $this$emojiHref_u24lambda_u240.append("?version=");
            $this$emojiHref_u24lambda_u240.append(version);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String emojiHref$default(EmojiCommon emojiCommon, String string, EmojiFormat emojiFormat, EmojiSize emojiSize, EmojiScale emojiScale, Long l, int n, Object object) {
        if ((n & 0x10) != 0) {
            l = null;
        }
        return emojiCommon.emojiHref(string, emojiFormat, emojiSize, emojiScale, l);
    }

    @NotNull
    public final List<String> emojis(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)MD_PATTERN, (CharSequence)text2, (int)0, (int)2, null), EmojiCommon::emojis$lambda$1));
    }

    @NotNull
    public final String emojiUserInput(@NotNull String emoji) {
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        return ":" + emoji + ":";
    }

    @NotNull
    public final String emojiInMarkdown(@NotNull String emoji) {
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        return ":" + EmojiCommonKt.getZwsp(Typography.INSTANCE) + emoji + EmojiCommonKt.getZwsp(Typography.INSTANCE) + ":";
    }

    @NotNull
    public final String emojiFromMarkdown(@NotNull String text2, boolean dropVariation) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        char[] cArray = new char[]{':', EmojiCommonKt.getZwsp(Typography.INSTANCE)};
        String result2 = StringsKt.trim((String)text2, (char[])cArray);
        return !dropVariation ? result2 : StringsKt.substringBefore$default((String)result2, (String)"::", null, (int)2, null);
    }

    public static /* synthetic */ String emojiFromMarkdown$default(EmojiCommon emojiCommon, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return emojiCommon.emojiFromMarkdown(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<String, IntRange>> findMatches(@NotNull String text2) {
        void var3_3;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                MatchResult it = (MatchResult)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getRange().getFirst());
                it = (MatchResult)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getRange().getFirst()));
            }
        };
        comparator = SequencesKt.sortedWith((Sequence)Regex.findAll$default((Regex)USER_INPUT_PATTERN, (CharSequence)text2, (int)0, (int)2, null), (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    MatchResult it = (MatchResult)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getRange().getLast() - it.getRange().getFirst());
                    it = (MatchResult)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getRange().getLast() - it.getRange().getFirst()));
                }
                return n;
            }
        });
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void match;
            MatchResult matchResult = (MatchResult)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            char[] cArray = new char[]{':'};
            collection.add(TuplesKt.to((Object)StringsKt.trim((String)match.getValue(), (char[])cArray), (Object)match.getRange()));
        }
        return (List)var3_3;
    }

    public final void preprocessMatches(@NotNull List<Pair<String, IntRange>> matches2, @NotNull Function1<? super String, ? extends List<String>> getVariations, @NotNull String text2) {
        Intrinsics.checkNotNullParameter(matches2, (String)"matches");
        Intrinsics.checkNotNullParameter(getVariations, (String)"getVariations");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        int leftBorder = -1;
        Set rangesToRemove = new LinkedHashSet();
        int n = ((Collection)matches2).size();
        for (int i = 0; i < n; ++i) {
            Object v0;
            IntRange range3;
            String emoji;
            block3: {
                emoji = (String)matches2.get(i).getFirst();
                range3 = (IntRange)matches2.get(i).getSecond();
                if (range3.getFirst() <= leftBorder) {
                    ((Collection)rangesToRemove).add(matches2.get(i));
                    continue;
                }
                leftBorder = range3.getLast();
                List variations = CollectionsKt.sortedDescending((Iterable)((Iterable)getVariations.invoke((Object)emoji)));
                Iterable $this$firstOrNull$iv = variations;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String variation = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)text2, (String)(":" + variation + ":"), (int)(range3.getLast() + 1), (boolean)false, (int)4, null)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            String variation = v0;
            if (variation == null) continue;
            IntRange newRange = new IntRange(range3.getFirst(), range3.getLast() + variation.length() + 2);
            matches2.set(i, (Pair<String, IntRange>)TuplesKt.to((Object)(emoji + "::" + variation), (Object)newRange));
            leftBorder = newRange.getLast();
        }
        matches2.removeAll(rangesToRemove);
    }

    @NotNull
    public final String doDecorate(@NotNull String text2, @NotNull List<Pair<String, IntRange>> matches2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(matches2, (String)"matches");
        StringBuilder out = new StringBuilder();
        int lastCut = -1;
        for (Pair<String, IntRange> pair : matches2) {
            String emoji = (String)pair.component1();
            IntRange range3 = (IntRange)pair.component2();
            IntRange r = RangesKt.until((int)(lastCut + 1), (int)range3.getFirst());
            if (!r.isEmpty()) {
                out.append(StringsKt.substring((String)text2, (IntRange)r));
            }
            out.append(this.emojiInMarkdown(emoji));
            lastCut = range3.getLast();
        }
        if (lastCut + 1 < text2.length()) {
            String string = text2.substring(lastCut + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            out.append(string);
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String decorate(@NotNull String text2, @NotNull Function1<? super String, ? extends List<String>> getVariations, @NotNull Function1<? super List<String>, ? extends List<String>> filterExisting2) {
        void $this$mapTo$iv$iv$iv;
        void $this$map$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(getVariations, (String)"getVariations");
        Intrinsics.checkNotNullParameter(filterExisting2, (String)"filterExisting");
        boolean $i$f$decorate = false;
        EmojiCommon this_$iv = this;
        boolean $i$f$findMatches = false;
        List matches$iv = CollectionsKt.toMutableList((Collection)this_$iv.findMatches(text2));
        Iterable iterable = matches$iv;
        Function1<? super List<String>, ? extends List<String>> function1 = filterExisting2;
        boolean $i$f$map = false;
        void var12_11 = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            void it$iv;
            Pair pair = (Pair)item$iv$iv$iv;
            Collection collection = destination$iv$iv$iv;
            boolean bl = false;
            collection.add((String)it$iv.getFirst());
        }
        Set existing$iv = CollectionsKt.toSet((Iterable)((Iterable)function1.invoke((Object)((List)destination$iv$iv$iv))));
        CollectionsKt.removeAll((List)matches$iv, (Function1)((Function1)new Function1<Pair<? extends String, ? extends IntRange>, Boolean>((Set<String>)existing$iv){
            final /* synthetic */ Set<String> $existing;
            {
                this.$existing = $existing;
            }

            public final Boolean invoke(Pair<String, IntRange> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return !this.$existing.contains(it.getFirst());
            }
        }));
        this_$iv.preprocessMatches(matches$iv, getVariations, text2);
        List matches2 = matches$iv;
        return this.doDecorate(text2, matches2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<String, IntRange>> findMatches(@NotNull String text2, @NotNull Function1<? super String, ? extends List<String>> getVariations, @NotNull Function1<? super List<String>, ? extends List<String>> filterExisting2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(getVariations, (String)"getVariations");
        Intrinsics.checkNotNullParameter(filterExisting2, (String)"filterExisting");
        boolean $i$f$findMatches = false;
        List matches2 = CollectionsKt.toMutableList((Collection)this.findMatches(text2));
        Iterable iterable = matches2;
        Function1<? super List<String>, ? extends List<String>> function1 = filterExisting2;
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getFirst());
        }
        Set existing = CollectionsKt.toSet((Iterable)((Iterable)function1.invoke((Object)((List)destination$iv$iv))));
        CollectionsKt.removeAll((List)matches2, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */));
        this.preprocessMatches(matches2, getVariations, text2);
        return matches2;
    }

    @NotNull
    public final String undecorate(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return StringsKt.replace$default((String)text2, (String)String.valueOf(EmojiCommonKt.getZwsp(Typography.INSTANCE)), (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public final Regex getNAME_PATTERN() {
        return NAME_PATTERN;
    }

    @NotNull
    public final Regex getUSER_INPUT_PATTERN() {
        return USER_INPUT_PATTERN;
    }

    @NotNull
    public final Regex getMD_PATTERN() {
        return MD_PATTERN;
    }

    private static final String emojis$lambda$1(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return EmojiCommon.emojiFromMarkdown$default(INSTANCE, it.getValue(), false, 2, null);
    }
}

