/*
 * Decompiled with CFR 0.152.
 */
package runtime.x;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.MutableProperty;
import runtime.reactive.Property;
import runtime.reactive.PropertyKt;
import runtime.text.TextRange;
import runtime.text.TextRangeKt;
import runtime.x.SelectionVM;
import runtime.x.XTextModel;
import runtime.x.primitives.FocusKt;
import runtime.x.primitives.FocusVM;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0013\b\u0016\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\nJ\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020#H\u0016J\u0010\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020\u0004H\u0016J\b\u0010)\u001a\u00020%H\u0016J\u0018\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u001cH\u0016J \u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020#2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u001cH\u0002J\u0010\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u001fH\u0002J\b\u00101\u001a\u00020\u001cH\u0016J\b\u00102\u001a\u00020\u001cH\u0016J\b\u00103\u001a\u00020%H\u0016J\b\u00104\u001a\u00020%H\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u00065"}, d2={"Lruntime/x/XTextModelImpl;", "Lruntime/x/XTextModel;", "textState", "Lruntime/reactive/MutableProperty;", "", "focusVM", "Lruntime/x/primitives/FocusVM;", "<init>", "(Lruntime/reactive/MutableProperty;Lruntime/x/primitives/FocusVM;)V", "initialText", "(Ljava/lang/String;)V", "getTextState", "()Lruntime/reactive/MutableProperty;", "getFocusVM", "()Lruntime/x/primitives/FocusVM;", "setFocusVM", "(Lruntime/x/primitives/FocusVM;)V", "selectionVM", "Lruntime/x/SelectionVM;", "getSelectionVM", "()Lruntime/x/SelectionVM;", "setSelectionVM", "(Lruntime/x/SelectionVM;)V", "selectedText", "getSelectedText", "()Ljava/lang/String;", "isEmpty", "Lruntime/reactive/Property;", "", "()Lruntime/reactive/Property;", "lastIdx", "", "getLastIdx", "()I", "getSelectionRange", "Lruntime/text/TextRange;", "setSelectionRange", "", "range", "replaceAll", "result", "clear", "replaceSelection", "text", "selectAfterReplaced", "replaceRange", "selectionToReplace", "isSelectionAtPoint", "value", "isSelectionAtStartOfContent", "isSelectionAtEndOfContent", "moveCaretToEnd", "selectEntireText", "platform-ui"})
public final class XTextModelImpl
implements XTextModel {
    @NotNull
    private final MutableProperty<String> textState;
    @NotNull
    private FocusVM focusVM;
    @NotNull
    private SelectionVM selectionVM;
    @NotNull
    private final Property<Boolean> isEmpty;

    public XTextModelImpl(@NotNull MutableProperty<String> textState, @NotNull FocusVM focusVM) {
        Intrinsics.checkNotNullParameter(textState, (String)"textState");
        Intrinsics.checkNotNullParameter((Object)focusVM, (String)"focusVM");
        this.textState = textState;
        this.focusVM = focusVM;
        this.selectionVM = new SelectionVM();
        this.isEmpty = PropertyKt.toProperty(PropertyKt.map((Property)this.getTextState(), XTextModelImpl::isEmpty$lambda$0), Lifetime.Companion.getEternal(), ((CharSequence)this.getTextState().getValue()).length() == 0);
    }

    public /* synthetic */ XTextModelImpl(MutableProperty mutableProperty, FocusVM focusVM, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            focusVM = FocusKt.focusVM();
        }
        this(mutableProperty, focusVM);
    }

    @Override
    @NotNull
    public MutableProperty<String> getTextState() {
        return this.textState;
    }

    @Override
    @NotNull
    public FocusVM getFocusVM() {
        return this.focusVM;
    }

    @Override
    public void setFocusVM(@NotNull FocusVM focusVM) {
        Intrinsics.checkNotNullParameter((Object)focusVM, (String)"<set-?>");
        this.focusVM = focusVM;
    }

    public XTextModelImpl(@NotNull String initialText) {
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        this(PropertyKt.mutableProperty(initialText), null, 2, null);
    }

    public /* synthetic */ XTextModelImpl(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string);
    }

    @Override
    @NotNull
    public SelectionVM getSelectionVM() {
        return this.selectionVM;
    }

    @Override
    public void setSelectionVM(@NotNull SelectionVM selectionVM) {
        Intrinsics.checkNotNullParameter((Object)selectionVM, (String)"<set-?>");
        this.selectionVM = selectionVM;
    }

    @Override
    @NotNull
    public String getSelectedText() {
        String string = this.getTextState().getValue().substring(((TextRange)this.getSelectionVM().getSelection().getValue()).getStart(), TextRangeKt.getEnd((TextRange)this.getSelectionVM().getSelection().getValue()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @Override
    @NotNull
    public Property<Boolean> isEmpty() {
        return this.isEmpty;
    }

    private final int getLastIdx() {
        return this.getTextState().getValue().length();
    }

    @Override
    @NotNull
    public TextRange getSelectionRange() {
        return (TextRange)this.getSelectionVM().getSelection().getValue();
    }

    @Override
    public void setSelectionRange(@NotNull TextRange range3) {
        Intrinsics.checkNotNullParameter((Object)range3, (String)"range");
        this.getSelectionVM().setSelection(range3);
    }

    @Override
    public void replaceAll(@NotNull String result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.getTextState().setValue(result2);
    }

    @Override
    public void clear() {
        this.replaceAll("");
    }

    @Override
    public void replaceSelection(@NotNull String text2, boolean selectAfterReplaced) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.replaceRange(this.getSelectionRange(), text2, selectAfterReplaced);
    }

    private final void replaceRange(TextRange selectionToReplace, String result2, boolean selectAfterReplaced) {
        String text2 = this.getTextState().getValue();
        String string = text2.substring(0, selectionToReplace.getStart());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String prefix = string + result2;
        String string2 = text2.substring(TextRangeKt.getEnd(selectionToReplace));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String newText = prefix + string2;
        this.replaceAll(newText);
        if (selectAfterReplaced) {
            this.getSelectionVM().setSelection(TextRangeKt.rangeBetween(prefix.length(), prefix.length()));
        }
    }

    private final boolean isSelectionAtPoint(int value2) {
        return Intrinsics.areEqual((Object)this.getSelectionRange(), (Object)TextRangeKt.rangeBetween(value2, value2));
    }

    @Override
    public boolean isSelectionAtStartOfContent() {
        return this.isSelectionAtPoint(0);
    }

    @Override
    public boolean isSelectionAtEndOfContent() {
        return this.isSelectionAtPoint(this.getLastIdx());
    }

    @Override
    public void moveCaretToEnd() {
        this.setSelectionRange(TextRangeKt.rangeBetween(this.getLastIdx(), this.getLastIdx()));
    }

    @Override
    public void selectEntireText() {
        this.setSelectionRange(TextRangeKt.rangeBetween(0, this.getLastIdx()));
    }

    private static final boolean isEmpty$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() == 0;
    }
}

