/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.sudo;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.sudo.SudoCommandProvider;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.IdeUtilIoBundle;
import com.intellij.util.system.OS;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001f\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u0016J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u000e\u001a\u00020\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/execution/sudo/LocalSudoCommandProvider;", "Lcom/intellij/execution/sudo/SudoCommandProvider;", "<init>", "()V", "isAvailable", "", "sudoCommand", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "wrappedCommand", "prompt", "", "Lorg/jetbrains/annotations/Nls;", "envCommand", "", "commandLine", "intellij.platform.ide.util.io"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLocalSudoCommandProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalSudoCommandProvider.kt\ncom/intellij/execution/sudo/LocalSudoCommandProvider\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,69:1\n126#2:70\n153#2,3:71\n*S KotlinDebug\n*F\n+ 1 LocalSudoCommandProvider.kt\ncom/intellij/execution/sudo/LocalSudoCommandProvider\n*L\n66#1:70\n66#1:71,3\n*E\n"})
public class LocalSudoCommandProvider
implements SudoCommandProvider {
    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    @Nullable
    public GeneralCommandLine sudoCommand(@NotNull GeneralCommandLine wrappedCommand, @NotNull String prompt) {
        GeneralCommandLine generalCommandLine;
        Intrinsics.checkNotNullParameter((Object)wrappedCommand, (String)"wrappedCommand");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Collection collection = CollectionsKt.listOf((Object)wrappedCommand.getExePath());
        List<String> list = wrappedCommand.getParametersList().getList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getList(...)");
        List command = CollectionsKt.plus((Collection)collection, (Iterable)list);
        if (OS.CURRENT == OS.Windows) {
            Path path = PathManager.findBinFileWithException((String)"launcher.exe");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"findBinFileWithException(...)");
            Path launcherExe = path;
            Object[] objectArray = new String[2];
            objectArray[0] = ((Object)launcherExe).toString();
            Intrinsics.checkNotNullExpressionValue((Object)wrappedCommand.getExePath(), (String)"getExePath(...)");
            Collection collection2 = CollectionsKt.listOf((Object[])objectArray);
            List<String> list2 = wrappedCommand.getParametersList().getParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getParameters(...)");
            generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)collection2, (Iterable)list2));
        } else if (OS.CURRENT == OS.macOS) {
            String escapedCommand = CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" & \" \" & ", null, null, (int)0, null, LocalSudoCommandProvider::sudoCommand$lambda$0, (int)30, null);
            String string = StringUtil.escapeQuotes((String)prompt);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeQuotes(...)");
            String escapedPrompt = string;
            String[] stringArray = new String[]{ExecUtil.getOsascriptPath(), "-e", StringsKt.trimIndent((String)("\n            tell current application\n                activate\n                do shell script " + escapedCommand + " with prompt \"" + escapedPrompt + "\" with administrator privileges without altering line endings\n            end tell"))};
            GeneralCommandLine generalCommandLine2 = new GeneralCommandLine(stringArray);
            generalCommandLine = generalCommandLine2;
        } else if (PathEnvironmentVariableUtil.isOnPath("gksudo")) {
            Object[] escapedCommand = new String[]{"gksudo", "--message", prompt, "--"};
            GeneralCommandLine generalCommandLine3 = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])escapedCommand), (Iterable)this.envCommand(wrappedCommand)), (Iterable)command));
            generalCommandLine = generalCommandLine3;
        } else if (PathEnvironmentVariableUtil.isOnPath("kdesudo")) {
            Object[] escapedCommand = new String[]{"kdesudo", "--comment", prompt, "--"};
            GeneralCommandLine generalCommandLine4 = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])escapedCommand), (Iterable)this.envCommand(wrappedCommand)), (Iterable)command));
            generalCommandLine = generalCommandLine4;
        } else if (PathEnvironmentVariableUtil.isOnPath("pkexec")) {
            generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"pkexec"), (Iterable)this.envCommand(wrappedCommand)), (Iterable)command));
        } else if (ExecUtil.hasTerminalApp()) {
            String escapedCommandLine = CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" ", null, null, (int)0, null, LocalSudoCommandProvider::sudoCommand$lambda$1, (int)30, null);
            String escapedEnvCommand = CollectionsKt.joinToString$default((Iterable)this.envCommand(wrappedCommand), (CharSequence)" ", null, null, (int)0, null, LocalSudoCommandProvider::sudoCommand$lambda$2, (int)30, null);
            File script = ExecUtil.createTempExecutableScript("sudo", ".sh", StringsKt.trimIndent((String)("\n            #!/bin/sh\n            echo " + CommandLineUtil.posixQuote((String)prompt) + "\n            echo\n            sudo -- " + escapedEnvCommand + " " + escapedCommandLine + "\n            STATUS=$?\n            echo\n            read -p \"Press Enter to close this window...\" TEMP\n            exit $STATUS")));
            String string = IdeUtilIoBundle.message("terminal.title.install", new Object[0]);
            String string2 = script.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            generalCommandLine = new GeneralCommandLine(ExecUtil.getTerminalCommand(string, string2));
        } else {
            generalCommandLine = null;
        }
        return generalCommandLine;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> envCommand(@NotNull GeneralCommandLine commandLine) {
        List list;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Map<String, String> map = commandLine.getEnvironment();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getEnvironment(...)");
        Map<String, String> env2 = map;
        if (Intrinsics.areEqual(env2, (Object)MapsKt.emptyMap())) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map<String, String> map2 = env2;
            Collection collection = CollectionsKt.listOf((Object)"env");
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void entry;
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator2.next();
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(entry.getKey() + "=" + entry.getValue());
            }
            list = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        }
        return list;
    }

    private static final CharSequence sudoCommand$lambda$0(String it) {
        Intrinsics.checkNotNull((Object)it);
        return ExecUtil.INSTANCE.escapeAppleScriptArgument$intellij_platform_ide_util_io(it);
    }

    private static final CharSequence sudoCommand$lambda$1(String it) {
        String string = CommandLineUtil.posixQuote((String)it);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"posixQuote(...)");
        return string;
    }

    private static final CharSequence sudoCommand$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = CommandLineUtil.posixQuote((String)it);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"posixQuote(...)");
        return string;
    }
}

