/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import kotlin.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.basics.DebugKt;
import libraries.basics.DevEnv;
import libraries.collections.Collections;
import libraries.collections.MutableSetLike;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeSource;
import libraries.coroutines.extra.LifetimeUtilsKt;
import libraries.klogging.BaseLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.CellTracker;
import runtime.reactive.CellTrackerKt;
import runtime.reactive.ComputedExpression;
import runtime.reactive.ComputedKt;
import runtime.reactive.DependenciesState;
import runtime.reactive.DevTool;
import runtime.reactive.Property;
import runtime.reactive.PropertyLiveKt;
import runtime.reactive.ReactionsKt;
import runtime.reactive.TransactionalReactionsScheduler;
import runtime.reactive.XTrackableLifetimed;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u000f\u001a\u0014\u0012\f\u0012\n\u0012\u0002\b\u00030\u0013j\u0002`\u00120\u0011j\u0002`\u00102\u0006\u0010\u0014\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u00020\u00072\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J\u001d\u0010\u0019\u001a\u00020\u00072\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u00030\u0013j\u0002`\u0012H\u0002\u00a2\u0006\u0002\u0010\u001bJ/\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00032\u0018\u0010\u001d\u001a\u0014\u0012\f\u0012\n\u0012\u0002\b\u00030\u0013j\u0002`\u00120\u0011j\u0002`\u0010H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0006\u0010\u001f\u001a\u00020\u0007J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\u000f\u001a\u00020\u0007H\u0002J\u0006\u0010\"\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lruntime/reactive/Effect;", "", "parentLifetime", "Llibraries/coroutines/extra/Lifetime;", "expression", "Lkotlin/Function1;", "Lruntime/reactive/XTrackableLifetimed;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Llibraries/coroutines/extra/Lifetime;Lkotlin/jvm/functions/Function1;)V", "executionLifetime", "Llibraries/coroutines/extra/LifetimeSource;", "dependenciesState", "Lruntime/reactive/DependenciesState;", "execute", "Lruntime/reactive/CellTrackerDependencies;", "Llibraries/collections/MutableSetLike;", "Lruntime/reactive/CellTrackerDependency;", "Lruntime/reactive/Property;", "lifetime", "(Llibraries/coroutines/extra/LifetimeSource;)Llibraries/collections/MutableSetLike;", "markAsPossiblyStale", "dependency", "Lruntime/reactive/ComputedExpression;", "markAsStale", "cause", "(Lruntime/reactive/Property;)V", "trackDependencies", "dependencies", "(Llibraries/coroutines/extra/Lifetime;Llibraries/collections/MutableSetLike;)V", "invalidate", "isNeedToBeReexecuted", "", "run", "platform-ui"})
@SourceDebugExtension(value={"SMAP\nReactions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Reactions.kt\nruntime/reactive/Effect\n+ 2 DebugCommon.kt\nlibraries/basics/DebugCommonKt\n+ 3 Debug.kt\nlibraries/basics/DebugKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,298:1\n29#2,3:299\n29#2,3:302\n29#2,3:307\n29#2,3:310\n17#3:305\n1#4:306\n*S KotlinDebug\n*F\n+ 1 Reactions.kt\nruntime/reactive/Effect\n*L\n142#1:299,3\n176#1:302,3\n211#1:307,3\n188#1:310,3\n193#1:305\n*E\n"})
public final class Effect {
    @NotNull
    private final Lifetime parentLifetime;
    @NotNull
    private final Function1<XTrackableLifetimed, Unit> expression;
    @Nullable
    private LifetimeSource executionLifetime;
    @NotNull
    private DependenciesState dependenciesState;

    public Effect(@NotNull Lifetime parentLifetime, @NotNull Function1<? super XTrackableLifetimed, Unit> expression) {
        Intrinsics.checkNotNullParameter((Object)parentLifetime, (String)"parentLifetime");
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        this.parentLifetime = parentLifetime;
        this.expression = expression;
        boolean $i$f$ifDevEnv = false;
        if (DebugKt.getIS_DEV_ENV()) {
            DevEnv $this$_init__u24lambda_u240 = DevEnv.INSTANCE;
            boolean bl = false;
            DevTool devTool = CellTrackerKt.getDevTool($this$_init__u24lambda_u240);
            if (devTool != null) {
                devTool.onCreateEffect(this.parentLifetime, this);
            }
        }
        this.dependenciesState = DependenciesState.NotTracked.INSTANCE;
    }

    @NotNull
    public final MutableSetLike<Property<?>> execute(@NotNull LifetimeSource lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        MutableSetLike<Property<?>> dependencies = Collections.INSTANCE.fastSet();
        CellTracker.INSTANCE.frameAccess((Function1)new Function1<Property<?>, Unit>(dependencies){

            public final void invoke(Property<?> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((MutableSetLike)this.receiver).add(p0);
            }
        }, () -> Effect.execute$lambda$1(this, lifetime));
        return dependencies;
    }

    private final void markAsPossiblyStale(ComputedExpression<?> dependency) {
        ReactionsKt.markAsPossiblyStale(dependency, this.dependenciesState, (Function1<? super DependenciesState.Tracked.PossiblyStale, Unit>)((Function1)arg_0 -> Effect.markAsPossiblyStale$lambda$2(this, arg_0)), (Function0<Unit>)((Function0)() -> Effect.markAsPossiblyStale$lambda$3(this)));
    }

    private final void markAsStale(Property<?> cause) {
        ReactionsKt.markAsStale(this.dependenciesState, (Function1<? super DependenciesState.Tracked.Stale, Unit>)((Function1)arg_0 -> Effect.markAsStale$lambda$4(this, arg_0)), (Function0<Unit>)((Function0)() -> Effect.markAsStale$lambda$5(this)));
    }

    private final void trackDependencies(Lifetime executionLifetime, MutableSetLike<Property<?>> dependencies) {
        if (!executionLifetime.isTerminated()) {
            boolean $i$f$ifDevEnv = false;
            if (DebugKt.getIS_DEV_ENV()) {
                DevEnv $this$trackDependencies_u24lambda_u246 = DevEnv.INSTANCE;
                boolean bl = false;
                DevTool devTool = CellTrackerKt.getDevTool($this$trackDependencies_u24lambda_u246);
                if (devTool != null) {
                    devTool.onTrackDependenciesEffect(this, dependencies);
                }
            }
            LifetimeSource trackingLifetime = LifetimeUtilsKt.nested(executionLifetime);
            this.dependenciesState = DependenciesState.Tracked.UpToDate.INSTANCE;
            Effect $this$getDbgName$iv = this;
            boolean $i$f$getDbgName = false;
            ComputedKt.trackDependencies(trackingLifetime, dependencies, arg_0 -> Effect.trackDependencies$lambda$7(this, arg_0), arg_0 -> Effect.trackDependencies$lambda$9(this, arg_0), null);
        } else {
            this.dependenciesState = DependenciesState.NotTracked.INSTANCE;
        }
    }

    public final void invalidate() {
        if (this.parentLifetime.isTerminated()) {
            return;
        }
        boolean needsToBeReexecuted = this.isNeedToBeReexecuted();
        if (needsToBeReexecuted) {
            this.execute();
        } else {
            this.dependenciesState = DependenciesState.Tracked.UpToDate.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isNeedToBeReexecuted() {
        void var3_3;
        block2: {
            Pair<Boolean, ComputedExpression<?>> pair = ReactionsKt.isNeedToBeReexecuted(this.parentLifetime, (Function0<? extends DependenciesState>)((Function0)() -> Effect.isNeedToBeReexecuted$lambda$11(this)));
            boolean bl = false;
            boolean result2 = (Boolean)pair.component1();
            ComputedExpression cause = (ComputedExpression)pair.component2();
            boolean $i$f$ifDevEnv = false;
            if (!DebugKt.getIS_DEV_ENV()) break block2;
            DevEnv $this$isNeedToBeReexecuted_u24lambda_u2413_u24lambda_u2412 = DevEnv.INSTANCE;
            boolean bl2 = false;
            if (cause != null) {
                DevTool devTool = CellTrackerKt.getDevTool($this$isNeedToBeReexecuted_u24lambda_u2413_u24lambda_u2412);
                if (devTool != null) {
                    devTool.onReexecuteEffect(this, cause);
                }
            }
        }
        return (boolean)var3_3;
    }

    private final void execute() {
        LifetimeSource executionLifetime;
        if (this.parentLifetime.isTerminated()) {
            return;
        }
        LifetimeSource lifetimeSource = this.executionLifetime;
        if (lifetimeSource != null) {
            lifetimeSource.terminate();
        }
        this.executionLifetime = executionLifetime = LifetimeUtilsKt.nested(this.parentLifetime);
        MutableSetLike<Property<?>> dependencies = this.execute(executionLifetime);
        this.trackDependencies(executionLifetime, dependencies);
    }

    public final void run() {
        if (this.parentLifetime.isTerminated()) {
            this.dependenciesState = DependenciesState.NotTracked.INSTANCE;
            return;
        }
        this.parentLifetime.add((Function)((Function0)() -> Effect.run$lambda$14(this)));
        this.execute();
    }

    private static final Unit execute$lambda$1(Effect this$0, LifetimeSource $lifetime) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$lifetime, (String)"$lifetime");
        try {
            this$0.expression.invoke((Object)PropertyLiveKt.XTrackableLifetimed($lifetime));
        }
        catch (Throwable e) {
            BaseLogger.DefaultImpls.error$default(ReactionsKt.access$getLog$p(), e, null, 2, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit markAsPossiblyStale$lambda$2(Effect this$0, DependenciesState.Tracked.PossiblyStale it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.dependenciesState = it;
        return Unit.INSTANCE;
    }

    private static final Unit markAsPossiblyStale$lambda$3(Effect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TransactionalReactionsScheduler.INSTANCE.schedule(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit markAsStale$lambda$4(Effect this$0, DependenciesState.Tracked.Stale it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.dependenciesState = it;
        return Unit.INSTANCE;
    }

    private static final Unit markAsStale$lambda$5(Effect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TransactionalReactionsScheduler.INSTANCE.schedule(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit trackDependencies$lambda$7(Effect this$0, ComputedExpression dependency) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        this$0.markAsPossiblyStale(dependency);
        return Unit.INSTANCE;
    }

    private static final Unit trackDependencies$lambda$9(Effect this$0, Property it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean $i$f$ifDevEnv = false;
        if (DebugKt.getIS_DEV_ENV()) {
            DevEnv $this$trackDependencies_u24lambda_u249_u24lambda_u248 = DevEnv.INSTANCE;
            boolean bl = false;
            DevTool devTool = CellTrackerKt.getDevTool($this$trackDependencies_u24lambda_u249_u24lambda_u248);
            if (devTool != null) {
                devTool.onReexecuteEffect(this$0, it);
            }
        }
        this$0.markAsStale(it);
        return Unit.INSTANCE;
    }

    private static final DependenciesState isNeedToBeReexecuted$lambda$11(Effect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.dependenciesState;
    }

    private static final Unit run$lambda$14(Effect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.dependenciesState = DependenciesState.NotTracked.INSTANCE;
        return Unit.INSTANCE;
    }
}

