/*
 * Decompiled with CFR 0.152.
 */
package circlet.app;

import circlet.app.UserStatusTillOptionsKt;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ADateKt;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.KotlinXDateTime;
import circlet.platform.api.PrimitivesExKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import runtime.date.DateFormat;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\r\u000e\u000f\u0010B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00060\nj\u0002`\tH&\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0000H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0004\u0011\u0012\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lcirclet/app/StatusTillOption;", "", "clearAfterText", "", "<init>", "(Ljava/lang/String;)V", "getClearAfterText", "()Ljava/lang/String;", "clearAt", "Lcirclet/platform/api/ADateTime;", "Lcirclet/platform/api/KotlinXDateTime;", "()Lcirclet/platform/api/KotlinXDateTime;", "withResetStartTime", "TillMinutesPass", "TillMidnight", "TillNextWeek", "TillDay", "Lcirclet/app/StatusTillOption$TillDay;", "Lcirclet/app/StatusTillOption$TillMidnight;", "Lcirclet/app/StatusTillOption$TillMinutesPass;", "Lcirclet/app/StatusTillOption$TillNextWeek;", "spaceport-app-state"})
public abstract class StatusTillOption {
    @NotNull
    private final String clearAfterText;

    private StatusTillOption(String clearAfterText) {
        this.clearAfterText = clearAfterText;
    }

    @NotNull
    public final String getClearAfterText() {
        return this.clearAfterText;
    }

    @NotNull
    public abstract KotlinXDateTime clearAt();

    @NotNull
    public abstract StatusTillOption withResetStartTime();

    public /* synthetic */ StatusTillOption(String clearAfterText, DefaultConstructorMarker $constructor_marker) {
        this(clearAfterText);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0000H\u0016R\u0017\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcirclet/app/StatusTillOption$TillDay;", "Lcirclet/app/StatusTillOption;", "date", "Lcirclet/platform/api/ADate;", "Lcirclet/platform/api/KotlinXDate;", "<init>", "(Lcirclet/platform/api/KotlinXDate;)V", "getDate", "()Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/KotlinXDate;", "clearAt", "Lcirclet/platform/api/KotlinXDateTime;", "withResetStartTime", "spaceport-app-state"})
    public static final class TillDay
    extends StatusTillOption {
        @NotNull
        private final KotlinXDate date;

        public TillDay(@NotNull KotlinXDate date2) {
            Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
            super(PrimitivesExKt.format(date2, DateFormat.MONTH_AND_DAY), null);
            this.date = date2;
        }

        @NotNull
        public final KotlinXDate getDate() {
            return this.date;
        }

        @Override
        @NotNull
        public KotlinXDateTime clearAt() {
            return ADateKt.toDateTimeAtEndOfDay(this.date);
        }

        @Override
        @NotNull
        public TillDay withResetStartTime() {
            return this;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0000H\u0016\u00a8\u0006\u0007"}, d2={"Lcirclet/app/StatusTillOption$TillMidnight;", "Lcirclet/app/StatusTillOption;", "<init>", "()V", "clearAt", "Lcirclet/platform/api/KotlinXDateTime;", "withResetStartTime", "spaceport-app-state"})
    public static final class TillMidnight
    extends StatusTillOption {
        public TillMidnight() {
            super("Today", null);
        }

        @Override
        @NotNull
        public KotlinXDateTime clearAt() {
            return UserStatusTillOptionsKt.access$nextMidnight(ADateJvmKt.getANow());
        }

        @Override
        @NotNull
        public TillMidnight withResetStartTime() {
            return this;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0000H\u0016R\u0017\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcirclet/app/StatusTillOption$TillMinutesPass;", "Lcirclet/app/StatusTillOption;", "startTime", "Lcirclet/platform/api/ADateTime;", "Lcirclet/platform/api/KotlinXDateTime;", "intervalMinutes", "", "clearAfterText", "", "<init>", "(Lcirclet/platform/api/KotlinXDateTime;ILjava/lang/String;)V", "getStartTime", "()Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/KotlinXDateTime;", "getIntervalMinutes", "()I", "clearAt", "withResetStartTime", "spaceport-app-state"})
    public static final class TillMinutesPass
    extends StatusTillOption {
        @NotNull
        private final KotlinXDateTime startTime;
        private final int intervalMinutes;

        public TillMinutesPass(@NotNull KotlinXDateTime startTime, int intervalMinutes, @NotNull String clearAfterText) {
            Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
            Intrinsics.checkNotNullParameter((Object)clearAfterText, (String)"clearAfterText");
            super(clearAfterText, null);
            this.startTime = startTime;
            this.intervalMinutes = intervalMinutes;
        }

        @NotNull
        public final KotlinXDateTime getStartTime() {
            return this.startTime;
        }

        public final int getIntervalMinutes() {
            return this.intervalMinutes;
        }

        @Override
        @NotNull
        public KotlinXDateTime clearAt() {
            return ADateJvmKt.plusMinutes(this.startTime, this.intervalMinutes);
        }

        @Override
        @NotNull
        public TillMinutesPass withResetStartTime() {
            return new TillMinutesPass(ADateJvmKt.getANow(), this.intervalMinutes, this.getClearAfterText());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00060\nj\u0002`\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0000H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcirclet/app/StatusTillOption$TillNextWeek;", "Lcirclet/app/StatusTillOption;", "firstDayOfWeek", "", "<init>", "(I)V", "getFirstDayOfWeek", "()I", "clearAt", "Lcirclet/platform/api/ADateTime;", "Lcirclet/platform/api/KotlinXDateTime;", "()Lcirclet/platform/api/KotlinXDateTime;", "withResetStartTime", "spaceport-app-state"})
    public static final class TillNextWeek
    extends StatusTillOption {
        private final int firstDayOfWeek;

        public TillNextWeek(int firstDayOfWeek) {
            super("This week", null);
            this.firstDayOfWeek = firstDayOfWeek;
        }

        public final int getFirstDayOfWeek() {
            return this.firstDayOfWeek;
        }

        @Override
        @NotNull
        public KotlinXDateTime clearAt() {
            return UserStatusTillOptionsKt.access$nextWeek(ADateJvmKt.getANow(), this.firstDayOfWeek);
        }

        @Override
        @NotNull
        public TillNextWeek withResetStartTime() {
            return this;
        }
    }
}

